/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;

public class SnapshotReader
implements BufferInput<SnapshotReader> {
    private final Buffer buffer;
    private final Snapshot snapshot;
    private final Serializer serializer;

    SnapshotReader(Buffer buffer, Snapshot snapshot, Serializer serializer) {
        this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        this.snapshot = (Snapshot)Assert.notNull((Object)snapshot, (String)"snapshot");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
    }

    public long remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public SnapshotReader skip(long bytes) {
        this.buffer.skip(bytes);
        return this;
    }

    public <T> T readObject() {
        return (T)this.serializer.readObject(this.buffer);
    }

    public SnapshotReader read(Bytes bytes) {
        this.buffer.read(bytes);
        return this;
    }

    public SnapshotReader read(byte[] bytes) {
        this.buffer.read(bytes);
        return this;
    }

    public SnapshotReader read(Bytes bytes, long offset, long length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    public SnapshotReader read(byte[] bytes, long offset, long length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    public SnapshotReader read(Buffer buffer) {
        this.buffer.read(buffer);
        return this;
    }

    public int readByte() {
        return this.buffer.readByte();
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public String readString() {
        return this.buffer.readString();
    }

    public String readUTF8() {
        return this.buffer.readUTF8();
    }

    public void close() {
        this.buffer.close();
        this.snapshot.closeReader(this);
    }
}

