/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;

public class SnapshotWriter
implements BufferOutput<SnapshotWriter> {
    final Buffer buffer;
    private final Snapshot snapshot;
    private final Serializer serializer;

    SnapshotWriter(Buffer buffer, Snapshot snapshot, Serializer serializer) {
        this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        this.snapshot = (Snapshot)Assert.notNull((Object)snapshot, (String)"snapshot");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
    }

    public SnapshotWriter writeObject(Object object) {
        this.serializer.writeObject(object, this.buffer);
        return this;
    }

    public SnapshotWriter write(Bytes bytes) {
        this.buffer.write(bytes);
        return this;
    }

    public SnapshotWriter write(byte[] bytes) {
        this.buffer.write(bytes);
        return this;
    }

    public SnapshotWriter write(Bytes bytes, long offset, long length) {
        this.buffer.write(bytes, offset, length);
        return this;
    }

    public SnapshotWriter write(byte[] bytes, long offset, long length) {
        this.buffer.write(bytes, offset, length);
        return this;
    }

    public SnapshotWriter write(Buffer buffer) {
        this.buffer.write(buffer);
        return this;
    }

    public SnapshotWriter writeByte(int b) {
        this.buffer.writeByte(b);
        return this;
    }

    public SnapshotWriter writeUnsignedByte(int b) {
        this.buffer.writeUnsignedByte(b);
        return this;
    }

    public SnapshotWriter writeChar(char c) {
        this.buffer.writeChar(c);
        return this;
    }

    public SnapshotWriter writeShort(short s) {
        this.buffer.writeShort(s);
        return this;
    }

    public SnapshotWriter writeUnsignedShort(int s) {
        this.buffer.writeUnsignedShort(s);
        return this;
    }

    public SnapshotWriter writeMedium(int m) {
        this.buffer.writeMedium(m);
        return this;
    }

    public SnapshotWriter writeUnsignedMedium(int m) {
        this.buffer.writeUnsignedMedium(m);
        return this;
    }

    public SnapshotWriter writeInt(int i) {
        this.buffer.writeInt(i);
        return this;
    }

    public SnapshotWriter writeUnsignedInt(long i) {
        this.buffer.writeUnsignedInt(i);
        return this;
    }

    public SnapshotWriter writeLong(long l) {
        this.buffer.writeLong(l);
        return this;
    }

    public SnapshotWriter writeFloat(float f) {
        this.buffer.writeFloat(f);
        return this;
    }

    public SnapshotWriter writeDouble(double d) {
        this.buffer.writeDouble(d);
        return this;
    }

    public SnapshotWriter writeBoolean(boolean b) {
        this.buffer.writeBoolean(b);
        return this;
    }

    public SnapshotWriter writeString(String s) {
        this.buffer.writeString(s);
        return this;
    }

    public SnapshotWriter writeUTF8(String s) {
        this.buffer.writeUTF8(s);
        return this;
    }

    public SnapshotWriter flush() {
        this.buffer.flush();
        return this;
    }

    public void close() {
        this.snapshot.closeWriter(this);
        this.buffer.close();
    }
}

