/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import io.atomix.copycat.server.cluster.Member;
import java.util.Objects;

public abstract class ConfigurationRequest
extends AbstractRequest {
    protected Member member;

    public Member member() {
        return this.member;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        serializer.writeObject((Object)this.member, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.member = (Member)serializer.readObject(buffer);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass().isAssignableFrom(object.getClass())) {
            return ((ConfigurationRequest)((Object)object)).member.equals(this.member);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[member=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.member);
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends ConfigurationRequest>
    extends AbstractRequest.Builder<T, U> {
        protected Builder(U request) {
            super(request);
        }

        public T withMember(Member member) {
            ((ConfigurationRequest)this.request).member = (Member)Assert.notNull((Object)member, (String)"member");
            return (T)((Object)this);
        }

        public U build() {
            super.build();
            Assert.state((((ConfigurationRequest)this.request).member != null ? 1 : 0) != 0, (String)"member cannot be null", (Object[])new Object[0]);
            return (U)((Object)((ConfigurationRequest)this.request));
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return ((Object)((Object)this)).getClass().isAssignableFrom(object.getClass()) && ((Builder)((Object)object)).request.equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.request);
        }
    }
}

