/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Arrays;
import java.util.Objects;

public class InstallRequest
extends AbstractRequest {
    private long term;
    private int leader;
    protected long index;
    protected int offset;
    protected byte[] data;
    protected boolean complete;

    public static Builder builder() {
        return new Builder(new InstallRequest());
    }

    public static Builder builder(InstallRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public int leader() {
        return this.leader;
    }

    public long index() {
        return this.index;
    }

    public int offset() {
        return this.offset;
    }

    public byte[] data() {
        return this.data;
    }

    public boolean complete() {
        return this.complete;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.leader).writeLong(this.index).writeInt(this.offset).writeBoolean(this.complete);
        serializer.writeObject((Object)this.data, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.leader = buffer.readInt();
        this.index = buffer.readLong();
        this.offset = buffer.readInt();
        this.complete = buffer.readBoolean();
        this.data = (byte[])serializer.readObject(buffer);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.term, this.leader, this.index, this.offset, this.complete, this.data);
    }

    public boolean equals(Object object) {
        if (object instanceof InstallRequest) {
            InstallRequest request = (InstallRequest)((Object)object);
            return request.term == this.term && request.leader == this.leader && request.index == this.index && request.offset == this.offset && request.complete == this.complete && Arrays.equals(request.data, this.data);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, leader=%d, index=%d, offset=%d, data=%s, complete=%b]", ((Object)((Object)this)).getClass().getSimpleName(), this.term, this.leader, this.index, this.offset, this.data, this.complete);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, InstallRequest> {
        protected Builder(InstallRequest request) {
            super((AbstractRequest)request);
        }

        public Builder withTerm(long term) {
            ((InstallRequest)this.request).term = (Long)Assert.arg((Object)term, (term > 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withLeader(int leader) {
            ((InstallRequest)this.request).leader = leader;
            return this;
        }

        public Builder withIndex(long index) {
            ((InstallRequest)this.request).index = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"index must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withOffset(int offset) {
            ((InstallRequest)this.request).offset = (Integer)Assert.argNot((Object)offset, (offset < 0 ? 1 : 0) != 0, (String)"offset must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withData(byte[] snapshot) {
            ((InstallRequest)this.request).data = (byte[])Assert.notNull((Object)snapshot, (String)"data");
            return this;
        }

        public Builder withComplete(boolean complete) {
            ((InstallRequest)this.request).complete = complete;
            return this;
        }

        public InstallRequest build() {
            super.build();
            Assert.stateNot((((InstallRequest)this.request).term <= 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            Assert.argNot((((InstallRequest)this.request).index < 0L ? 1 : 0) != 0, (String)"index must be positive", (Object[])new Object[0]);
            Assert.notNull((Object)((InstallRequest)this.request).data, (String)"data");
            return (InstallRequest)this.request;
        }
    }
}

