/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.concurrent.CatalystThreadFactory;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.compaction.Compactor;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.TypedEntryPool;
import io.atomix.copycat.server.storage.util.EntryBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class Log
implements AutoCloseable {
    private final Storage storage;
    final SegmentManager segments;
    private final Compactor compactor;
    private final EntryBuffer entryBuffer;
    private final TypedEntryPool entryPool = new TypedEntryPool();
    private boolean open = true;

    protected Log(String name, Storage storage, Serializer serializer) {
        this.storage = (Storage)Assert.notNull((Object)storage, (String)"storage");
        this.segments = new SegmentManager(name, storage, serializer);
        this.compactor = new Compactor(storage, this.segments, Executors.newScheduledThreadPool(storage.compactionThreads(), (ThreadFactory)new CatalystThreadFactory("copycat-compactor-%d")));
        this.entryBuffer = new EntryBuffer(storage.entryBufferSize());
    }

    public Compactor compactor() {
        return this.compactor;
    }

    public Serializer serializer() {
        return this.segments.serializer();
    }

    public boolean isOpen() {
        return this.open;
    }

    private void assertIsOpen() {
        Assert.state((boolean)this.isOpen(), (String)"log is not open", (Object[])new Object[0]);
    }

    private void assertValidIndex(long index) {
        Assert.index((boolean)this.validIndex(index), (String)"invalid log index: %d", (Object[])new Object[]{index});
    }

    public boolean isEmpty() {
        this.assertIsOpen();
        return this.segments.firstSegment().isEmpty();
    }

    public long size() {
        this.assertIsOpen();
        return this.segments.segments().stream().mapToLong(Segment::size).sum();
    }

    public long length() {
        this.assertIsOpen();
        return this.segments.segments().stream().mapToLong(Segment::length).sum();
    }

    public long firstIndex() {
        return !this.isEmpty() ? this.segments.firstSegment().descriptor().index() : 0L;
    }

    public long lastIndex() {
        return !this.isEmpty() ? this.segments.lastSegment().lastIndex() : 0L;
    }

    public long nextIndex() {
        return this.lastIndex() + 1L;
    }

    private Segment currentSegment() {
        Segment segment = this.segments.currentSegment();
        if (segment.isFull()) {
            this.segments.currentSegment().flush();
            segment = this.segments.nextSegment();
        }
        return segment;
    }

    public <T extends Entry<T>> T create(Class<T> type) {
        Assert.notNull(type, (String)"type");
        this.assertIsOpen();
        return this.entryPool.acquire(type, this.currentSegment().nextIndex());
    }

    public long append(Entry entry) {
        Assert.notNull((Object)entry, (String)"entry");
        this.assertIsOpen();
        long index = this.currentSegment().append(entry);
        this.entryBuffer.append(entry);
        return index;
    }

    public long term(long index) {
        this.assertIsOpen();
        this.assertValidIndex(index);
        Segment segment = this.segments.segment(index);
        Assert.index((segment != null ? 1 : 0) != 0, (String)("invalid index: " + index), (Object[])new Object[0]);
        return segment.term(index);
    }

    public <T extends Entry> T get(long index) {
        this.assertIsOpen();
        this.assertValidIndex(index);
        Segment segment = this.segments.segment(index);
        Assert.index((segment != null ? 1 : 0) != 0, (String)("invalid index: " + index), (Object[])new Object[0]);
        Object entry = this.entryBuffer.get(index);
        if (entry == null) {
            entry = segment.get(index);
        }
        if (entry != null) {
            if (index == this.lastIndex()) {
                return entry;
            }
            Compaction.Mode mode = ((Entry)entry).getCompactionMode();
            if (mode == Compaction.Mode.DEFAULT) {
                mode = this.compactor.getDefaultCompactionMode();
            }
            switch (mode) {
                case SNAPSHOT: {
                    if (index <= this.compactor.snapshotIndex()) break;
                    return entry;
                }
                case RELEASE: 
                case QUORUM: {
                    if (index <= this.compactor.minorIndex() && !segment.isLive(index)) break;
                    return entry;
                }
                case FULL: 
                case SEQUENTIAL: 
                case EXPIRING: 
                case TOMBSTONE: {
                    if (index <= this.compactor.minorIndex() && index <= this.compactor.majorIndex() && !segment.isLive(index)) break;
                    return entry;
                }
            }
        }
        return null;
    }

    private boolean validIndex(long index) {
        long firstIndex = this.firstIndex();
        long lastIndex = this.lastIndex();
        return !this.isEmpty() && firstIndex <= index && index <= lastIndex;
    }

    public boolean contains(long index) {
        if (!this.validIndex(index)) {
            return false;
        }
        Segment segment = this.segments.segment(index);
        return segment != null && segment.contains(index);
    }

    public Log release(long index) {
        this.assertIsOpen();
        this.assertValidIndex(index);
        Segment segment = this.segments.segment(index);
        Assert.index((segment != null ? 1 : 0) != 0, (String)("invalid index: " + index), (Object[])new Object[0]);
        segment.release(index);
        return this;
    }

    public Log commit(long index) {
        this.assertIsOpen();
        if (index > 0L) {
            this.assertValidIndex(index);
            this.segments.commitIndex(index);
            if (this.storage.flushOnCommit()) {
                this.segments.currentSegment().flush();
            }
        }
        return this;
    }

    public Log skip(long entries) {
        this.assertIsOpen();
        Segment segment = this.segments.currentSegment();
        segment.skip(entries);
        return this;
    }

    public Log truncate() {
        return this.truncate(0L);
    }

    public Log truncate(long index) {
        this.assertIsOpen();
        if (index > 0L) {
            this.assertValidIndex(index);
        }
        Assert.index((index >= this.segments.commitIndex() ? 1 : 0) != 0, (String)"cannot truncate committed entries", (Object[])new Object[0]);
        if (this.lastIndex() == index) {
            return this;
        }
        for (Segment segment : this.segments.reverseSegments()) {
            if (segment.validIndex(index)) {
                segment.truncate(index);
                break;
            }
            if (segment.index() <= index) continue;
            this.segments.removeSegment(segment);
        }
        this.entryBuffer.clear();
        return this;
    }

    public void flush() {
        this.assertIsOpen();
        this.segments.currentSegment().flush();
    }

    @Override
    public void close() {
        this.assertIsOpen();
        this.flush();
        this.compactor.close();
        this.segments.close();
        this.open = false;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return String.format("%s[segments=%s]", this.getClass().getSimpleName(), this.segments);
    }
}

