/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.common;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.automatiko.engine.api.marshalling.ObjectMarshallingStrategy;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.process.executable.core.ServerlessExecutableProcess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonObjectMarshallingStrategy
implements ObjectMarshallingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(JacksonObjectMarshallingStrategy.class);
    protected ObjectMapper mapper;
    private boolean usePolomorfic = true;

    public JacksonObjectMarshallingStrategy(Process<?> process) {
        if (((AbstractProcess)process).process() instanceof ServerlessExecutableProcess) {
            this.usePolomorfic = false;
        }
        this.mapper = new ObjectMapper();
        if (this.usePolomorfic) {
            this.mapper.activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).build(), ObjectMapper.DefaultTyping.EVERYTHING, JsonTypeInfo.As.PROPERTY);
        }
        this.mapper.registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    }

    public boolean accept(Object object) {
        return true;
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        return this.log(this.mapper.writeValueAsBytes(object));
    }

    public Object unmarshal(String dataType, ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        if (object.length == 0) {
            return null;
        }
        if (this.usePolomorfic) {
            return this.mapper.readValue(this.log(object), Object.class);
        }
        return this.mapper.readTree(this.log(object));
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    protected byte[] log(byte[] data) {
        logger.debug("Variable content:: {}", (Object)new String(data, StandardCharsets.UTF_8));
        return data;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }
}

