/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.common.tlog;

import io.automatiko.engine.api.uow.TransactionLogStore;
import io.quarkus.arc.DefaultBean;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@DefaultBean
@ApplicationScoped
public class FileSystemTransactionLogStore
implements TransactionLogStore {
    private Path storage;

    public FileSystemTransactionLogStore(@ConfigProperty(name="quarkus.automatiko.persistence.transaction-log.folder") Optional<String> transactionLogFolder) {
        if (transactionLogFolder.isPresent()) {
            this.storage = Paths.get(transactionLogFolder.get(), new String[0]);
        }
    }

    public void store(String transactionId, String processId, String instanceId, byte[] content) {
        Path path = Paths.get(this.storage.toString(), transactionId, processId, instanceId);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] load(String processId, String instanceId) {
        String[] transactions = this.storage.toFile().list();
        try {
            if (transactions != null) {
                for (String transactionId : transactions) {
                    File transactionFolder = new File(this.storage.toFile(), transactionId);
                    File processIdFolder = new File(transactionFolder, processId);
                    String[] instances = processIdFolder.list((File dir, String name) -> name.equals(instanceId));
                    if (instances == null || instances.length != 1) continue;
                    return Files.readAllBytes(Paths.get(processIdFolder.getAbsolutePath(), instances[0]));
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<String> list(String processId) {
        String[] transactions = this.storage.toFile().list();
        LinkedHashSet<String> recoverable = new LinkedHashSet<String>();
        if (transactions != null) {
            for (String transactionId : transactions) {
                File transactionFolder = new File(this.storage.toFile(), transactionId);
                File processIdFolder = new File(transactionFolder, processId);
                String[] instances = processIdFolder.list();
                if (instances == null) continue;
                for (String instance : instances) {
                    recoverable.add(transactionId + "|" + instance);
                }
            }
        }
        return recoverable;
    }

    public void delete(String transactionId) {
        Path path = Paths.get(this.storage.toString(), transactionId);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(f -> f.delete());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete(String transactionId, String processId, String instanceId) {
        Path path = Paths.get(this.storage.toString(), transactionId, processId, instanceId);
        try {
            Files.deleteIfExists(path);
            Path processFolder = path.getParent();
            if (processFolder.toFile().list().length == 0) {
                Files.delete(processFolder);
                Path transactionFolder = processFolder.getParent();
                if (transactionFolder.toFile().list().length == 0) {
                    Files.delete(transactionFolder);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean contains(String processId, String instanceId) {
        String[] transactions = this.storage.toFile().list();
        if (transactions != null) {
            for (String transactionId : transactions) {
                File transactionFolder = new File(this.storage.toFile(), transactionId);
                File processIdFolder = new File(transactionFolder, processId);
                File instanceFolder = new File(processIdFolder, instanceId);
                if (!instanceFolder.exists()) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> list() {
        if (this.storage == null) {
            return Collections.emptySet();
        }
        String[] transactions = this.storage.toFile().list();
        if (transactions == null) {
            return Collections.emptySet();
        }
        return Stream.of(transactions).collect(Collectors.toSet());
    }
}

