/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.common.tlog;

import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessNodeInitializedEvent;
import io.automatiko.engine.api.event.process.ProcessNodeTriggeredEvent;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.MutableProcessInstances;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.services.uow.TransactionLogWorkUnit;
import io.automatiko.engine.workflow.base.instance.InternalProcessRuntime;
import io.automatiko.engine.workflow.process.core.node.StateBasedNode;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import io.automatiko.engine.workflow.process.core.node.TimerNode;
import io.automatiko.engine.workflow.process.instance.RecoveryItem;
import io.automatiko.engine.workflow.process.instance.node.LambdaSubProcessNodeInstance;
import io.automatiko.engine.workflow.process.instance.node.StateBasedNodeInstance;
import io.automatiko.engine.workflow.process.instance.node.TimerNodeInstance;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class TransactionLogEventListener
extends DefaultProcessEventListener {
    private boolean enabled;

    public TransactionLogEventListener(@ConfigProperty(name="quarkus.automatiko.persistence.transaction-log.enabled") Optional<Boolean> enabled) {
        this.enabled = enabled.orElse(false);
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        if (!this.enabled) {
            return;
        }
        if (this.requiresInitialization(event.getNodeInstance())) {
            return;
        }
        ProcessInstance pi = (ProcessInstance)((WorkflowProcessInstance)event.getProcessInstance()).getMetaData("AutomatikProcessInstance");
        TransactionLog transactionLog = pi.process().instances().transactionLog();
        if (transactionLog != null) {
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)event.getProcessRuntime();
            String transactionId = processRuntime.getUnitOfWorkManager().currentUnitOfWork().identifier();
            RecoveryItem recoveryItem = new RecoveryItem();
            recoveryItem.setTransactionId(transactionId);
            recoveryItem.setNodeDefinitionId(event.getNodeInstance().getNodeDefinitionId());
            ((io.automatiko.engine.workflow.process.instance.WorkflowProcessInstance)event.getProcessInstance()).setRecoveryItem(recoveryItem);
            processRuntime.getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new TransactionLogWorkUnit(transactionId, transactionLog));
            String instanceId = ((MutableProcessInstances)pi.process().instances()).resolveId(pi.id(), pi);
            transactionLog.record(transactionId, pi.process().id(), instanceId, event.getNodeInstance());
        }
    }

    public void afterNodeInitialized(ProcessNodeInitializedEvent event) {
        ProcessInstance pi;
        TransactionLog transactionLog;
        if (!this.enabled) {
            return;
        }
        if (this.requiresInitialization(event.getNodeInstance()) && (transactionLog = (pi = (ProcessInstance)((WorkflowProcessInstance)event.getProcessInstance()).getMetaData("AutomatikProcessInstance")).process().instances().transactionLog()) != null) {
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)event.getProcessRuntime();
            String transactionId = processRuntime.getUnitOfWorkManager().currentUnitOfWork().identifier();
            RecoveryItem recoveryItem = new RecoveryItem();
            recoveryItem.setTransactionId(transactionId);
            recoveryItem.setNodeDefinitionId(event.getNodeInstance().getNodeDefinitionId());
            if (event.getNodeInstance() instanceof LambdaSubProcessNodeInstance) {
                recoveryItem.setInstanceId(((LambdaSubProcessNodeInstance)event.getNodeInstance()).getProcessInstanceId());
            } else if (event.getNodeInstance() instanceof TimerNodeInstance) {
                recoveryItem.setTimerId(((TimerNodeInstance)event.getNodeInstance()).getTimerId());
            } else if (event.getNodeInstance() instanceof StateBasedNodeInstance) {
                recoveryItem.setStateTimerIds(((StateBasedNodeInstance)event.getNodeInstance()).getTimerInstances());
            }
            ((io.automatiko.engine.workflow.process.instance.WorkflowProcessInstance)event.getProcessInstance()).setRecoveryItem(recoveryItem);
            processRuntime.getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new TransactionLogWorkUnit(transactionId, transactionLog));
            String instanceId = ((MutableProcessInstances)pi.process().instances()).resolveId(pi.id(), pi);
            transactionLog.record(transactionId, pi.process().id(), instanceId, event.getNodeInstance());
        }
    }

    public boolean requiresInitialization(NodeInstance nodeInstance) {
        if (nodeInstance.getNode() instanceof SubProcessNode) {
            return true;
        }
        if (nodeInstance.getNode() instanceof TimerNode) {
            return true;
        }
        return nodeInstance.getNode() instanceof StateBasedNode;
    }
}

