/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.common.tlog;

import io.automatiko.engine.api.marshalling.ObjectMarshallingStrategy;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.TransactionLogStore;
import io.automatiko.engine.workflow.marshalling.ProcessInstanceMarshaller;
import java.util.Collections;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogImpl
implements TransactionLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionLogImpl.class);
    private boolean enabled;
    private final ProcessInstanceMarshaller marshaller;
    private final TransactionLogStore store;

    public TransactionLogImpl(TransactionLogStore store, ObjectMarshallingStrategy ... strategies) {
        this.store = store;
        this.marshaller = new ProcessInstanceMarshaller(strategies);
        this.enabled = ConfigProvider.getConfig().getOptionalValue("quarkus.automatiko.persistence.transaction-log.enabled", Boolean.class).orElse(false);
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    public void record(String transactionId, String processId, String instanceId, NodeInstance currentNodeInstance) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            byte[] content = this.marshaller.marhsallProcessInstance((ProcessInstance)currentNodeInstance.getProcessInstance(), new NodeInstance[]{currentNodeInstance});
            this.store.store(transactionId, processId, instanceId, content);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to record transaction log entry for node {} inside process instance {} (of process {})", new Object[]{currentNodeInstance, instanceId, processId, e});
        }
    }

    public void complete(String transactionId) {
        if (!this.isEnabled()) {
            return;
        }
        this.store.delete(transactionId);
    }

    public byte[] readContent(String processId, String instanceId) {
        if (!this.isEnabled()) {
            return null;
        }
        return this.store.load(processId, instanceId);
    }

    public Set<String> recoverable(String processId) {
        if (!this.isEnabled()) {
            return Collections.emptySet();
        }
        return this.store.list(processId);
    }

    public void complete(String transactionId, String processId, String instanceId) {
        if (!this.isEnabled()) {
            return;
        }
        this.store.delete(transactionId, processId, instanceId);
    }

    public boolean contains(String processId, String instanceId) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.store.contains(processId, instanceId);
    }

    public boolean requiresRecovery() {
        return this.store.list().size() > 0;
    }
}

