/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.persistence.common.tlog;

import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessErrors;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import io.quarkus.runtime.StartupEvent;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TransactionLogRecovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionLogRecovery.class);
    @Inject
    private Application application;
    @Inject
    private Instance<Process<?>> processes;

    public void recoverOnStart(@Observes @Priority(value=4000) StartupEvent event) {
        this.recovery();
    }

    public void recovery() {
        for (Process process : this.processes) {
            if (!"Public".equals(((WorkflowProcess)((AbstractProcess)process).process()).getVisibility())) continue;
            this.recoverByProcess(process);
        }
    }

    protected void recoverByProcess(Process<?> process) {
        TransactionLog transactionLog = process.instances().transactionLog();
        if (transactionLog != null && transactionLog.requiresRecovery()) {
            LOGGER.info("Transaction recovery required for process '{}'", (Object)process.id());
            Set recoverableInstances = transactionLog.recoverable(process.id());
            LOGGER.info("Checking process '{}' for recoverable instances, found {}", (Object)process.id(), (Object)recoverableInstances);
            if (recoverableInstances != null) {
                for (String instanceInfo : recoverableInstances) {
                    String[] elements = instanceInfo.split("\\|");
                    String instanceId = elements[1];
                    try {
                        boolean recovered = (Boolean)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                            Optional found = process.instances().findById(instanceId, -1, ProcessInstanceReadMode.MUTABLE);
                            if (found.isPresent()) {
                                ProcessInstance pi = (ProcessInstance)found.get();
                                if (pi.errors().isPresent()) {
                                    LOGGER.debug("Recovering instance '{}' from process '{}'", (Object)instanceId, (Object)process.id());
                                    ((ProcessErrors)pi.errors().get()).retrigger();
                                    LOGGER.info("Successfully recovered instance '{}' from process '{}'", (Object)instanceId, (Object)process.id());
                                    return true;
                                }
                                LOGGER.warn("Recovering instance '{}' from process '{}' cannot be completed due to missing node information", (Object)instanceId, (Object)process.id());
                            } else {
                                LOGGER.warn("Recovering instance '{}' from process '{}' failed at finding process instance", (Object)instanceId, (Object)process.id());
                            }
                            return false;
                        });
                        if (!recovered) continue;
                        transactionLog.complete(elements[0], process.id(), instanceId);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Recovery of instance '{}' resulted in exception '{}'", (Object)instanceId, (Object)e.getMessage());
                    }
                }
                if (process.subprocesses() != null) {
                    for (Process sProcess : process.subprocesses()) {
                        this.recoverByProcess(sProcess);
                    }
                }
            }
        }
    }
}

