/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.process.management;

import io.automatiko.engine.addons.process.management.ProcessInstanceManagement;
import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.auth.SecurityPolicy;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessError;
import io.automatiko.engine.api.workflow.ProcessErrors;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceExecutionException;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class BaseProcessInstanceManagementResource<T>
implements ProcessInstanceManagement<T> {
    private static final String PROCESS_AND_INSTANCE_REQUIRED = "Process id and Process instance id must be given";
    private static final String PROCESS_NOT_FOUND = "Process with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_FOUND = "Process instance with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_IN_ERROR = "Process instance with id %s is not in error state";
    protected Map<String, Process<?>> processData = new LinkedHashMap();
    protected Application application;

    public BaseProcessInstanceManagementResource(Map<String, Process<?>> processData, Application application) {
        this.processData = processData;
        this.application = application;
    }

    public T doGetInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ProcessErrors errors = (ProcessErrors)processInstance.errors().get();
            ArrayList errorsData = new ArrayList();
            for (ProcessError error : errors.errors()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", processInstance.id());
                data.put("failedNodeId", error.failedNodeId());
                data.put("message", error.errorMessage());
                errorsData.add(data);
            }
            return this.buildOkResponse(errorsData);
        });
    }

    public T doGetWorkItemsInProcessInstance(String processId, String processInstanceId) {
        return (T)this.executeOnInstance(processId, processInstanceId, "active", processInstance -> {
            List workItems = processInstance.workItems(new Policy[]{new SecurityPolicy(null){}});
            return this.buildOkResponse(workItems);
        });
    }

    public T doRetriggerInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessErrors)processInstance.errors().get()).retrigger();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doRetriggerInstanceInErrorByErrorId(String processId, String processInstanceId, String errorId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessErrors)processInstance.errors().get()).errors().stream().filter(e -> e.errorId().equals(errorId)).findFirst().ifPresent(e -> e.retrigger());
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doSkipInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessErrors)processInstance.errors().get()).skip();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doSkipInstanceInErrorByErrorId(String processId, String processInstanceId, String errorId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessErrors)processInstance.errors().get()).errors().stream().filter(e -> e.errorId().equals(errorId)).findFirst().ifPresent(e -> e.skip());
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doTriggerNodeInstanceId(String processId, String processInstanceId, String nodeId) {
        return (T)this.executeOnInstance(processId, processInstanceId, "active", processInstance -> {
            processInstance.triggerNode(nodeId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doRetriggerNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
        return (T)this.executeOnInstance(processId, processInstanceId, "active", processInstance -> {
            processInstance.retriggerNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doCancelNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
        return (T)this.executeOnInstance(processId, processInstanceId, "active", processInstance -> {
            processInstance.cancelNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doCancelProcessInstanceId(String processId, String processInstanceId, String status) {
        return (T)this.executeOnInstance(processId, processInstanceId, status, processInstance -> {
            processInstance.abort();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    private T executeOnInstanceInError(String processId, String processInstanceId, Function<ProcessInstance<?>, T> supplier) {
        if (processId == null || processInstanceId == null) {
            return this.badRequestResponse(PROCESS_AND_INSTANCE_REQUIRED);
        }
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            return this.notFoundResponse(String.format(PROCESS_NOT_FOUND, processId));
        }
        return (T)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId, 5, ProcessInstanceReadMode.MUTABLE_WITH_LOCK);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                if (processInstance.errors().isPresent()) {
                    return supplier.apply(processInstance);
                }
                return this.badRequestResponse(String.format(PROCESS_INSTANCE_NOT_IN_ERROR, processInstanceId));
            }
            return this.notFoundResponse(String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId));
        });
    }

    private T executeOnInstance(String processId, String processInstanceId, String status, Function<ProcessInstance<?>, T> supplier) {
        if (processId == null || processInstanceId == null) {
            return this.badRequestResponse(PROCESS_AND_INSTANCE_REQUIRED);
        }
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            return this.notFoundResponse(String.format(PROCESS_NOT_FOUND, processId));
        }
        return (T)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId, this.mapStatus(status), ProcessInstanceReadMode.MUTABLE_WITH_LOCK);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                return supplier.apply(processInstance);
            }
            return this.notFoundResponse(String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId));
        });
    }

    protected abstract <R> T buildOkResponse(R var1);

    protected abstract T badRequestResponse(String var1);

    protected abstract T notFoundResponse(String var1);

    protected int mapStatus(String status) {
        int state = 1;
        switch (status.toLowerCase()) {
            case "active": {
                state = 1;
                break;
            }
            case "completed": {
                state = 2;
                break;
            }
            case "aborted": {
                state = 3;
                break;
            }
            case "error": {
                state = 5;
                break;
            }
            default: {
                state = Integer.parseInt(status);
            }
        }
        return state;
    }

    protected String reverseMapStatus(int status) {
        String state = "active";
        switch (status) {
            case 1: {
                state = "active";
                break;
            }
            case 2: {
                state = "completed";
                break;
            }
            case 3: {
                state = "aborted";
                break;
            }
            case 5: {
                state = "error";
                break;
            }
        }
        return state;
    }
}

