/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.process.management.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;

public class JsonExportedProcessInstance
extends ExportedProcessInstance<JsonNode> {
    private static ObjectMapper mapper = new ObjectMapper();
    private List<JsonExportedProcessInstance> subInstances = new ArrayList<JsonExportedProcessInstance>();

    public JsonExportedProcessInstance() {
        super(null, null, null);
    }

    public JsonExportedProcessInstance(JsonNode header, JsonNode instance, JsonNode timers) {
        super((Object)header, (Object)instance, (Object)timers);
    }

    public void setSubInstances(List<JsonExportedProcessInstance> subinstances) {
        this.subInstances.addAll(subinstances);
    }

    public List<JsonExportedProcessInstance> getSubInstances() {
        return this.subInstances;
    }

    @Schema(type=SchemaType.OBJECT, implementation=Map.class)
    public JsonNode getHeader() {
        return (JsonNode)super.getHeader();
    }

    @Schema(type=SchemaType.OBJECT, implementation=Map.class)
    public JsonNode getInstance() {
        return (JsonNode)super.getInstance();
    }

    @Schema(type=SchemaType.OBJECT, implementation=List.class)
    public JsonNode getTimers() {
        return (JsonNode)super.getTimers();
    }

    public static JsonExportedProcessInstance of(ExportedProcessInstance<String> instance) {
        try {
            ObjectNode header = (ObjectNode)mapper.readTree((String)instance.getHeader());
            ObjectNode content = (ObjectNode)mapper.readTree((String)instance.getInstance());
            ArrayNode timers = (ArrayNode)mapper.readTree((String)instance.getTimers());
            return new JsonExportedProcessInstance((JsonNode)header, (JsonNode)content, (JsonNode)timers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Map<String, String>> convertTimers() {
        return (List)mapper.convertValue((Object)this.getTimers(), List.class);
    }

    public byte[] data() {
        try {
            return mapper.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to serialize exported instance", e);
        }
    }
}

