/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.NodeContainer;
import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.ContextContainer;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.BooleanDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.FloatDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.IntegerDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.StringDataType;
import io.automatiko.engine.workflow.bpmn2.core.Association;
import io.automatiko.engine.workflow.bpmn2.core.Definitions;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Lane;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.bpmn2.core.Signal;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.util.ClassUtils;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.compiler.xml.XmlDumper;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.impl.ExtendedNodeImpl;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.EndNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.ForEachNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractNodeHandler.class);
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKnowledgeRuntime().signalEvent(";
    static final String RUNTIME_MANAGER_SIGNAL_EVENT = "((org.kie.api.runtime.manager.RuntimeManager)kcontext.getKnowledgeRuntime().getEnvironment().get(\"RuntimeManager\")).signalEvent(";
    protected static final String EVENT_TYPE = "EventType";
    public static final String INPUT_TYPES = "BPMN.InputTypes";
    public static final String OUTPUT_TYPES = "BPMN.OutputTypes";
    protected static final String EOL = System.getProperty("line.separator");
    protected Map<String, String> dataInputs = new HashMap<String, String>();
    protected Map<String, String> dataInputTypes = new HashMap<String, String>();
    protected Map<String, String> dataOutputs = new HashMap<String, String>();
    protected Map<String, String> dataOutputTypes = new HashMap<String, String>();
    protected Map<String, String> inputAssociation = new HashMap<String, String>();
    protected Map<String, String> outputAssociation = new HashMap<String, String>();
    private static final String SIGNAL_NAMES = "signalNames";

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(io.automatiko.engine.workflow.process.core.NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(io.automatiko.engine.workflow.process.core.Node.class);
        this.validPeers.add(SequenceFlow.class);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Association.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        this.dataInputs = new HashMap<String, String>();
        this.dataOutputs = new HashMap<String, String>();
        this.dataInputTypes = new HashMap<String, String>();
        this.dataOutputTypes = new HashMap<String, String>();
        parser.startElementBuilder(localName, attrs);
        io.automatiko.engine.workflow.process.core.Node node = this.createNode(attrs);
        String id = attrs.getValue("id");
        node.setMetaData("UniqueId", (Object)id);
        String name = attrs.getValue("name");
        node.setName(name);
        node.setMetaData(INPUT_TYPES, this.dataInputTypes);
        node.setMetaData(OUTPUT_TYPES, this.dataOutputTypes);
        AtomicInteger idGen = (AtomicInteger)parser.getMetaData().get("idGen");
        node.setId((long)idGen.getAndIncrement());
        return node;
    }

    protected abstract io.automatiko.engine.workflow.process.core.Node createNode(Attributes var1);

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        io.automatiko.engine.workflow.process.core.NodeContainer nodeContainer = (io.automatiko.engine.workflow.process.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", (Object)Integer.parseInt(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", (Object)new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", (Object)new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", (Object)new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
    }

    public abstract void writeNode(io.automatiko.engine.workflow.process.core.Node var1, StringBuilder var2, int var3);

    protected void writeNode(String name, io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <" + name + " ");
        xmlDump.append("id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)node) + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(node.getName()) + "\" ");
        }
        if (metaDataType == 1) {
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x != null && x != 0) {
                xmlDump.append("g:x=\"" + x + "\" ");
            }
            if (y != null && y != 0) {
                xmlDump.append("g:y=\"" + y + "\" ");
            }
            if (width != null && width != -1) {
                xmlDump.append("g:width=\"" + width + "\" ");
            }
            if (height != null && height != -1) {
                xmlDump.append("g:height=\"" + height + "\" ");
            }
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }

    protected void handleScript(ExtendedNodeImpl node, Element element, String type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element xmlNode;
            String nodeName;
            if (!(nodeList.item(i) instanceof Element) || !(nodeName = (xmlNode = (Element)nodeList.item(i)).getNodeName()).equals("extensionElements")) continue;
            NodeList subNodeList = xmlNode.getChildNodes();
            for (int j = 0; j < subNodeList.getLength(); ++j) {
                org.w3c.dom.Node subXmlNode = subNodeList.item(j);
                if (!subXmlNode.getNodeName().contains(type + "-script")) continue;
                ArrayList<ProcessAction> actions = node.getActions(type);
                if (actions == null) {
                    actions = new ArrayList<ProcessAction>();
                    node.setActions(type, actions);
                }
                ProcessAction action = AbstractNodeHandler.extractScript((Element)subXmlNode);
                actions.add(action);
            }
        }
    }

    public static ProcessAction extractScript(Element xmlNode) {
        String dialect = "mvel";
        if ("http://www.java.com/java".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "java";
        } else if ("http://www.javascript.com/javascript".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "JavaScript";
        }
        NodeList subNodeList = xmlNode.getChildNodes();
        for (int j = 0; j < subNodeList.getLength(); ++j) {
            Element subXmlNode;
            if (!(subNodeList.item(j) instanceof Element) || !"script".equals((subXmlNode = (Element)subNodeList.item(j)).getNodeName())) continue;
            String consequence = subXmlNode.getTextContent();
            ConsequenceAction action = new ConsequenceAction(dialect, consequence);
            return action;
        }
        return new ConsequenceAction("mvel", "");
    }

    protected void writeMetaData(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump) {
        XmlBPMNProcessDumper.writeMetaData(this.getMetaData(node), xmlDump);
    }

    protected Map<String, Object> getMetaData(io.automatiko.engine.workflow.process.core.Node node) {
        return XmlBPMNProcessDumper.getMetaData(node.getMetaData());
    }

    protected void writeExtensionElements(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump) {
        if (this.containsExtensionElements(node)) {
            xmlDump.append("      <extensionElements>" + EOL);
            if (node instanceof ExtendedNodeImpl) {
                this.writeScripts("onEntry", ((ExtendedNodeImpl)node).getActions("onEntry"), xmlDump);
                this.writeScripts("onExit", ((ExtendedNodeImpl)node).getActions("onExit"), xmlDump);
            }
            this.writeMetaData(node, xmlDump);
            xmlDump.append("      </extensionElements>" + EOL);
        }
    }

    protected boolean containsExtensionElements(io.automatiko.engine.workflow.process.core.Node node) {
        if (!this.getMetaData(node).isEmpty()) {
            return true;
        }
        return node instanceof ExtendedNodeImpl && ((ExtendedNodeImpl)node).containsActions();
    }

    protected void writeScripts(String type, List<ProcessAction> actions, StringBuilder xmlDump) {
        if (actions != null && actions.size() > 0) {
            for (ProcessAction action : actions) {
                AbstractNodeHandler.writeScript(action, type, xmlDump);
            }
        }
    }

    public static void writeScript(ProcessAction action, String type, StringBuilder xmlDump) {
        if (action instanceof ConsequenceAction) {
            String dialect;
            ConsequenceAction consequenceAction = (ConsequenceAction)action;
            xmlDump.append("        <tns:" + type + "-script");
            String name = consequenceAction.getName();
            if (name != null) {
                xmlDump.append(" name=\"" + name + "\"");
            }
            if ("java".equals(dialect = consequenceAction.getDialect())) {
                xmlDump.append(" scriptFormat=\"http://www.java.com/java\"");
            } else if ("JavaScript".equals(dialect)) {
                xmlDump.append(" scriptFormat=\"http://www.javascript.com/javascript\"");
            }
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs, Map<String, String> dataInputTypes, Map<String, String> dataOutputTypes) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String type;
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                type = ((Element)subNode).getAttribute("dtype");
                dataInputs.put(id, inputName);
                dataInputTypes.put(inputName, type);
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                type = ((Element)subNode).getAttribute("dtype");
                dataOutputs.put(id, outputName);
                dataOutputTypes.put(outputName, type);
            }
            subNode = subNode.getNextSibling();
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, Map<String, String> forEachNodeInputAssociation) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            forEachNodeInputAssociation.put(target, source);
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    forEachNodeInputAssociation.put(to, subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((Text)from).getTextContent() : nl.item(0);
                forEachNodeInputAssociation.put(to, result.toString());
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, Map<String, String> forEachNodeOutputAssociation) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            forEachNodeOutputAssociation.put(source, target);
        }
    }

    protected void readMultiInstanceLoopCharacteristics(org.w3c.dom.Node xmlNode, ForEachNode forEachNode, ExtensibleXmlParser parser) {
        for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
            String collectionName;
            Map itemDefinitions;
            DataType dataType;
            String itemSubjectRef;
            String variableName;
            String nodeName = subNode.getNodeName();
            if ("inputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("name");
                if (variableName == null || variableName.isEmpty()) {
                    variableName = ((Element)subNode).getAttribute("id");
                }
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                dataType = this.getDataType(itemSubjectRef, itemDefinitions, parser.getClassLoader());
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setMetaData("MIInput", (Object)((Element)subNode).getAttribute("id"));
                forEachNode.setVariable(variableName, dataType);
                continue;
            }
            if ("outputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("name");
                if (variableName == null || variableName.isEmpty()) {
                    variableName = ((Element)subNode).getAttribute("id");
                }
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                dataType = this.getDataType(itemSubjectRef, itemDefinitions, parser.getClassLoader());
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setMetaData("MIOutput", (Object)((Element)subNode).getAttribute("id"));
                forEachNode.setOutputVariable(variableName, dataType);
                continue;
            }
            if ("loopDataOutputRef".equals(nodeName)) {
                String outputDataRef = ((Element)subNode).getTextContent();
                if (outputDataRef != null && outputDataRef.trim().length() > 0) {
                    collectionName = this.outputAssociation.get(outputDataRef);
                    if (collectionName == null) {
                        collectionName = this.dataOutputs.get(outputDataRef);
                    }
                    forEachNode.setOutputCollectionExpression(collectionName);
                }
                forEachNode.setMetaData("MICollectionOutput", (Object)outputDataRef);
                continue;
            }
            if ("loopDataInputRef".equals(nodeName)) {
                String inputDataRef = ((Element)subNode).getTextContent();
                if (inputDataRef != null && inputDataRef.trim().length() > 0) {
                    collectionName = this.inputAssociation.get(inputDataRef);
                    if (collectionName == null) {
                        collectionName = this.dataInputs.get(inputDataRef);
                    }
                    forEachNode.setCollectionExpression(collectionName);
                }
                forEachNode.setMetaData("MICollectionInput", (Object)inputDataRef);
                continue;
            }
            if (!"completionCondition".equals(nodeName)) continue;
            String expression = subNode.getTextContent();
            forEachNode.setCompletionConditionExpression(expression);
            String language = ((Element)subNode).getAttribute("language");
            forEachNode.setExpressionLang(language);
        }
    }

    protected DataType getDataType(String itemSubjectRef, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        Object dataType = new ObjectDataType();
        if (itemDefinitions == null) {
            return dataType;
        }
        ItemDefinition itemDefinition = itemDefinitions.get(itemSubjectRef);
        if (itemDefinition != null) {
            String structureRef = itemDefinition.getStructureRef();
            dataType = "java.lang.Boolean".equals(structureRef) || "Boolean".equals(structureRef) ? new BooleanDataType() : ("java.lang.Integer".equals(structureRef) || "Integer".equals(structureRef) ? new IntegerDataType() : ("java.lang.Float".equals(structureRef) || "Float".equals(structureRef) ? new FloatDataType() : ("java.lang.String".equals(structureRef) || "String".equals(structureRef) ? new StringDataType() : ("java.lang.Object".equals(structureRef) || "Object".equals(structureRef) ? new ObjectDataType(ClassUtils.constructClass((String)structureRef), structureRef) : new ObjectDataType(ClassUtils.constructClass((String)structureRef, (ClassLoader)cl), structureRef)))));
        }
        return dataType;
    }

    protected String getErrorIdForErrorCode(String errorCode, io.automatiko.engine.workflow.process.core.Node node) {
        NodeContainer parent = node.getParentContainer();
        while (!(parent instanceof ExecutableProcess) && parent instanceof io.automatiko.engine.workflow.process.core.Node) {
            parent = ((io.automatiko.engine.workflow.process.core.Node)parent).getParentContainer();
        }
        if (!(parent instanceof ExecutableProcess)) {
            throw new RuntimeException("This should never happen: !(parent instanceof RuleFlowProcess): parent is " + parent.getClass().getSimpleName());
        }
        List<Error> errors = ((Definitions)((ExecutableProcess)parent).getMetaData("Definitions")).getErrors();
        Signal error = null;
        for (Error listError : errors) {
            if (errorCode.equals(listError.getErrorCode())) {
                error = listError;
                break;
            }
            if (!errorCode.equals(listError.getId())) continue;
            error = listError;
            break;
        }
        if (error == null) {
            throw new IllegalArgumentException("Could not find error with errorCode " + errorCode);
        }
        return error.getId();
    }

    protected void handleThrowCompensationEventNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) {
        assert (node instanceof ActionNode || node instanceof EndNode) : "Node is neither an ActionNode nor an EndNode but a " + node.getClass().getSimpleName();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (!"compensateEventDefinition".equals(xmlNode.getNodeName())) continue;
            String activityRef = ((Element)xmlNode).getAttribute("activityRef");
            if (activityRef == null) {
                activityRef = "";
            }
            node.setMetaData("compensation-activityRef", (Object)activityRef);
            String nodeId = (String)node.getMetaData().get("UniqueId");
            String waitForCompletionString = ((Element)xmlNode).getAttribute("waitForCompletion");
            boolean waitForCompletion = true;
            if (waitForCompletionString != null && waitForCompletionString.length() > 0) {
                waitForCompletion = Boolean.parseBoolean(waitForCompletionString);
            }
            if (waitForCompletion) continue;
            throw new IllegalArgumentException("Asynchronous compensation [" + nodeId + ", " + node.getName() + "] is not yet supported!");
        }
    }

    protected void writeVariableName(EventNode eventNode, StringBuilder xmlDump) {
        if (eventNode.getVariableName() != null) {
            xmlDump.append("      <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output\" name=\"event\" />" + EOL);
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("      <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output</sourceRef>" + EOL + "      <targetRef>" + XmlDumper.replaceIllegalChars((String)eventNode.getVariableName()) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
            xmlDump.append("      <outputSet>" + EOL);
            xmlDump.append("        <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output</dataOutputRefs>" + EOL);
            xmlDump.append("      </outputSet>" + EOL);
        }
    }

    protected String checkSignalAndConvertToRealSignalNam(ExtensibleXmlParser parser, String signalName) {
        Signal signal = this.findSignalByName(parser, signalName);
        if (signal != null && (signalName = signal.getName()) == null) {
            throw new IllegalArgumentException("Signal definition must have a name attribute");
        }
        return signalName;
    }

    protected Signal findSignalByName(ExtensibleXmlParser parser, String signalName) {
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        HashSet<String> signalNames = (HashSet<String>)buildData.getMetaData(SIGNAL_NAMES);
        if (signalNames == null) {
            signalNames = new HashSet<String>();
            buildData.setMetaData(SIGNAL_NAMES, signalNames);
        }
        signalNames.add(signalName);
        Map signals = (Map)buildData.getMetaData("Signals");
        if (signals != null) {
            return (Signal)signals.get(signalName);
        }
        return null;
    }

    protected String retrieveDataType(String itemSubjectRef, String dtype, ExtensibleXmlParser parser) {
        if (dtype != null && !dtype.isEmpty()) {
            return dtype;
        }
        if (itemSubjectRef != null && !itemSubjectRef.isEmpty()) {
            Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
            return ((ItemDefinition)itemDefinitions.get(itemSubjectRef)).getStructureRef();
        }
        return null;
    }

    protected String findVariable(String variableName, ExtensibleXmlParser parser) {
        if (variableName == null) {
            return null;
        }
        LinkedList parents = parser.getParents();
        for (Object parent : parents) {
            if (!(parent instanceof ContextContainer)) continue;
            ContextContainer contextContainer = (ContextContainer)parent;
            VariableScope variableScope = (VariableScope)contextContainer.getDefaultContext("VariableScope");
            return variableScope.getVariables().stream().filter(v -> v.matchByIdOrName(variableName)).map(v -> v.getName()).findFirst().orElse(variableName);
        }
        return variableName;
    }
}

