/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.NodeContainer;
import io.automatiko.engine.workflow.base.core.Context;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.bpmn2.xml.CompositeContextNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.ProcessHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.process.core.impl.ExtendedNodeImpl;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.DynamicNode;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdHocSubProcessHandler
extends CompositeContextNodeHandler {
    protected static final List<String> AUTOCOMPLETE_EXPRESSIONS = Arrays.asList("getActivityInstanceAttribute(\"numberOfActiveInstances\") == 0", "autocomplete");

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        DynamicNode result = new DynamicNode();
        VariableScope variableScope = new VariableScope();
        result.addContext((Context)variableScope);
        result.setDefaultContext((Context)variableScope);
        return result;
    }

    @Override
    public Class<?> generateNodeFor() {
        return DynamicNode.class;
    }

    @Override
    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        DynamicNode dynamicNode = (DynamicNode)node;
        String cancelRemainingInstances = element.getAttribute("cancelRemainingInstances");
        if ("false".equals(cancelRemainingInstances)) {
            dynamicNode.setCancelRemainingInstances(false);
        }
        dynamicNode.setActivationCondition((String)node.getMetaData().get("customActivationCondition"));
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"completionCondition".equals(nodeName)) continue;
            String expression = xmlNode.getTextContent();
            if (AUTOCOMPLETE_EXPRESSIONS.contains(expression)) {
                dynamicNode.setAutoComplete(true);
                continue;
            }
            dynamicNode.setCompletionCondition(expression);
        }
        List connections = (List)dynamicNode.getMetaData("BPMN.Connections");
        ProcessHandler processHandler = new ProcessHandler();
        processHandler.linkConnections((NodeContainer)dynamicNode, connections);
        processHandler.linkBoundaryEvents((NodeContainer)dynamicNode);
        this.handleScript((ExtendedNodeImpl)dynamicNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)dynamicNode, element, "onExit");
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        DynamicNode dynamicNode = (DynamicNode)node;
        this.writeNode("adHocSubProcess", (io.automatiko.engine.workflow.process.core.Node)dynamicNode, xmlDump, metaDataType);
        if (!dynamicNode.isCancelRemainingInstances()) {
            xmlDump.append(" cancelRemainingInstances=\"false\"");
        }
        xmlDump.append(" ordering=\"Parallel\" >" + EOL);
        this.writeExtensionElements((io.automatiko.engine.workflow.process.core.Node)dynamicNode, xmlDump);
        List<io.automatiko.engine.workflow.process.core.Node> subNodes = this.getSubNodes((CompositeNode)dynamicNode);
        XmlBPMNProcessDumper.INSTANCE.visitNodes(subNodes, xmlDump, metaDataType);
        this.visitConnectionsAndAssociations((io.automatiko.engine.workflow.process.core.Node)dynamicNode, xmlDump, metaDataType);
        if (dynamicNode.isAutoComplete()) {
            xmlDump.append("    <completionCondition xsi:type=\"tFormalExpression\">autocomplete</completionCondition>" + EOL);
        }
        this.endNode("adHocSubProcess", xmlDump);
    }
}

