/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractCompositeNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.process.core.node.CompositeContextNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.EventSubProcessNode;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class CompositeContextNodeHandler
extends AbstractCompositeNodeHandler {
    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by end event handler");
    }

    public Class generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        Object isForCompensationObject;
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        String nodeType = "subProcess";
        if (node.getMetaData().get("Transaction") != null) {
            nodeType = "transaction";
        }
        this.writeNode(nodeType, (io.automatiko.engine.workflow.process.core.Node)compositeNode, xmlDump, metaDataType);
        if (compositeNode instanceof EventSubProcessNode) {
            xmlDump.append(" triggeredByEvent=\"true\" ");
        }
        if ((isForCompensationObject = compositeNode.getMetaData("isForCompensation")) != null && ((Boolean)isForCompensationObject).booleanValue()) {
            xmlDump.append("isForCompensation=\"true\" ");
        }
        xmlDump.append(">" + EOL);
        this.writeExtensionElements((io.automatiko.engine.workflow.process.core.Node)compositeNode, xmlDump);
        VariableScope variableScope = (VariableScope)compositeNode.getDefaultContext("VariableScope");
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            xmlDump.append("    <!-- variables -->" + EOL);
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("    <property id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)compositeNode) + "-" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
        }
        List<io.automatiko.engine.workflow.process.core.Node> subNodes = this.getSubNodes((CompositeNode)compositeNode);
        XmlBPMNProcessDumper.INSTANCE.visitNodes(subNodes, xmlDump, metaDataType);
        this.visitConnectionsAndAssociations((io.automatiko.engine.workflow.process.core.Node)compositeNode, xmlDump, metaDataType);
        this.endNode(nodeType, xmlDump);
    }

    protected List<io.automatiko.engine.workflow.process.core.Node> getSubNodes(CompositeNode compositeNode) {
        ArrayList<io.automatiko.engine.workflow.process.core.Node> subNodes = new ArrayList<io.automatiko.engine.workflow.process.core.Node>();
        for (Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeStart || subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            subNodes.add((io.automatiko.engine.workflow.process.core.Node)subNode);
        }
        return subNodes;
    }
}

