/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.ContextContainer;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.BooleanDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.FloatDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.IntegerDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.StringDataType;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.compiler.util.ClassUtils;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.Node;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataObjectHandler
extends BaseAbstractHandler
implements Handler {
    public DataObjectHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(ContextContainer.class);
        this.validParents.add(Node.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Variable.class);
        this.validPeers.add(Node.class);
        this.validPeers.add(SequenceFlow.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String itemSubjectRef = attrs.getValue("itemSubjectRef");
        Object parent = parser.getParent();
        if (parent instanceof ContextContainer) {
            ItemDefinition itemDefinition;
            ContextContainer contextContainer = (ContextContainer)parent;
            VariableScope variableScope = (VariableScope)contextContainer.getDefaultContext("VariableScope");
            if (variableScope == null) {
                return null;
            }
            List variables = variableScope.getVariables();
            Variable variable = new Variable();
            variable.setMetaData("DataObject", (Object)"true");
            variable.setId(id);
            variable.setName(name);
            variable.setMetaData(id, (Object)variable.getName());
            if (localName.equals("dataInput")) {
                variable.setMetaData("DataInput", (Object)true);
            } else if (localName.equals("dataOutput")) {
                variable.setMetaData("DataOutput", (Object)true);
            }
            Object dataType = new ObjectDataType();
            Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
            if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(itemSubjectRef)) != null) {
                String structureRef = itemDefinition.getStructureRef();
                dataType = "java.lang.Boolean".equals(structureRef) || "Boolean".equals(structureRef) ? new BooleanDataType() : ("java.lang.Integer".equals(structureRef) || "Integer".equals(structureRef) ? new IntegerDataType() : ("java.lang.Float".equals(structureRef) || "Float".equals(structureRef) ? new FloatDataType() : ("java.lang.String".equals(structureRef) || "String".equals(structureRef) ? new StringDataType() : ("java.lang.Object".equals(structureRef) || "Object".equals(structureRef) ? new ObjectDataType(Object.class, structureRef) : new ObjectDataType(ClassUtils.constructClass((String)structureRef, (ClassLoader)parser.getClassLoader()), structureRef)))));
            }
            variable.setType((DataType)dataType);
            variables.add(variable);
            return variable;
        }
        return new Variable();
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return parser.getCurrent();
    }

    public Class<?> generateNodeFor() {
        return Variable.class;
    }
}

