/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.event.EventFilter;
import io.automatiko.engine.workflow.base.core.event.EventTransformer;
import io.automatiko.engine.workflow.base.core.event.EventTransformerImpl;
import io.automatiko.engine.workflow.base.core.event.EventTypeFilter;
import io.automatiko.engine.workflow.base.core.event.NonAcceptingEventTypeFilter;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.base.core.timer.DateTimeUtils;
import io.automatiko.engine.workflow.base.core.timer.Timer;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.core.Signal;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.compiler.xml.XmlDumper;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.node.ConstraintTrigger;
import io.automatiko.engine.workflow.process.core.node.EventSubProcessNode;
import io.automatiko.engine.workflow.process.core.node.EventTrigger;
import io.automatiko.engine.workflow.process.core.node.StartNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import io.automatiko.engine.workflow.process.core.node.Trigger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StartEventHandler
extends AbstractNodeHandler {
    private static final String TRIGGER_REF = "TriggerRef";
    private static final String MESSAGE_TYPE = "MessageType";
    private static final String TRIGGER_TYPE = "TriggerType";
    private static final String TRIGGER_CORRELATION = "TriggerCorrelation";
    private static final String TRIGGER_CORRELATION_EXPR = "TriggerCorrelationExpr";
    private static final String TRIGGER_TOPIC_EXPR = "TriggerTopicExpr";
    protected DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    @Override
    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        startNode.setInterrupting(Boolean.parseBoolean(element.getAttribute("isInterrupting")));
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                this.readDataOutput(xmlNode, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, startNode);
                continue;
            }
            if ("outputSet".equals(nodeName)) {
                String message = "Ignoring <" + nodeName + "> element: <" + nodeName + "> elements should not be used on start or other catch events.";
                SAXParseException saxpe = new SAXParseException(message, parser.getLocator());
                parser.warning(saxpe);
                continue;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                String constraint = null;
                for (Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    String subnodeName = subNode.getNodeName();
                    if (!"condition".equals(subnodeName)) continue;
                    constraint = xmlNode.getTextContent();
                    break;
                }
                ConstraintTrigger trigger = new ConstraintTrigger();
                trigger.setConstraint(constraint);
                startNode.addTrigger((Trigger)trigger);
                startNode.setMetaData(TRIGGER_REF, (Object)("Condition-" + node.getId()));
                startNode.setMetaData(TRIGGER_TYPE, (Object)"Condition");
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                String type = ((Element)xmlNode).getAttribute("signalRef");
                Signal signal = this.findSignalByName(parser, type);
                if ((type = this.checkSignalAndConvertToRealSignalNam(parser, type)) != null && type.trim().length() > 0) {
                    this.addTriggerWithInMappings(startNode, type);
                }
                startNode.setMetaData(MESSAGE_TYPE, (Object)type);
                startNode.setMetaData(TRIGGER_TYPE, (Object)"Signal");
                if (signal != null) {
                    String eventType = signal.getStructureRef();
                    ProcessBuildData buildData = (ProcessBuildData)parser.getData();
                    Map map = (Map)buildData.getMetaData("ItemDefinitions");
                    if (map != null && map.containsKey(eventType)) {
                        startNode.setMetaData(TRIGGER_REF, (Object)((ItemDefinition)map.get(eventType)).getStructureRef());
                        continue;
                    }
                    startNode.setMetaData(TRIGGER_REF, (Object)type);
                    continue;
                }
                startNode.setMetaData(TRIGGER_REF, (Object)type);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                String messageRef = ((Element)xmlNode).getAttribute("messageRef");
                Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
                if (messages == null) {
                    throw new IllegalArgumentException("No messages found");
                }
                Message message = (Message)messages.get(messageRef);
                if (message == null) {
                    throw new IllegalArgumentException("Could not find message " + messageRef);
                }
                startNode.setMetaData(MESSAGE_TYPE, (Object)message.getType());
                startNode.setMetaData(TRIGGER_TYPE, (Object)"ConsumeMessage");
                startNode.setMetaData(TRIGGER_REF, (Object)message.getName());
                startNode.setMetaData(TRIGGER_CORRELATION, (Object)message.getCorrelation());
                startNode.setMetaData(TRIGGER_CORRELATION_EXPR, (Object)message.getCorrelationExpression());
                for (Map.Entry entry : message.getMetaData().entrySet()) {
                    startNode.setMetaData((String)entry.getKey(), entry.getValue());
                }
                this.addTriggerWithInMappings(startNode, "Message-" + message.getName());
                continue;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode((io.automatiko.engine.workflow.process.core.Node)startNode, element, uri, localName, parser);
                startNode.setMetaData(TRIGGER_TYPE, (Object)"Timer");
                continue;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                if (!startNode.isInterrupting()) {
                    String errorMsg = "Error Start Events in an Event Sub-Process always interrupt the containing (sub)process(es).";
                    throw new IllegalArgumentException(errorMsg);
                }
                String errorRef = ((Element)xmlNode).getAttribute("errorRef");
                if (errorRef == null || errorRef.trim().length() <= 0) continue;
                List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
                if (errors == null) {
                    throw new IllegalArgumentException("No errors found");
                }
                Error error = null;
                for (Error error2 : errors) {
                    if (!errorRef.equals(error2.getId())) continue;
                    error = error2;
                }
                if (error == null) {
                    throw new IllegalArgumentException("Could not find error " + errorRef);
                }
                startNode.setMetaData("FaultCode", (Object)error.getErrorCode());
                this.addTriggerWithInMappings(startNode, "Error-" + error.getErrorCode());
                startNode.setMetaData(TRIGGER_TYPE, (Object)"Error");
                startNode.setMetaData(TRIGGER_REF, (Object)("Error-" + error.getErrorCode()));
                if (error.getMetaData().get("retry") == null) continue;
                startNode.setMetaData("ErrorRetry", (Object)Long.valueOf(DateTimeUtils.parseDuration((String)((String)error.getMetaData().get("retry")))).intValue());
                if (error.getMetaData().get("retryLimit") != null) {
                    startNode.setMetaData("ErrorRetryLimit", (Object)Integer.parseInt((String)error.getMetaData().get("retryLimit")));
                }
                if (error.getMetaData().get("retryIncrement") != null) {
                    startNode.setMetaData("ErrorRetryIncrement", (Object)Long.valueOf(DateTimeUtils.parseDuration((String)((String)error.getMetaData().get("retryIncrement")))).intValue());
                }
                if (error.getMetaData().get("retryMultiplier") == null) continue;
                startNode.setMetaData("ErrorRetryIncrementMultiplier", (Object)Float.valueOf(Float.parseFloat((String)error.getMetaData().get("retryMultiplier"))));
                continue;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
                if (escalationRef == null || escalationRef.trim().length() <= 0) continue;
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                this.addTriggerWithInMappings(startNode, "Escalation-" + escalation.getEscalationCode());
                startNode.setMetaData(TRIGGER_TYPE, (Object)"Escalation");
                continue;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleCompensationNode(startNode, xmlNode);
        }
        node.setMetaData("DataOutputs", new LinkedHashMap(this.dataOutputTypes));
    }

    private void addTriggerWithInMappings(StartNode startNode, String triggerEventType) {
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType(triggerEventType);
        trigger.addEventFilter((EventFilter)eventFilter);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            trigger.addInMapping(mapping, startNode.getOutMapping(mapping));
        }
        startNode.addTrigger((Trigger)trigger);
    }

    protected void readDataOutputAssociation(Node xmlNode, StartNode startNode) {
        Node subNode = xmlNode.getFirstChild();
        if (!"sourceRef".equals(subNode.getNodeName())) {
            throw new IllegalArgumentException("No sourceRef found in dataOutputAssociation in startEvent");
        }
        String source = subNode.getTextContent();
        if (this.dataOutputs.get(source) == null) {
            throw new IllegalArgumentException("No dataOutput could be found for the dataOutputAssociation.");
        }
        String target = null;
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "targetRef".equals(subNode.getNodeName())) {
            target = subNode.getTextContent();
            if (target != null) {
                startNode.setMetaData("TriggerMapping", (Object)target);
            }
            subNode = subNode.getNextSibling();
        }
        if (subNode != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression, (String)this.dataOutputs.get(source));
            startNode.setMetaData("Transformation", (Object)transformation);
            startNode.setEventTransformer((EventTransformer)new EventTransformerImpl(transformation));
            subNode = subNode.getNextSibling();
            startNode.addOutMapping(target, (String)this.dataOutputs.get(source));
        } else if (subNode != null && "assignment".equals(subNode.getNodeName())) {
            while (subNode != null) {
                Node ssubNode = subNode.getFirstChild();
                target = ssubNode.getNextSibling().getTextContent();
                subNode = subNode.getNextSibling();
            }
            startNode.setMetaData("TriggerMapping", (Object)target);
            startNode.addOutMapping((String)this.dataOutputs.get(source), target);
        } else {
            startNode.addOutMapping((String)this.dataOutputs.get(source), target);
        }
    }

    protected void readDataOutput(Node xmlNode, ExtensibleXmlParser parser) {
        String id = ((Element)xmlNode).getAttribute("id");
        String outputName = ((Element)xmlNode).getAttribute("name");
        this.dataOutputs.put(id, outputName);
        this.populateDataOutputs(xmlNode, outputName, parser);
    }

    protected void populateDataOutputs(Node xmlNode, String outputName, ExtensibleXmlParser parser) {
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        String itemSubjectRef = ((Element)xmlNode).getAttribute("itemSubjectRef");
        if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
            String dataType = ((Element)xmlNode).getAttribute("dtype");
            if (dataType == null || dataType.isEmpty()) {
                dataType = "java.lang.String";
            }
            this.dataOutputTypes.put(outputName, dataType);
        } else if (itemDefinitions.get(itemSubjectRef) != null) {
            this.dataOutputTypes.put(outputName, ((ItemDefinition)itemDefinitions.get(itemSubjectRef)).getStructureRef());
        } else {
            this.dataOutputTypes.put(outputName, "java.lang.Object");
        }
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        StartNode startNode = (StartNode)node;
        this.writeNode("startEvent", (io.automatiko.engine.workflow.process.core.Node)startNode, xmlDump, metaDataType);
        xmlDump.append(" isInterrupting=\"");
        if (startNode.isInterrupting()) {
            xmlDump.append("true");
        } else {
            xmlDump.append("false");
        }
        xmlDump.append("\">" + EOL);
        this.writeExtensionElements((io.automatiko.engine.workflow.process.core.Node)startNode, xmlDump);
        List triggers = startNode.getTriggers();
        if (triggers != null) {
            if (triggers.size() > 1) {
                throw new IllegalArgumentException("Multiple start triggers not supported");
            }
            Trigger trigger = (Trigger)triggers.get(0);
            if (trigger instanceof ConstraintTrigger) {
                ConstraintTrigger constraintTrigger = (ConstraintTrigger)trigger;
                if (constraintTrigger.getHeader() == null) {
                    xmlDump.append("      <conditionalEventDefinition>" + EOL);
                    xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"https://automatiko.io/rule\">" + constraintTrigger.getConstraint() + "</condition>" + EOL);
                    xmlDump.append("      </conditionalEventDefinition>" + EOL);
                }
            } else if (trigger instanceof EventTrigger) {
                String type;
                EventTrigger eventTrigger = (EventTrigger)trigger;
                String mapping = null;
                String nameMapping = "event";
                if (!trigger.getInMappings().isEmpty()) {
                    mapping = (String)eventTrigger.getInMappings().keySet().iterator().next();
                    nameMapping = (String)eventTrigger.getInMappings().values().iterator().next();
                } else {
                    mapping = (String)startNode.getMetaData("TriggerMapping");
                }
                if (mapping != null) {
                    xmlDump.append("      <dataOutput id=\"_" + startNode.getId() + "_Output\" name=\"" + nameMapping + "\" />" + EOL + "      <dataOutputAssociation>" + EOL + "        <sourceRef>_" + startNode.getId() + "_Output</sourceRef>" + EOL + "        <targetRef>" + mapping + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL);
                }
                if ((type = ((EventTypeFilter)eventTrigger.getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                } else if (type.startsWith("Error-")) {
                    type = type.substring(6);
                    String errorId = this.getErrorIdForErrorCode(type, (io.automatiko.engine.workflow.process.core.Node)startNode);
                    xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorId) + "\"/>" + EOL);
                } else if (type.startsWith("Escalation-")) {
                    type = type.substring(11);
                    xmlDump.append("      <escalationEventDefinition escalationRef=\"" + type + "\"/>" + EOL);
                } else if (type.equals("Compensation")) {
                    xmlDump.append("      <compensateEventDefinition/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\" />" + EOL);
                }
            } else {
                throw new IllegalArgumentException("Unsupported trigger type " + trigger);
            }
            if (startNode.getTimer() != null) {
                Timer timer = startNode.getTimer();
                xmlDump.append("      <timerEventDefinition>" + EOL);
                if (timer != null && (timer.getDelay() != null || timer.getDate() != null)) {
                    if (timer.getTimeType() == 3) {
                        xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDate()) + "</timeDate>" + EOL);
                    } else if (timer.getTimeType() == 1) {
                        xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDuration>" + EOL);
                    } else if (timer.getTimeType() == 2) {
                        if (timer.getPeriod() != null) {
                            xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "###" + XmlDumper.replaceIllegalChars((String)timer.getPeriod()) + "</timeCycle>" + EOL);
                        } else {
                            xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeCycle>" + EOL);
                        }
                    }
                }
                xmlDump.append("      </timerEventDefinition>" + EOL);
            }
        } else if (startNode.getTimer() != null) {
            Timer timer = startNode.getTimer();
            xmlDump.append("      <timerEventDefinition>" + EOL);
            if (timer != null && (timer.getDelay() != null || timer.getDate() != null)) {
                if (timer.getTimeType() == 3) {
                    xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDate()) + "</timeDate>" + EOL);
                } else if (timer.getTimeType() == 1) {
                    xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDuration>" + EOL);
                } else if (timer.getTimeType() == 2) {
                    if (timer.getPeriod() != null) {
                        xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "###" + XmlDumper.replaceIllegalChars((String)timer.getPeriod()) + "</timeCycle>" + EOL);
                    } else {
                        xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeCycle>" + EOL);
                    }
                }
            }
            xmlDump.append("      </timerEventDefinition>" + EOL);
        }
        this.endNode("startEvent", xmlDump);
    }

    protected void handleTimerNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            Timer timer = new Timer();
            Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String delay;
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    int index = delay.indexOf("###");
                    if (index != -1) {
                        String period = delay.substring(index + 3);
                        delay = delay.substring(0, index);
                        timer.setPeriod(period);
                    }
                    timer.setTimeType(2);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDuration".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    timer.setTimeType(1);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    String date = subNode.getTextContent();
                    timer.setTimeType(3);
                    timer.setDate(date);
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            startNode.setTimer(timer);
            if (!(parser.getParent() instanceof EventSubProcessNode)) continue;
            EventTrigger trigger = new EventTrigger();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + ((EventSubProcessNode)parser.getParent()).getId());
            trigger.addEventFilter((EventFilter)eventFilter);
            String mapping = (String)startNode.getMetaData("TriggerMapping");
            if (mapping != null) {
                trigger.addInMapping(mapping, "event");
            }
            startNode.addTrigger((Trigger)trigger);
            ((EventSubProcessNode)parser.getParent()).addTimer(timer, (ProcessAction)new ConsequenceAction("java", ""));
        }
    }

    protected void handleCompensationNode(StartNode startNode, Node xmlNode) {
        if (startNode.isInterrupting()) {
            logger.warn("Compensation Event Sub-Processes [" + startNode.getMetaData("UniqueId") + "] may not be specified as interrupting: overriding attribute and setting to not-interrupting.");
        }
        startNode.setInterrupting(false);
        String activityRef = ((Element)xmlNode).getAttribute("activityRef");
        if (activityRef != null && activityRef.length() > 0) {
            logger.warn("activityRef value [" + activityRef + "] on Start Event '" + startNode.getMetaData("UniqueId") + "' ignored per the BPMN2 specification.");
        }
        EventTrigger startTrigger = new EventTrigger();
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        startTrigger.addEventFilter((EventFilter)eventFilter);
        ArrayList<EventTrigger> startTriggers = new ArrayList<EventTrigger>();
        startTriggers.add(startTrigger);
        startNode.setTriggers(startTriggers);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            startTrigger.addInMapping(mapping, startNode.getOutMapping(mapping));
        }
    }
}

