/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.ParameterDefinition;
import io.automatiko.engine.workflow.base.core.Work;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.base.core.impl.ParameterDefinitionImpl;
import io.automatiko.engine.workflow.base.core.impl.WorkImpl;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.compiler.util.ClassUtils;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.impl.ExtendedNodeImpl;
import io.automatiko.engine.workflow.process.core.node.Assignment;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.ForEachNode;
import io.automatiko.engine.workflow.process.core.node.MilestoneNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import io.automatiko.engine.workflow.process.core.node.WorkItemNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();
    private Map<String, ItemDefinition> itemDefinitions;
    Map<String, String> dataTypeInputs = new LinkedHashMap<String, String>();
    Map<String, String> dataTypeOutputs = new LinkedHashMap<String, String>();

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class<?> generateNodeFor() {
        return io.automatiko.engine.workflow.process.core.Node.class;
    }

    @Override
    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        this.itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        this.dataTypeInputs.clear();
        this.dataTypeOutputs.clear();
        WorkItemNode workItemNode = (WorkItemNode)node;
        String name = this.getTaskName(element);
        WorkImpl work = new WorkImpl();
        work.setName(name);
        workItemNode.setWork((Work)work);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs, this.dataInputTypes);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, workItemNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, workItemNode, this.dataOutputs);
        }
        workItemNode.setMetaData("DataInputs", new LinkedHashMap<String, String>(this.dataTypeInputs));
        workItemNode.setMetaData("DataOutputs", new LinkedHashMap<String, String>(this.dataTypeOutputs));
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onExit");
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            workItemNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
        for (Map.Entry<String, String> entryInputTypes : this.dataTypeInputs.entrySet()) {
            ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl();
            parameterDefinition.setName(entryInputTypes.getKey());
            parameterDefinition.setType((DataType)new ObjectDataType(ClassUtils.constructClass((String)entryInputTypes.getValue()), entryInputTypes.getValue()));
            work.addParameterDefinition((ParameterDefinition)parameterDefinition);
        }
    }

    protected String getTaskName(Element element) {
        return element.getAttribute("taskName");
    }

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs, Map<String, String> dataInputTypes) {
        this.dataTypeInputs.clear();
        this.dataTypeOutputs.clear();
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String dataType;
            String itemSubjectRef;
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    this.dataTypeInputs.put(inputName, dataType);
                } else if (this.itemDefinitions.get(itemSubjectRef) != null) {
                    this.dataTypeInputs.put(inputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                } else {
                    this.dataTypeInputs.put(inputName, "java.lang.Object");
                }
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    this.dataTypeOutputs.put(outputName, dataType);
                } else if (this.itemDefinitions.get(itemSubjectRef) != null) {
                    this.dataTypeOutputs.put(outputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                } else {
                    this.dataTypeOutputs.put(outputName, "java.lang.Object");
                }
            }
            subNode = subNode.getNextSibling();
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
            while ("sourceRef".equals(subNode.getNodeName())) {
                sources.add(subNode.getTextContent());
                subNode = subNode.getNextSibling();
            }
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression);
                subNode = subNode.getNextSibling();
            }
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            while (subNode != null) {
                String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
                if (expressionLang == null || expressionLang.trim().isEmpty()) {
                    expressionLang = "XPath";
                }
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment(expressionLang, from, to));
                subNode = subNode.getNextSibling();
            }
            workItemNode.addInAssociation(new DataAssociation(sources, dataInputs.get(target), assignments, transformation));
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                String text;
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    workItemNode.getWork().setParameter(dataInputs.get(to), (Object)subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
                workItemNode.getWork().setParameter(dataInputs.get(to), result);
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(subNode.getTextContent());
        subNode = subNode.getNextSibling();
        while ("sourceRef".equals(subNode.getNodeName())) {
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
        }
        String target = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression);
            subNode = subNode.getNextSibling();
        }
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
            if (expressionLang == null || expressionLang.trim().isEmpty()) {
                expressionLang = "XPath";
            }
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment(expressionLang, from, to));
            subNode = subNode.getNextSibling();
        }
        workItemNode.addOutAssociation(new DataAssociation(sources.stream().map(source -> (String)dataOutputs.get(source)).collect(Collectors.toList()), target, assignments, transformation));
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by the WorkItemNodeHandler");
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        int uniqueIdGen = 1;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            forEachNode.setMetaData("UniqueId", (Object)uniqueId);
            node.setMetaData("UniqueId", (Object)(uniqueId + ":" + uniqueIdGen++));
            forEachNode.addNode((Node)node);
            forEachNode.linkIncomingConnections("DEFAULT", node.getId(), "DEFAULT");
            forEachNode.linkOutgoingConnections(node.getId(), "DEFAULT", "DEFAULT");
            forEachNode.setSequential(Boolean.parseBoolean(((Element)xmlNode).getAttribute("isSequential")));
            io.automatiko.engine.workflow.process.core.Node orignalNode = node;
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            if (!(orignalNode instanceof WorkItemNode)) break;
            this.adjustNodeConfiguration(orignalNode, forEachNode);
            break;
        }
        if (node instanceof WorkItemNode && ((WorkItemNode)node).getWork().getName().equals("Milestone")) {
            WorkItemNode workItemNode = (WorkItemNode)node;
            String milestoneCondition = (String)((WorkItemNode)node).getWork().getParameter("Condition");
            MilestoneNode milestoneNode = new MilestoneNode();
            milestoneNode.setId(workItemNode.getId());
            milestoneNode.setMetaData(workItemNode.getMetaData());
            milestoneNode.setConditionExpression(milestoneCondition);
            milestoneNode.setName(workItemNode.getName());
            milestoneNode.setParentContainer(workItemNode.getParentContainer());
            node = milestoneNode;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void adjustNodeConfiguration(io.automatiko.engine.workflow.process.core.Node orignalNode, ForEachNode forEachNode) {
    }

    protected void handleForEachNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) {
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, this.inputAssociation);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, this.outputAssociation);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
    }
}

