/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml.di;

import io.automatiko.engine.workflow.bpmn2.xml.di.BPMNPlaneHandler;
import io.automatiko.engine.workflow.bpmn2.xml.di.BPMNShapeHandler;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BPMNEdgeHandler
extends BaseAbstractHandler
implements Handler {
    public BPMNEdgeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(BPMNPlaneHandler.ProcessInfo.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(BPMNShapeHandler.NodeInfo.class);
        this.validPeers.add(ConnectionInfo.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String elementRef = attrs.getValue("bpmnElement");
        ConnectionInfo info = new ConnectionInfo(elementRef);
        BPMNPlaneHandler.ProcessInfo processInfo = (BPMNPlaneHandler.ProcessInfo)parser.getParent();
        processInfo.addConnectionInfo(info);
        return info;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Object bendpoints = null;
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> ys = new ArrayList<Integer>();
        Node xmlNode = element.getFirstChild();
        while (xmlNode instanceof Element) {
            String nodeName = xmlNode.getNodeName();
            if ("waypoint".equals(nodeName)) {
                String x = ((Element)xmlNode).getAttribute("x");
                String y = ((Element)xmlNode).getAttribute("y");
                try {
                    int xValue = new Float(x).intValue();
                    int yValue = new Float(y).intValue();
                    xs.add(xValue);
                    ys.add(yValue);
                    if (bendpoints == null) {
                        bendpoints = "[";
                    } else if (xmlNode.getNextSibling() != null) {
                        bendpoints = (String)bendpoints + xValue + "," + yValue;
                        bendpoints = (String)bendpoints + ";";
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid bendpoint value", e);
                }
            }
            xmlNode = xmlNode.getNextSibling();
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)parser.getCurrent();
        if (bendpoints != null && ((String)bendpoints).length() > 1) {
            connectionInfo.setBendpoints((String)bendpoints + "]");
        }
        connectionInfo.setXs(xs);
        connectionInfo.setYs(ys);
        return connectionInfo;
    }

    public Class<?> generateNodeFor() {
        return ConnectionInfo.class;
    }

    public static class ConnectionInfo {
        private String elementRef;
        private String bendpoints;
        private List<Integer> xs = new ArrayList<Integer>();
        private List<Integer> ys = new ArrayList<Integer>();

        public ConnectionInfo(String elementRef) {
            this.elementRef = elementRef;
        }

        public String getElementRef() {
            return this.elementRef;
        }

        public String getBendpoints() {
            return this.bendpoints;
        }

        public void setBendpoints(String bendpoints) {
            this.bendpoints = bendpoints;
        }

        public List<Integer> getXs() {
            return this.xs;
        }

        public void setXs(List<Integer> xs) {
            this.xs = xs;
        }

        public List<Integer> getYs() {
            return this.ys;
        }

        public void setYs(List<Integer> ys) {
            this.ys = ys;
        }
    }
}

