/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.serverless.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.automatiko.engine.api.definition.process.Connection;
import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.ProcessContext;
import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.Context;
import io.automatiko.engine.workflow.base.core.FunctionTagDefinition;
import io.automatiko.engine.workflow.base.core.ParameterDefinition;
import io.automatiko.engine.workflow.base.core.Process;
import io.automatiko.engine.workflow.base.core.StaticTagDefinition;
import io.automatiko.engine.workflow.base.core.Work;
import io.automatiko.engine.workflow.base.core.context.variable.JsonVariableScope;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.JsonNodeDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.base.core.event.EventFilter;
import io.automatiko.engine.workflow.base.core.event.EventTypeFilter;
import io.automatiko.engine.workflow.base.core.impl.ParameterDefinitionImpl;
import io.automatiko.engine.workflow.base.core.impl.WorkImpl;
import io.automatiko.engine.workflow.base.core.timer.DateTimeUtils;
import io.automatiko.engine.workflow.base.core.timer.Timer;
import io.automatiko.engine.workflow.base.core.validation.ProcessValidationError;
import io.automatiko.engine.workflow.base.instance.impl.actions.ProcessInstanceCompensationAction;
import io.automatiko.engine.workflow.base.instance.impl.jq.OutputJqAssignmentAction;
import io.automatiko.engine.workflow.base.instance.impl.jq.TaskInputJqAssignmentAction;
import io.automatiko.engine.workflow.base.instance.impl.jq.TaskOutputJqAssignmentAction;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConnectionImpl;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.impl.ConstraintImpl;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.Assignment;
import io.automatiko.engine.workflow.process.core.node.BoundaryEventNode;
import io.automatiko.engine.workflow.process.core.node.CompositeContextNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.EndNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.EventTrigger;
import io.automatiko.engine.workflow.process.core.node.HumanTaskNode;
import io.automatiko.engine.workflow.process.core.node.Join;
import io.automatiko.engine.workflow.process.core.node.Split;
import io.automatiko.engine.workflow.process.core.node.StartNode;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import io.automatiko.engine.workflow.process.core.node.TimerNode;
import io.automatiko.engine.workflow.process.core.node.Trigger;
import io.automatiko.engine.workflow.process.core.node.WorkItemNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import io.automatiko.engine.workflow.process.executable.core.ServerlessExecutableProcess;
import io.automatiko.engine.workflow.process.executable.core.validation.ExecutableProcessValidator;
import io.automatiko.engine.workflow.sw.ServerlessFunctions;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.correlation.CorrelationDef;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.filters.EventDataFilter;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.retry.RetryDefinition;
import io.serverlessworkflow.api.timeouts.WorkflowExecTimeout;
import io.serverlessworkflow.api.workflow.Constants;
import io.serverlessworkflow.utils.WorkflowUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerlessWorkflowFactory.class);
    public static final String DEFAULT_WORKFLOW_ID = "serverless";
    public static final String DEFAULT_WORKFLOW_NAME = "workflow";
    public static final String DEFAULT_PACKAGE_NAME = "io.automatiko.serverless";
    public static final String DEFAULT_VISIBILITY = "Public";
    public static final String DEFAULT_DECISION = "decision";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    public static final String UNIQUE_ID_PARAM = "UniqueId";
    public static final String EVENTBASED_PARAM = "EventBased";
    public static final String DEFAULT_SERVICE_IMPL = "Java";
    public static final String SERVICE_IMPL_KEY = "implementation";
    public static final String SERVICE_ENDPOINT = "endpoint";
    public static final String DEFAULT_HT_TASKNAME = "workflowhtask";
    public static final String SERVICE_TASK_TYPE = "Service Task";
    public static final int DEFAULT_RETRY_LIMIT = 3;
    public static final int DEFAULT_RETRY_AFTER = 1000;

    public ExecutableProcess createProcess(Workflow workflow) {
        ServerlessExecutableProcess process = new ServerlessExecutableProcess();
        if (workflow.getId() != null && !workflow.getId().isEmpty()) {
            process.setId(workflow.getId());
        } else {
            process.setId(DEFAULT_WORKFLOW_ID);
        }
        if (workflow.getName() != null && !workflow.getName().isEmpty()) {
            process.setName(workflow.getName());
        } else {
            process.setName(DEFAULT_WORKFLOW_NAME);
        }
        if (workflow.getVersion() != null && !workflow.getVersion().isEmpty()) {
            process.setVersion(workflow.getVersion());
        }
        if (workflow.getMetadata() != null && workflow.getMetadata().get("package") != null) {
            process.setPackageName((String)workflow.getMetadata().get("package"));
        } else {
            process.setPackageName(DEFAULT_PACKAGE_NAME);
        }
        if (workflow.isKeepActive()) {
            process.setAutoComplete(false);
            process.setDynamic(true);
        } else {
            process.setAutoComplete(true);
        }
        process.setVisibility(DEFAULT_VISIBILITY);
        if (workflow.getMetadata() != null) {
            process.getMetaData().putAll(workflow.getMetadata());
        }
        if (workflow.getDescription() != null) {
            process.setMetaData("Documentation", (Object)workflow.getDescription());
        }
        if (workflow.getConstants() != null) {
            Constants constants = workflow.getConstants();
            String value = constants.getConstantsDef().toString();
            Variable constantsVariable = new Variable("contantsVariable", "$CONST", (DataType)new JsonNodeDataType());
            constantsVariable.setMetaData("value", (Object)value.replaceAll("\"", "\\\""));
            constantsVariable.getTags().add("internal");
            constantsVariable.getTags().add("readonly");
            process.getVariableScope().addVariable(constantsVariable);
        }
        if (workflow.getAnnotations() != null) {
            ArrayList<Object> tagDefinitions = new ArrayList<Object>();
            int counter = 0;
            for (String tag : workflow.getAnnotations()) {
                if (tag.startsWith("${")) {
                    tagDefinitions.add(new FunctionTagDefinition(String.valueOf(++counter), this.unwrapExpression(tag), (exp, vars) -> {
                        Object result = ServerlessFunctions.expression((ProcessContext)vars, (String)exp);
                        if (result instanceof TextNode) {
                            return ((TextNode)result).asText();
                        }
                        return result.toString();
                    }));
                    continue;
                }
                tagDefinitions.add(new StaticTagDefinition(String.valueOf(++counter), tag));
            }
            process.setTagDefinitions(tagDefinitions);
        }
        return process;
    }

    public StartNode startNode(long id, String name, NodeContainer nodeContainer) {
        StartNode startNode = new StartNode();
        startNode.setId(id);
        startNode.setName(this.nameOrDefault(name, "Unnamed start"));
        startNode.setInterrupting(true);
        startNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)startNode));
        nodeContainer.addNode((Node)startNode);
        return startNode;
    }

    public ActionNode injectStateNode(long id, String name, NodeContainer nodeContainer, String dataToInject) {
        ActionNode actionNode = new ActionNode();
        actionNode.setId(id);
        actionNode.setName(this.nameOrDefault(name, "Unnamed inject"));
        actionNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)actionNode));
        ConsequenceAction processAction = new ConsequenceAction(null, "inject(context, " + this.escapeExpression(dataToInject) + ");");
        io.automatiko.engine.workflow.base.instance.impl.Action injectAction = context -> ServerlessFunctions.inject((ProcessContext)context, (String)dataToInject);
        processAction.setMetaData("Action", (Object)injectAction);
        actionNode.setAction((ProcessAction)processAction);
        nodeContainer.addNode((Node)actionNode);
        return actionNode;
    }

    public ActionNode stateDataFilterActionNode(long id, String name, NodeContainer nodeContainer, String outputFilterString) {
        ActionNode actionNode = new ActionNode();
        actionNode.setId(id);
        actionNode.setName(name);
        actionNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)actionNode));
        String outputFilter = this.unwrapExpression(outputFilterString);
        ConsequenceAction processAction = new ConsequenceAction(null, "new io.automatiko.engine.workflow.base.instance.impl.jq.OutputJqAssignmentAction(" + this.escapeExpression(outputFilter) + ").execute(null, context);");
        io.automatiko.engine.workflow.base.instance.impl.Action injectAction = context -> new OutputJqAssignmentAction(outputFilter).execute(null, context);
        processAction.setMetaData("Action", (Object)injectAction);
        actionNode.setAction((ProcessAction)processAction);
        nodeContainer.addNode((Node)actionNode);
        return actionNode;
    }

    public ActionNode expressionActionStateNode(long id, String name, NodeContainer nodeContainer, String expression, Action action) {
        ActionNode actionNode = new ActionNode();
        actionNode.setId(id);
        actionNode.setName(this.nameOrDefault(name, ""));
        actionNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)actionNode));
        ActionDataFilter actionDataFilter = action.getActionDataFilter();
        StringBuilder functionArguments = new StringBuilder();
        if (action.getFunctionRef().getArguments() != null) {
            functionArguments.append("(");
            for (JsonNode argument : action.getFunctionRef().getArguments()) {
                functionArguments.append(this.unwrapExpression(argument.toString())).append(",");
            }
            functionArguments.deleteCharAt(functionArguments.length() - 1);
            functionArguments.append(")");
        }
        String inputFilter = actionDataFilter == null ? null : this.unwrapExpression(actionDataFilter.getFromStateData());
        String outputFilter = actionDataFilter == null ? null : this.unwrapExpression(actionDataFilter.getResults());
        String scopeFilter = actionDataFilter == null ? null : this.unwrapExpression(actionDataFilter.getToStateData());
        ConsequenceAction processAction = new ConsequenceAction(null, "expression(context, " + this.escapeExpression(expression + functionArguments) + ", " + this.escapeExpression(inputFilter) + ");");
        if (actionDataFilter != null && actionDataFilter.isUseResults()) {
            processAction = new ConsequenceAction(null, "expression(context, " + this.escapeExpression(expression + functionArguments) + ", " + this.escapeExpression(inputFilter) + ", " + this.escapeExpression(outputFilter) + ", " + this.escapeExpression(scopeFilter) + ");");
        }
        io.automatiko.engine.workflow.base.instance.impl.Action injectAction = context -> {
            if (actionDataFilter != null && actionDataFilter.isUseResults()) {
                ServerlessFunctions.expression((ProcessContext)context, (String)expression, (String)inputFilter, (String)outputFilter, (String)scopeFilter);
            } else {
                ServerlessFunctions.expression((ProcessContext)context, (String)expression, (String)inputFilter);
            }
        };
        processAction.setMetaData("Action", (Object)injectAction);
        actionNode.setAction((ProcessAction)processAction);
        nodeContainer.addNode((Node)actionNode);
        return actionNode;
    }

    public StartNode messageStartNode(long id, EventDefinition eventDefinition, OnEvents onEvents, NodeContainer nodeContainer) {
        StartNode startNode = new StartNode();
        startNode.setId(id);
        startNode.setName(eventDefinition.getName());
        startNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)startNode));
        startNode.setMetaData("TriggerMapping", (Object)DEFAULT_WORKFLOW_VAR);
        startNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
        startNode.setMetaData("TriggerRef", (Object)eventDefinition.getName());
        startNode.setMetaData("MessageType", (Object)JSON_NODE);
        if (eventDefinition.getCorrelation() != null && !eventDefinition.getCorrelation().isEmpty()) {
            startNode.setMetaData("TriggerCorrelationExpr", (Object)("extensionAttribute(eventData, \"" + ((CorrelationDef)eventDefinition.getCorrelation().get(0)).getContextAttributeName() + "\")"));
            startNode.setMetaData("acceptStartSignal", (Object)"true");
        }
        startNode.setMetaData("filterExpression", (Object)("hasAttributeWithValue(eventData, \"type\", \"" + eventDefinition.getType() + "\")"));
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("Message-" + eventDefinition.getName());
        trigger.addEventFilter((EventFilter)eventFilter);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            trigger.addInMapping(mapping, startNode.getOutMapping(mapping));
        }
        startNode.addTrigger((Trigger)trigger);
        if (eventDefinition.getMetadata() != null) {
            eventDefinition.getMetadata().forEach((k, v) -> startNode.setMetaData(k, v));
        }
        boolean useData = true;
        String outputFilter = null;
        String scopeFilter = null;
        if (onEvents.getEventDataFilter() != null) {
            useData = onEvents.getEventDataFilter().isUseData();
            outputFilter = this.unwrapExpression(onEvents.getEventDataFilter().getData());
            scopeFilter = this.unwrapExpression(onEvents.getEventDataFilter().getToStateData());
        }
        if (useData) {
            Assignment outAssignment = new Assignment("jq", null, null);
            outAssignment.setMetaData("Action", (Object)new TaskOutputJqAssignmentAction(outputFilter, scopeFilter, true));
            startNode.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outAssignment), null));
        }
        nodeContainer.addNode((Node)startNode);
        return startNode;
    }

    public EndNode endNode(long id, String name, boolean terminate, NodeContainer nodeContainer) {
        EndNode endNode = new EndNode();
        endNode.setId(id);
        endNode.setName(this.nameOrDefault(name, "Unnamed end"));
        endNode.setTerminate(terminate);
        endNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)endNode));
        nodeContainer.addNode((Node)endNode);
        return endNode;
    }

    public EndNode compensateEndNode(long id, String name, NodeContainer nodeContainer) {
        EndNode endNode = new EndNode();
        endNode.setId(id);
        endNode.setName(this.nameOrDefault(name, "Unnamed compensate"));
        endNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)endNode));
        endNode.setMetaData("TriggerType", (Object)"Compensation");
        nodeContainer.addNode((Node)endNode);
        return endNode;
    }

    public EndNode messageEndNode(long id, String name, Workflow workflow, End stateEnd, NodeContainer nodeContainer) {
        EndNode endNode = new EndNode();
        endNode.setTerminate(false);
        endNode.setId(id);
        endNode.setName(this.nameOrDefault(name, "Unnamed end"));
        endNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)endNode));
        if (!stateEnd.getProduceEvents().isEmpty()) {
            EventDefinition eventDef = WorkflowUtils.getDefinedProducedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(((ProduceEvent)stateEnd.getProduceEvents().get(0)).getEventRef())).findFirst().get();
            endNode.setMetaData("TriggerRef", (Object)eventDef.getSource());
            endNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            endNode.setMetaData("MessageType", (Object)JSON_NODE);
            endNode.setMetaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR);
            nodeContainer.addNode((Node)endNode);
            return endNode;
        }
        LOGGER.error("Unable to find produce event definition for state end.");
        return null;
    }

    public ActionNode produceMessageNode(long id, String name, Workflow workflow, ProduceEvent event, NodeContainer nodeContainer) {
        EventDefinition eventDef = WorkflowUtils.getDefinedProducedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(event.getEventRef())).findFirst().get();
        ActionNode produceEventNode = new ActionNode();
        produceEventNode.setId(id);
        produceEventNode.setName(eventDef.getName());
        produceEventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)produceEventNode));
        produceEventNode.setMetaData("TriggerRef", (Object)eventDef.getName());
        produceEventNode.setMetaData("TriggerTypeAttr", (Object)eventDef.getType());
        produceEventNode.setMetaData("TriggerSource", (Object)eventDef.getSource());
        produceEventNode.setMetaData("TriggerType", (Object)"ProduceMessage");
        produceEventNode.setMetaData("MessageType", (Object)JSON_NODE);
        if (eventDef.getMetadata() != null && eventDef.getMetadata().containsKey("connector")) {
            produceEventNode.setMetaData("connector", (Object)eventDef.getMetadata().containsKey("connector"));
        }
        if (eventDef.getMetadata() != null) {
            eventDef.getMetadata().forEach((k, v) -> produceEventNode.setMetaData(k, v));
        }
        if (event.getData() == null || event.getData().isEmpty()) {
            throw new IllegalArgumentException("Produce Event " + name + " does not have data set");
        }
        produceEventNode.setMetaData("MappingVariable", (Object)event.getData());
        nodeContainer.addNode((Node)produceEventNode);
        return produceEventNode;
    }

    public TimerNode timerNode(long id, String name, String delay, NodeContainer nodeContainer) {
        TimerNode timerNode = new TimerNode();
        timerNode.setId(id);
        timerNode.setName(this.nameOrDefault(name, "Unnamed sleep"));
        timerNode.setMetaData("EventType", (Object)"timer");
        timerNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)timerNode));
        Timer timer = new Timer();
        timer.setTimeType(1);
        timer.setDelay(delay);
        timerNode.setTimer(timer);
        nodeContainer.addNode((Node)timerNode);
        return timerNode;
    }

    public SubProcessNode callActivity(long id, String name, String calledId, boolean waitForCompletion, NodeContainer nodeContainer) {
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(id);
        subProcessNode.setName(this.nameOrDefault(name, "Unnamed subflow"));
        subProcessNode.setProcessId(calledId);
        subProcessNode.setWaitForCompletion(waitForCompletion);
        subProcessNode.setIndependent(true);
        subProcessNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)subProcessNode));
        VariableScope variableScope = new VariableScope();
        subProcessNode.addContext((Context)variableScope);
        subProcessNode.setDefaultContext((Context)variableScope);
        HashMap<String, String> inputOtuputTypes = new HashMap<String, String>();
        inputOtuputTypes.put(DEFAULT_WORKFLOW_VAR, JSON_NODE);
        subProcessNode.setMetaData("BPMN.InputTypes", inputOtuputTypes);
        subProcessNode.setMetaData("BPMN.OutputTypes", inputOtuputTypes);
        subProcessNode.addInMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        subProcessNode.addOutMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)subProcessNode);
        return subProcessNode;
    }

    public void addTriggerToStartNode(StartNode startNode, String triggerEventType) {
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType(triggerEventType);
        trigger.addEventFilter((EventFilter)eventFilter);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            trigger.addInMapping(mapping, startNode.getOutMapping(mapping));
        }
        startNode.addTrigger((Trigger)trigger);
    }

    public void addOutMapping(StartNode startNode, String source, String target, String assignmentDialect, String assignmentFrom, String assignmentTo) {
        List<Assignment> assignments = null;
        if (assignmentFrom != null && assignmentTo != null) {
            assignments = Arrays.asList(new Assignment(assignmentDialect, assignmentFrom, assignmentTo));
        }
        DataAssociation dataAssociation = new DataAssociation(source, target, assignments, null);
        startNode.addOutAssociation(dataAssociation);
    }

    public ActionNode sendEventNode(long id, EventDefinition eventDefinition, NodeContainer nodeContainer) {
        ActionNode sendEventNode = new ActionNode();
        sendEventNode.setId(id);
        sendEventNode.setName(eventDefinition.getName());
        sendEventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)sendEventNode));
        sendEventNode.setMetaData("TriggerType", (Object)"ProduceMessage");
        sendEventNode.setMetaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR);
        sendEventNode.setMetaData("TriggerRef", (Object)eventDefinition.getSource());
        sendEventNode.setMetaData("MessageType", (Object)JSON_NODE);
        nodeContainer.addNode((Node)sendEventNode);
        return sendEventNode;
    }

    public ActionNode compensationEventNode(long id, String name, NodeContainer nodeContainer, ExecutableProcess process) {
        ActionNode compensationEventNode = new ActionNode();
        compensationEventNode.setId(id);
        compensationEventNode.setName(this.nameOrDefault(name, "Unnamed compensation"));
        compensationEventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)compensationEventNode));
        ProcessInstanceCompensationAction pic = new ProcessInstanceCompensationAction("implicit:" + process.getId());
        ProcessAction processAction = new ProcessAction();
        processAction.setMetaData("Action", (Object)pic);
        compensationEventNode.setAction(processAction);
        compensationEventNode.setMetaData("TriggerType", (Object)"Compensation");
        compensationEventNode.setMetaData("NodeType", (Object)"IntermediateThrowEvent-None");
        compensationEventNode.setMetaData("CompensationEvent", (Object)("implicit:" + process.getId()));
        nodeContainer.addNode((Node)compensationEventNode);
        return compensationEventNode;
    }

    public EventNode consumeEventNode(long id, EventDefinition eventDefinition, EventDataFilter eventDataFilter, NodeContainer nodeContainer) {
        EventNode eventNode = new EventNode();
        eventNode.setId(id);
        eventNode.setName(eventDefinition.getName());
        eventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)eventNode));
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("Message-" + eventDefinition.getName());
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
        eventNode.setMetaData("TriggerRef", (Object)eventDefinition.getName());
        eventNode.setMetaData("EventType", (Object)"message");
        eventNode.setMetaData("MessageType", (Object)JSON_NODE);
        eventNode.setMetaData("filterExpression", (Object)("hasAttributeWithValue(eventData, \"type\", \"" + eventDefinition.getType() + "\")"));
        eventNode.setVariableName(DEFAULT_WORKFLOW_VAR);
        if (eventDefinition.getMetadata() != null) {
            eventDefinition.getMetadata().forEach((k, v) -> eventNode.setMetaData(k, v));
        }
        if (eventDefinition.getCorrelation() != null && !eventDefinition.getCorrelation().isEmpty()) {
            eventNode.setMetaData("TriggerCorrelationExpr", (Object)("extensionAttribute(eventData, \"" + ((CorrelationDef)eventDefinition.getCorrelation().get(0)).getContextAttributeName() + "\")"));
        }
        boolean useData = true;
        String outputFilter = null;
        String scopeFilter = null;
        if (eventDataFilter != null) {
            useData = eventDataFilter.isUseData();
            outputFilter = this.unwrapExpression(eventDataFilter.getData());
            scopeFilter = this.unwrapExpression(eventDataFilter.getToStateData());
        }
        if (useData) {
            Assignment outAssignment = new Assignment("jq", null, null);
            outAssignment.setMetaData("Action", (Object)new TaskOutputJqAssignmentAction(outputFilter, scopeFilter, true));
            eventNode.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outAssignment), null));
        }
        nodeContainer.addNode((Node)eventNode);
        return eventNode;
    }

    public ActionNode scriptNode(long id, String name, String script, NodeContainer nodeContainer) {
        ActionNode scriptNode = new ActionNode();
        scriptNode.setId(id);
        scriptNode.setName(this.nameOrDefault(name, "Unnamed action"));
        scriptNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)scriptNode));
        ProcessAction processAction = new ProcessAction();
        processAction.setMetaData("Action", (Object)script);
        scriptNode.setAction(processAction);
        scriptNode.setAction((ProcessAction)new ConsequenceAction("java", script));
        nodeContainer.addNode((Node)scriptNode);
        return scriptNode;
    }

    public WorkItemNode serviceNode(long id, Action action, FunctionDefinition function, NodeContainer nodeContainer) {
        String actionName = action.getName();
        String[] operationParts = function.getOperation().split("#");
        String interfaceStr = operationParts[0];
        String operationStr = operationParts[1];
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(id);
        workItemNode.setName(this.nameOrDefault(actionName, "Unnamed action"));
        workItemNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)workItemNode));
        workItemNode.setMetaData("Type", (Object)SERVICE_TASK_TYPE);
        workItemNode.setMetaData("Implementation", (Object)"##WebService");
        WorkImpl work = new WorkImpl();
        workItemNode.setWork((Work)work);
        work.setName(SERVICE_TASK_TYPE);
        work.setParameter("Interface", (Object)interfaceStr);
        work.setParameter("Operation", (Object)operationStr);
        work.setParameter("interfaceImplementationRef", (Object)interfaceStr);
        work.setParameter(SERVICE_IMPL_KEY, (Object)"##WebService");
        JsonNode params = action.getFunctionRef().getArguments();
        String inputFilter = null;
        String outputFilter = null;
        String scopeFilter = null;
        boolean useResults = true;
        if (action.getActionDataFilter() != null) {
            inputFilter = this.unwrapExpression(action.getActionDataFilter().getFromStateData());
            outputFilter = this.unwrapExpression(action.getActionDataFilter().getResults());
            scopeFilter = this.unwrapExpression(action.getActionDataFilter().getToStateData());
            useResults = action.getActionDataFilter().isUseResults();
        }
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        if (params != null) {
            Iterator it = params.fieldNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = params.get(name).toString();
                work.setParameter(name, (Object)this.unwrapExpression(value));
                paramNames.add(name);
                work.addParameterDefinition((ParameterDefinition)new ParameterDefinitionImpl(name, (DataType)new JsonNodeDataType()));
            }
        } else {
            work.setParameter("ParameterType", (Object)JSON_NODE);
        }
        Assignment assignment = new Assignment("jq", null, null);
        assignment.setMetaData("Action", (Object)new TaskInputJqAssignmentAction(inputFilter, paramNames));
        workItemNode.addInAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(assignment), null));
        if (useResults) {
            Assignment outAssignment = new Assignment("jq", null, null);
            outAssignment.setMetaData("Action", (Object)new TaskOutputJqAssignmentAction(outputFilter, scopeFilter));
            workItemNode.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outAssignment), null));
        }
        nodeContainer.addNode((Node)workItemNode);
        return workItemNode;
    }

    public void processVar(String varName, Class<?> varType, ExecutableProcess process) {
        Variable variable = new Variable();
        variable.setName(varName);
        variable.setType((DataType)new ObjectDataType(varType));
        process.getVariableScope().getVariables().add(variable);
    }

    public CompositeContextNode subProcessNode(long id, String name, NodeContainer nodeContainer) {
        CompositeContextNode subProcessNode = new CompositeContextNode();
        subProcessNode.setId(id);
        subProcessNode.setName(this.nameOrDefault(name, "Unnamed state"));
        subProcessNode.setAutoComplete(true);
        subProcessNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)subProcessNode));
        JsonVariableScope variableScope = new JsonVariableScope();
        subProcessNode.addContext((Context)variableScope);
        subProcessNode.setDefaultContext((Context)variableScope);
        nodeContainer.addNode((Node)subProcessNode);
        return subProcessNode;
    }

    public Split splitNode(long id, String name, int type, NodeContainer nodeContainer) {
        Split split = new Split();
        split.setId(id);
        split.setName(this.nameOrDefault(name, "Unnamed split"));
        split.setType(type);
        split.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)split));
        nodeContainer.addNode((Node)split);
        return split;
    }

    public Split eventBasedSplit(long id, String name, NodeContainer nodeContainer) {
        Split split = new Split();
        split.setId(id);
        split.setName(this.nameOrDefault(name, "Unnamed split"));
        split.setType(4);
        split.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)split));
        split.setMetaData(EVENTBASED_PARAM, (Object)"true");
        nodeContainer.addNode((Node)split);
        return split;
    }

    public Join joinNode(long id, String name, int type, NodeContainer nodeContainer) {
        Join join = new Join();
        join.setId(id);
        join.setName(this.nameOrDefault(name, "Unnamed join"));
        join.setType(type);
        join.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)join));
        nodeContainer.addNode((Node)join);
        return join;
    }

    public ConstraintImpl splitConstraint(String name, String type, String dialect, String constraint, int priority, boolean isDefault) {
        ConstraintImpl constraintImpl = new ConstraintImpl();
        constraintImpl.setName(this.nameOrDefault(name, "Unnamed split"));
        constraintImpl.setType(type);
        constraintImpl.setDialect(dialect);
        constraintImpl.setConstraint(constraint);
        constraintImpl.setPriority(priority);
        constraintImpl.setDefault(isDefault);
        return constraintImpl;
    }

    public HumanTaskNode humanTaskNode(long id, String name, FunctionDefinition function, ExecutableProcess process, NodeContainer nodeContainer) {
        HumanTaskNode humanTaskNode = new HumanTaskNode();
        humanTaskNode.setId(id);
        humanTaskNode.setName(this.nameOrDefault(name, "Unnamed user operation"));
        WorkImpl work = new WorkImpl();
        work.setName("Human Task");
        humanTaskNode.setWork((Work)work);
        humanTaskNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)humanTaskNode));
        work.setParameter("NodeName", (Object)name);
        humanTaskNode.addInMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)humanTaskNode);
        return humanTaskNode;
    }

    public BoundaryEventNode compensationBoundaryEventNode(long id, String name, ExecutableProcess process, Node attachToNode) {
        BoundaryEventNode boundaryEventNode = new BoundaryEventNode();
        boundaryEventNode.setId(id);
        boundaryEventNode.setName(this.nameOrDefault(name, "Unnamed compensation"));
        boundaryEventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)boundaryEventNode));
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType("Compensation");
        boundaryEventNode.addEventFilter((EventFilter)filter);
        boundaryEventNode.setAttachedToNodeId(Long.toString(attachToNode.getId()));
        boundaryEventNode.setMetaData("EventType", (Object)"compensation");
        boundaryEventNode.setMetaData("AttachedTo", (Object)Long.toString(attachToNode.getId()));
        process.addNode((Node)boundaryEventNode);
        return boundaryEventNode;
    }

    public BoundaryEventNode errorBoundaryEventNode(long id, List<ErrorDefinition> defs, RetryDefinition retry, NodeContainer nodeContainer, Node attachedTo, Workflow workflow) {
        BoundaryEventNode boundaryEventNode = new BoundaryEventNode();
        boundaryEventNode.setId(id);
        boundaryEventNode.setName(defs.stream().map(def -> def.getName()).collect(Collectors.joining("|")));
        boundaryEventNode.setMetaData(UNIQUE_ID_PARAM, (Object)this.generateUiqueId((Node)boundaryEventNode));
        String errorCodes = defs.stream().map(def -> def.getCode()).collect(Collectors.joining(","));
        String attachedToId = attachedTo.getMetaData().getOrDefault(UNIQUE_ID_PARAM, Long.toString(attachedTo.getId()));
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType("Error-" + attachedToId + "-" + errorCodes);
        boundaryEventNode.addEventFilter((EventFilter)filter);
        boundaryEventNode.setAttachedToNodeId(attachedToId);
        boundaryEventNode.setMetaData("EventType", (Object)"error");
        boundaryEventNode.setMetaData("ErrorEvent", (Object)errorCodes);
        boundaryEventNode.setMetaData("AttachedTo", (Object)attachedToId);
        boundaryEventNode.setMetaData("HasErrorEvent", (Object)true);
        if (retry != null) {
            int delayAsInt = Long.valueOf(DateTimeUtils.parseDuration((String)retry.getDelay())).intValue();
            boundaryEventNode.setMetaData("ErrorRetry", (Object)(retry.getDelay() == null ? 1000 : delayAsInt));
            boundaryEventNode.setMetaData("ErrorRetryLimit", (Object)(retry.getMaxAttempts() == null ? 3 : Integer.parseInt(retry.getMaxAttempts())));
            if (retry.getMultiplier() != null) {
                boundaryEventNode.setMetaData("ErrorRetryIncrementMultiplier", (Object)Float.valueOf(Float.parseFloat(retry.getMultiplier())));
            }
        }
        nodeContainer.addNode((Node)boundaryEventNode);
        return boundaryEventNode;
    }

    public Connection connect(long fromId, long toId, String uniqueId, NodeContainer nodeContainer, boolean association) {
        Node from = nodeContainer.getNode(fromId);
        Node to = nodeContainer.getNode(toId);
        ConnectionImpl connection = new ConnectionImpl(from, "DEFAULT", to, "DEFAULT");
        connection.setMetaData(UNIQUE_ID_PARAM, (Object)uniqueId);
        if (association) {
            connection.setMetaData("association", (Object)true);
        }
        if (from instanceof CompositeNode) {
            this.appendDiagramItem(nodeContainer, (String)Stream.of(((CompositeNode)from).getNodes()).filter(n -> n instanceof EndNode).findFirst().get().getMetaData().get(UNIQUE_ID_PARAM), (String)to.getMetaData().get(UNIQUE_ID_PARAM));
        } else if (to instanceof CompositeNode) {
            this.appendDiagramItem(nodeContainer, (String)from.getMetaData().get(UNIQUE_ID_PARAM), (String)Stream.of(((CompositeNode)to).getNodes()).filter(n -> n instanceof StartNode).findFirst().get().getMetaData().get(UNIQUE_ID_PARAM));
        } else {
            this.appendDiagramItem(nodeContainer, (String)from.getMetaData().get(UNIQUE_ID_PARAM), (String)to.getMetaData().get(UNIQUE_ID_PARAM));
        }
        return connection;
    }

    public void addExecutionTimeout(long id, WorkflowExecTimeout timeout, ExecutableProcess process) {
        process.setMetaData("timeout", (Object)timeout.getDuration());
        if (timeout.getRunBefore() != null) {
            ArrayList<Long> timeoutNodes = new ArrayList<Long>();
            for (Node node : process.getNodes()) {
                if (!node.getName().equals(timeout.getRunBefore())) continue;
                timeoutNodes.add(node.getId());
                this.collectConnectedNodes(node, (NodeContainer)process, timeoutNodes);
                break;
            }
            process.setMetaData("timeoutNodes", (Object)timeoutNodes.stream().map(l -> Long.toString(l)).collect(Collectors.joining(",")));
        }
    }

    public void validate(ExecutableProcess process) {
        ProcessValidationError[] errors;
        for (ProcessValidationError error : errors = ExecutableProcessValidator.getInstance().validateProcess(process)) {
            LOGGER.error(error.toString());
        }
        if (errors.length > 0) {
            throw new RuntimeException("Workflow could not be validated !");
        }
    }

    public void collectConnectedNodes(Node start, NodeContainer container, List<Long> nodeIds) {
        List outgoingConnections = start.getOutgoingConnections("DEFAULT");
        if (outgoingConnections.isEmpty()) {
            return;
        }
        for (Connection conn : outgoingConnections) {
            nodeIds.add(conn.getTo().getId());
            this.collectConnectedNodes(conn.getTo(), container, nodeIds);
        }
    }

    public String unwrapExpression(String input) {
        if (input == null) {
            return null;
        }
        String trimmed = input.trim();
        if (input.startsWith("${")) {
            return trimmed.trim().substring(2, trimmed.length() - 2);
        }
        if (input.startsWith("\"${")) {
            return trimmed.trim().substring(3, trimmed.length() - 3);
        }
        if (input.startsWith("\"")) {
            return trimmed.trim().substring(1, trimmed.length() - 1);
        }
        return input.trim();
    }

    protected String escapeExpression(String expression) {
        if (expression == null) {
            return null;
        }
        return "\"" + expression.replaceAll("\\\"", "\\\\\"") + "\"";
    }

    protected void appendDiagramItem(NodeContainer nodeContainer, String source, String target) {
        Process process = this.findProcess(nodeContainer);
        Map diagram = (Map)process.getMetaData().get("DiagramInfo");
        diagram.compute(source, (k, v) -> {
            if (v == null) {
                v = new ArrayList<String>();
            }
            if (v.contains(target)) {
                v.remove(target);
            }
            v.add(target);
            return v;
        });
    }

    private Process findProcess(NodeContainer nodeContainer) {
        while (nodeContainer instanceof Node) {
            nodeContainer = (NodeContainer)((Node)nodeContainer).getParentContainer();
        }
        return (Process)nodeContainer;
    }

    protected String generateUiqueId(Node node) {
        return UUID.nameUUIDFromBytes((node.getClass().getName() + "_" + node.getId()).getBytes()).toString();
    }

    protected String nameOrDefault(String name, String defaultName) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return defaultName;
    }
}

