/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.serverless.parser;

import io.automatiko.engine.api.definition.process.Connection;
import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.workflow.base.core.timer.DateTimeUtils;
import io.automatiko.engine.workflow.base.instance.impl.ReturnValueConstraintEvaluator;
import io.automatiko.engine.workflow.base.instance.impl.ReturnValueEvaluator;
import io.automatiko.engine.workflow.base.instance.impl.jq.InputJqAssignmentAction;
import io.automatiko.engine.workflow.base.instance.impl.jq.JqReturnValueEvaluator;
import io.automatiko.engine.workflow.base.instance.impl.jq.OutputJqAssignmentAction;
import io.automatiko.engine.workflow.process.core.Constraint;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.Assignment;
import io.automatiko.engine.workflow.process.core.node.BoundaryEventNode;
import io.automatiko.engine.workflow.process.core.node.CompositeContextNode;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.EndNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.Join;
import io.automatiko.engine.workflow.process.core.node.Split;
import io.automatiko.engine.workflow.process.core.node.StartNode;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import io.automatiko.engine.workflow.process.core.node.TimerNode;
import io.automatiko.engine.workflow.process.core.node.WorkItemNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import io.automatiko.engine.workflow.serverless.parser.ServerlessWorkflowFactory;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.retry.RetryDefinition;
import io.serverlessworkflow.api.states.CallbackState;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.EventState;
import io.serverlessworkflow.api.states.InjectState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.states.SleepState;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.utils.WorkflowUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

public class ServerlessWorkflowParser {
    public Process parse(Reader workflowFile) {
        Object endNode;
        StartNode startNode;
        AtomicLong ids = new AtomicLong(0L);
        Workflow workflow = Workflow.fromSource((String)this.toString(workflowFile));
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        if (!"jq".equalsIgnoreCase(workflow.getExpressionLang())) {
            throw new IllegalArgumentException("Not supported expression language, only 'jq' is supported");
        }
        ExecutableProcess process = factory.createProcess(workflow);
        LinkedHashMap diagram = new LinkedHashMap();
        process.setMetaData("DiagramInfo", diagram);
        State start = WorkflowUtils.getStartingState((Workflow)workflow);
        if (start.getType().equals((Object)DefaultState.Type.EVENT)) {
            ArrayList nodes = new ArrayList();
            EventState eventState = (EventState)start;
            for (OnEvents onEvent : eventState.getOnEvents()) {
                StartNode startMessageNode;
                EventDefinition event;
                if (eventState.isExclusive()) {
                    Join join = factory.joinNode(ids.getAndIncrement(), "join_" + eventState.getName(), 2, (NodeContainer)process);
                    for (String eventRef : onEvent.getEventRefs()) {
                        event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(eventRef)).findFirst().get();
                        startMessageNode = factory.messageStartNode(ids.getAndIncrement(), event, onEvent, (NodeContainer)process);
                        factory.connect(startMessageNode.getId(), join.getId(), "connection_" + startMessageNode.getId() + "_" + join.getId(), (NodeContainer)process, false);
                    }
                    this.buildActionsForState(workflow, onEvent.getActions(), (NodeContainer)process, factory, ids, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$1(factory, join, (WorkflowProcess)process, nodes, arg_0, arg_1), (first, last) -> {}, false);
                    continue;
                }
                Join parallelJoin = factory.joinNode(ids.getAndIncrement(), "join_" + eventState.getName(), 1, (NodeContainer)process);
                for (String eventRef : onEvent.getEventRefs()) {
                    event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(eventRef)).findFirst().get();
                    startMessageNode = factory.messageStartNode(ids.getAndIncrement(), event, onEvent, (NodeContainer)process);
                    factory.connect(startMessageNode.getId(), parallelJoin.getId(), "connection_" + startMessageNode.getId() + "_" + parallelJoin.getId(), (NodeContainer)process, false);
                }
                this.buildActionsForState(workflow, onEvent.getActions(), (NodeContainer)process, factory, ids, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$4(factory, parallelJoin, (WorkflowProcess)process, nodes, arg_0, arg_1), (first, last) -> {}, false);
            }
            startNode = (io.automatiko.engine.workflow.process.core.Node)nodes.get(0);
            if (eventState.getStateDataFilter() != null && eventState.getStateDataFilter().getOutput() != null) {
                ActionNode stateDataFilterActionNode = factory.stateDataFilterActionNode(ids.getAndIncrement(), "", (NodeContainer)process, eventState.getStateDataFilter().getOutput());
                factory.connect(startNode.getId(), stateDataFilterActionNode.getId(), "connection_" + startNode.getId() + "_" + stateDataFilterActionNode.getId(), (NodeContainer)process, false);
                startNode = stateDataFilterActionNode;
            }
            if (eventState.getEnd() != null) {
                EndNode endNode2 = factory.endNode(ids.getAndIncrement(), eventState.getName() + "-end", eventState.getEnd().isTerminate(), (NodeContainer)process);
                if (eventState.getEnd().getProduceEvents() != null && !eventState.getEnd().getProduceEvents().isEmpty()) {
                    this.produceEvents(eventState.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, startNode.getId(), endNode2.getId());
                } else {
                    factory.connect(startNode.getId(), endNode2.getId(), "connection_" + startNode.getId() + "_" + endNode2.getId(), (NodeContainer)process, false);
                }
            }
        } else {
            startNode = factory.startNode(ids.getAndIncrement(), start.getName() + "-start", (NodeContainer)process);
        }
        LinkedHashMap<String, Long> mappedNodes = new LinkedHashMap<String, Long>();
        Object currentNode = null;
        for (State state : workflow.getStates()) {
            EndNode embeddedEndNode;
            StartNode embeddedStartNode;
            Assignment outputAssignment;
            Assignment inputAssignment;
            Object embeddedSubProcess;
            EndNode endNode3;
            if (state.getType().equals((Object)DefaultState.Type.INJECT)) {
                ActionNode actionNode = factory.injectStateNode(ids.getAndIncrement(), state.getName(), (NodeContainer)process, ((InjectState)state).getData().toString());
                mappedNodes.put(state.getName(), actionNode.getId());
                if (state.getEnd() != null) {
                    endNode3 = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, actionNode.getId(), endNode3.getId());
                    } else {
                        factory.connect(actionNode.getId(), endNode3.getId(), "connection_" + actionNode.getId() + "_" + endNode3.getId(), (NodeContainer)process, false);
                    }
                }
                currentNode = actionNode;
            } else if (state.getType().equals((Object)DefaultState.Type.OPERATION)) {
                EndNode endNode4;
                OperationState operationState = (OperationState)state;
                embeddedSubProcess = factory.subProcessNode(ids.getAndIncrement(), state.getName(), (NodeContainer)process);
                currentNode = embeddedSubProcess;
                inputAssignment = new Assignment("jq", "", "");
                inputAssignment.setMetaData("Action", (Object)new InputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getInput())));
                embeddedSubProcess.addInAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(inputAssignment), null));
                outputAssignment = new Assignment("jq", "", "");
                outputAssignment.setMetaData("Action", (Object)new OutputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getOutput())));
                embeddedSubProcess.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outputAssignment), null));
                mappedNodes.put(state.getName(), embeddedSubProcess.getId());
                embeddedStartNode = factory.startNode(ids.getAndIncrement(), "EmbeddedStart", (NodeContainer)embeddedSubProcess);
                embeddedEndNode = factory.endNode(ids.getAndIncrement(), "EmbeddedEnd", false, (NodeContainer)embeddedSubProcess);
                if (operationState.getActions() == null || operationState.getActions().isEmpty()) {
                    factory.connect(embeddedStartNode.getId(), embeddedEndNode.getId(), embeddedStartNode.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess, false);
                    if (state.getEnd() != null) {
                        endNode4 = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                        if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                            this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, embeddedSubProcess.getId(), endNode4.getId());
                        } else {
                            factory.connect(embeddedSubProcess.getId(), endNode4.getId(), "connection_" + embeddedSubProcess.getId() + "_" + endNode4.getId(), (NodeContainer)process, false);
                        }
                    }
                    if (!state.equals(start) || currentNode == null) continue;
                    factory.connect(startNode.getId(), currentNode.getId(), "connection_" + startNode.getId() + "_" + currentNode.getId(), (NodeContainer)process, false);
                    continue;
                }
                if (operationState.getActionMode() == null || operationState.getActionMode() == OperationState.ActionMode.SEQUENTIAL) {
                    this.buildActionsForState(workflow, operationState.getActions(), (NodeContainer)embeddedSubProcess, factory, ids, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$6(factory, embeddedStartNode, (CompositeContextNode)embeddedSubProcess, embeddedEndNode, arg_0, arg_1), (first, last) -> {}, false);
                } else {
                    Split split = factory.splitNode(ids.getAndIncrement(), "parallel-split-" + state.getName(), 1, (NodeContainer)embeddedSubProcess);
                    Join join = factory.joinNode(ids.getAndIncrement(), "parallel-join-" + state.getName(), 1, (NodeContainer)embeddedSubProcess);
                    factory.connect(embeddedStartNode.getId(), split.getId(), embeddedStartNode.getId() + "_" + split.getId(), (NodeContainer)embeddedSubProcess, false);
                    factory.connect(join.getId(), embeddedEndNode.getId(), join.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess, false);
                    this.buildActionsForState(workflow, operationState.getActions(), (NodeContainer)embeddedSubProcess, factory, ids, (first, last) -> {}, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$9(factory, split, (CompositeContextNode)embeddedSubProcess, join, arg_0, arg_1), true);
                }
                if (state.getEnd() != null) {
                    endNode4 = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, embeddedSubProcess.getId(), endNode4.getId());
                    } else {
                        factory.connect(embeddedSubProcess.getId(), endNode4.getId(), "connection_" + embeddedSubProcess.getId() + "_" + endNode4.getId(), (NodeContainer)process, false);
                    }
                }
            } else if (state.getType().equals((Object)DefaultState.Type.EVENT)) {
                EventState eventState = (EventState)state;
                if (eventState.equals(start)) continue;
                for (OnEvents onEvent : eventState.getOnEvents()) {
                    EventNode eventNode;
                    EventDefinition event;
                    CompositeContextNode embeddedSubProcess2;
                    currentNode = embeddedSubProcess2 = factory.subProcessNode(ids.getAndIncrement(), state.getName(), (NodeContainer)process);
                    Assignment inputAssignment2 = new Assignment("jq", "", "");
                    inputAssignment2.setMetaData("Action", (Object)new InputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getInput())));
                    embeddedSubProcess2.addInAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(inputAssignment2), null));
                    Assignment outputAssignment2 = new Assignment("jq", "", "");
                    outputAssignment2.setMetaData("Action", (Object)new OutputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getOutput())));
                    embeddedSubProcess2.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outputAssignment2), null));
                    mappedNodes.put(state.getName(), embeddedSubProcess2.getId());
                    StartNode embeddedStartNode2 = factory.startNode(ids.getAndIncrement(), "EmbeddedStart", (NodeContainer)embeddedSubProcess2);
                    EndNode embeddedEndNode2 = factory.endNode(ids.getAndIncrement(), "EmbeddedEnd", false, (NodeContainer)embeddedSubProcess2);
                    if (eventState.isExclusive()) {
                        Split eventSplit = factory.eventBasedSplit(ids.getAndIncrement(), "split_" + state.getName(), (NodeContainer)embeddedSubProcess2);
                        Join join = factory.joinNode(ids.getAndIncrement(), "join_" + state.getName(), 2, (NodeContainer)embeddedSubProcess2);
                        factory.connect(embeddedStartNode2.getId(), eventSplit.getId(), "connection_" + embeddedStartNode2.getId() + "_" + eventSplit.getId(), (NodeContainer)embeddedSubProcess2, false);
                        for (String eventRef : onEvent.getEventRefs()) {
                            event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(eventRef)).findFirst().get();
                            eventNode = factory.consumeEventNode(ids.getAndIncrement(), event, onEvent.getEventDataFilter(), (NodeContainer)embeddedSubProcess2);
                            factory.connect(eventSplit.getId(), eventNode.getId(), "connection_" + eventSplit.getId() + "_" + eventNode.getId(), (NodeContainer)embeddedSubProcess2, false);
                            factory.connect(eventNode.getId(), join.getId(), "connection_" + eventNode.getId() + "_" + join.getId(), (NodeContainer)embeddedSubProcess2, false);
                        }
                        this.buildActionsForState(workflow, onEvent.getActions(), (NodeContainer)embeddedSubProcess2, factory, ids, (first, last) -> {
                            factory.connect(join.getId(), first.getId(), join.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess2, false);
                            factory.connect(last.getId(), embeddedEndNode2.getId(), last.getId() + "_" + embeddedEndNode2.getId(), (NodeContainer)embeddedSubProcess2, false);
                        }, (first, last) -> {}, false);
                    } else {
                        Split parallelSplit = factory.splitNode(ids.getAndIncrement(), "split_" + state.getName(), 1, (NodeContainer)embeddedSubProcess2);
                        Join parallelJoin = factory.joinNode(ids.getAndIncrement(), "join_" + state.getName(), 1, (NodeContainer)embeddedSubProcess2);
                        factory.connect(embeddedStartNode2.getId(), parallelSplit.getId(), "connection_" + embeddedStartNode2.getId() + "_" + parallelSplit.getId(), (NodeContainer)embeddedSubProcess2, false);
                        for (String eventRef : onEvent.getEventRefs()) {
                            event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(eventRef)).findFirst().get();
                            eventNode = factory.consumeEventNode(ids.getAndIncrement(), event, onEvent.getEventDataFilter(), (NodeContainer)embeddedSubProcess2);
                            factory.connect(parallelSplit.getId(), eventNode.getId(), "connection_" + parallelSplit.getId() + "_" + eventNode.getId(), (NodeContainer)embeddedSubProcess2, false);
                            factory.connect(eventNode.getId(), parallelJoin.getId(), "connection_" + eventNode.getId() + "_" + parallelJoin.getId(), (NodeContainer)embeddedSubProcess2, false);
                        }
                        this.buildActionsForState(workflow, onEvent.getActions(), (NodeContainer)embeddedSubProcess2, factory, ids, (first, last) -> {
                            factory.connect(parallelJoin.getId(), first.getId(), parallelJoin.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess2, false);
                            factory.connect(last.getId(), embeddedEndNode2.getId(), last.getId() + "_" + embeddedEndNode2.getId(), (NodeContainer)embeddedSubProcess2, false);
                        }, (first, last) -> {}, false);
                    }
                    if (state.getEnd() == null) continue;
                    endNode = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, embeddedSubProcess2.getId(), endNode.getId());
                        continue;
                    }
                    factory.connect(embeddedSubProcess2.getId(), endNode.getId(), "connection_" + embeddedSubProcess2.getId() + "_" + endNode.getId(), (NodeContainer)process, false);
                }
            } else if (state.getType().equals((Object)DefaultState.Type.CALLBACK)) {
                CallbackState callcackState = (CallbackState)state;
                embeddedSubProcess = factory.subProcessNode(ids.getAndIncrement(), state.getName(), (NodeContainer)process);
                currentNode = embeddedSubProcess;
                inputAssignment = new Assignment("jq", "", "");
                inputAssignment.setMetaData("Action", (Object)new InputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getInput())));
                embeddedSubProcess.addInAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(inputAssignment), null));
                outputAssignment = new Assignment("jq", "", "");
                outputAssignment.setMetaData("Action", (Object)new OutputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getOutput())));
                embeddedSubProcess.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outputAssignment), null));
                mappedNodes.put(state.getName(), embeddedSubProcess.getId());
                embeddedStartNode = factory.startNode(ids.getAndIncrement(), "EmbeddedStart", (NodeContainer)embeddedSubProcess);
                embeddedEndNode = factory.endNode(ids.getAndIncrement(), "EmbeddedEnd", false, (NodeContainer)embeddedSubProcess);
                EventDefinition event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(callcackState.getEventRef())).findFirst().get();
                EventNode eventNode = factory.consumeEventNode(ids.getAndIncrement(), event, callcackState.getEventDataFilter(), (NodeContainer)embeddedSubProcess);
                this.buildActionsForState(workflow, Collections.singletonList(callcackState.getAction()), (NodeContainer)embeddedSubProcess, factory, ids, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$17(factory, embeddedStartNode, (CompositeContextNode)embeddedSubProcess, eventNode, arg_0, arg_1), (first, last) -> {}, false);
                factory.connect(eventNode.getId(), embeddedEndNode.getId(), "connection_" + eventNode.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess, false);
                if (state.getEnd() != null) {
                    endNode = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, embeddedSubProcess.getId(), endNode.getId());
                    } else {
                        factory.connect(embeddedSubProcess.getId(), endNode.getId(), "connection_" + embeddedSubProcess.getId() + "_" + endNode.getId(), (NodeContainer)process, false);
                    }
                }
            } else if (state.getType().equals((Object)DefaultState.Type.SLEEP)) {
                TimerNode sleep = factory.timerNode(ids.getAndIncrement(), "sleep-" + state.getName(), ((SleepState)state).getDuration(), (NodeContainer)process);
                mappedNodes.put(state.getName(), sleep.getId());
                if (state.getEnd() != null) {
                    endNode3 = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, sleep.getId(), endNode3.getId());
                    } else {
                        factory.connect(sleep.getId(), endNode3.getId(), "connection_" + sleep.getId() + "_" + endNode3.getId(), (NodeContainer)process, false);
                    }
                }
                currentNode = sleep;
            } else if (state.getType().equals((Object)DefaultState.Type.PARALLEL)) {
                Join parallelJoin;
                ParallelState parallelState = (ParallelState)state;
                embeddedSubProcess = factory.subProcessNode(ids.getAndIncrement(), state.getName(), (NodeContainer)process);
                currentNode = embeddedSubProcess;
                inputAssignment = new Assignment("jq", "", "");
                inputAssignment.setMetaData("Action", (Object)new InputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getInput())));
                embeddedSubProcess.addInAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(inputAssignment), null));
                outputAssignment = new Assignment("jq", "", "");
                outputAssignment.setMetaData("Action", (Object)new OutputJqAssignmentAction(state.getStateDataFilter() == null ? null : factory.unwrapExpression(state.getStateDataFilter().getOutput())));
                embeddedSubProcess.addOutAssociation(new DataAssociation(Collections.emptyList(), "", Arrays.asList(outputAssignment), null));
                mappedNodes.put(state.getName(), embeddedSubProcess.getId());
                embeddedStartNode = factory.startNode(ids.getAndIncrement(), "EmbeddedStart", (NodeContainer)embeddedSubProcess);
                embeddedEndNode = factory.endNode(ids.getAndIncrement(), "EmbeddedEnd", false, (NodeContainer)embeddedSubProcess);
                Split parallelSplit = factory.splitNode(ids.getAndIncrement(), "split_" + state.getName(), 1, (NodeContainer)embeddedSubProcess);
                if (parallelState.getCompletionType().equals((Object)ParallelState.CompletionType.AT_LEAST)) {
                    parallelJoin = factory.joinNode(ids.getAndIncrement(), "join_" + state.getName(), 4, (NodeContainer)embeddedSubProcess);
                    parallelJoin.setN(parallelState.getNumCompleted());
                } else {
                    parallelJoin = factory.joinNode(ids.getAndIncrement(), "join_" + state.getName(), 1, (NodeContainer)embeddedSubProcess);
                }
                factory.connect(embeddedStartNode.getId(), parallelSplit.getId(), "connection_" + embeddedStartNode.getId() + "_" + parallelSplit.getId(), (NodeContainer)embeddedSubProcess, false);
                for (Branch branch : parallelState.getBranches()) {
                    this.buildActionsForState(workflow, branch.getActions(), (NodeContainer)embeddedSubProcess, factory, ids, (arg_0, arg_1) -> ServerlessWorkflowParser.lambda$parse$19(factory, parallelSplit, (CompositeContextNode)embeddedSubProcess, parallelJoin, arg_0, arg_1), (first, last) -> {}, true);
                }
                factory.connect(parallelJoin.getId(), embeddedEndNode.getId(), "connection_" + parallelJoin.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess, false);
                if (state.getEnd() != null) {
                    endNode = factory.endNode(ids.getAndIncrement(), state.getName() + "-end", state.getEnd().isTerminate(), (NodeContainer)process);
                    if (state.getEnd().getProduceEvents() != null && !state.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(state.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, embeddedSubProcess.getId(), endNode.getId());
                    } else {
                        factory.connect(embeddedSubProcess.getId(), endNode.getId(), "connection_" + embeddedSubProcess.getId() + "_" + endNode.getId(), (NodeContainer)process, false);
                    }
                }
            } else if (state.getType().equals((Object)DefaultState.Type.FOREACH)) {
                // empty if block
            }
            if (!state.equals(start) || currentNode == null) continue;
            factory.connect(startNode.getId(), currentNode.getId(), "connection_" + startNode.getId() + "_" + currentNode.getId(), (NodeContainer)process, false);
        }
        for (State state : workflow.getStates()) {
            Split splitNode;
            if (!state.getType().equals((Object)DefaultState.Type.SWITCH)) continue;
            SwitchState switchState = (SwitchState)state;
            if (switchState.getDataConditions() != null && !switchState.getDataConditions().isEmpty()) {
                splitNode = factory.splitNode(ids.getAndIncrement(), "split_" + state.getName(), 2, (NodeContainer)process);
                currentNode = splitNode;
                mappedNodes.put(state.getName(), splitNode.getId());
                int priority = 1;
                for (DataCondition condition : switchState.getDataConditions()) {
                    boolean isDefaultConstraint = false;
                    if (switchState.getDefaultCondition() != null && switchState.getDefaultCondition().getTransition() != null && condition.getTransition() != null && condition.getTransition().getNextState().equals(switchState.getDefaultCondition().getTransition().getNextState())) {
                        isDefaultConstraint = true;
                    }
                    if (switchState.getDefaultCondition() != null && switchState.getDefaultCondition().getEnd() != null && condition.getEnd() != null) {
                        isDefaultConstraint = true;
                    }
                    Connection outgoingConnection = null;
                    long target = 0L;
                    if (condition.getEnd() != null) {
                        EndNode endNode5 = factory.endNode(ids.getAndIncrement(), "end_" + switchState.getName(), false, (NodeContainer)process);
                        target = endNode5.getId();
                        outgoingConnection = factory.connect(splitNode.getId(), endNode5.getId(), "connection_" + splitNode.getId() + "_" + endNode5.getId(), (NodeContainer)process, false);
                    } else if (condition.getTransition() != null && condition.getTransition().getNextState() != null) {
                        long source = splitNode.getId();
                        target = (Long)mappedNodes.get(condition.getTransition().getNextState());
                        outgoingConnection = factory.connect(source, target, "connection_" + source + "_" + target, (NodeContainer)process, false);
                    }
                    ReturnValueConstraintEvaluator returnValueConstraint = new ReturnValueConstraintEvaluator();
                    returnValueConstraint.setDialect("jq");
                    returnValueConstraint.setName(splitNode.getId() + "_" + target);
                    returnValueConstraint.setPriority(priority);
                    returnValueConstraint.setDefault(isDefaultConstraint);
                    returnValueConstraint.setType("DROOLS_DEFAULT");
                    returnValueConstraint.setConstraint(factory.unwrapExpression(condition.getCondition()));
                    returnValueConstraint.setEvaluator((ReturnValueEvaluator)new JqReturnValueEvaluator(factory.unwrapExpression(condition.getCondition())));
                    splitNode.setConstraint(outgoingConnection, (Constraint)returnValueConstraint);
                }
            } else if (switchState.getEventConditions() != null && !switchState.getEventConditions().isEmpty()) {
                splitNode = factory.eventBasedSplit(ids.getAndIncrement(), "split_" + state.getName(), (NodeContainer)process);
                currentNode = splitNode;
                mappedNodes.put(state.getName(), splitNode.getId());
                for (EventCondition eventCondition : switchState.getEventConditions()) {
                    EventDefinition event = WorkflowUtils.getDefinedConsumedEvents((Workflow)workflow).stream().filter(e -> e.getName().equals(eventCondition.getEventRef())).findFirst().get();
                    EventNode eventNode = factory.consumeEventNode(ids.getAndIncrement(), event, eventCondition.getEventDataFilter(), (NodeContainer)process);
                    factory.connect(splitNode.getId(), eventNode.getId(), "connection_" + splitNode.getId() + "_" + eventNode.getId(), (NodeContainer)process, false);
                    long target = 0L;
                    if (eventCondition.getEnd() != null) {
                        endNode = factory.endNode(ids.getAndIncrement(), "end_" + switchState.getName(), false, (NodeContainer)process);
                        target = endNode.getId();
                        factory.connect(splitNode.getId(), endNode.getId(), "connection_" + splitNode.getId() + "_" + endNode.getId(), (NodeContainer)process, false);
                        continue;
                    }
                    if (eventCondition.getTransition() == null || eventCondition.getTransition().getNextState() == null) continue;
                    target = (Long)mappedNodes.get(eventCondition.getTransition().getNextState());
                    factory.connect(eventNode.getId(), target, "connection_" + eventNode.getId() + "_" + target, (NodeContainer)process, false);
                }
                if (switchState.getTimeouts() != null && switchState.getTimeouts().getEventTimeout() != null) {
                    TimerNode timer = factory.timerNode(ids.getAndIncrement(), "event-switch-timeout", switchState.getTimeouts().getEventTimeout(), (NodeContainer)process);
                    factory.connect(splitNode.getId(), timer.getId(), "connection_" + splitNode.getId() + "_" + timer.getId(), (NodeContainer)process, false);
                    EndNode endNode6 = factory.endNode(ids.getAndIncrement(), "end_" + switchState.getName(), false, (NodeContainer)process);
                    factory.connect(timer.getId(), endNode6.getId(), "connection_" + timer.getId() + "_" + endNode6.getId(), (NodeContainer)process, false);
                }
            }
            if (!state.equals(start) || currentNode == null) continue;
            factory.connect(startNode.getId(), currentNode.getId(), "connection_" + startNode.getId() + "_" + currentNode.getId(), (NodeContainer)process, false);
        }
        for (State state : workflow.getStates()) {
            if (!mappedNodes.containsKey(state.getName())) continue;
            long source = (Long)mappedNodes.get(state.getName());
            if (state.getTransition() == null || state.getTransition().getNextState() == null) continue;
            long target = (Long)mappedNodes.get(state.getTransition().getNextState());
            if (state.getTransition().getProduceEvents() != null && !state.getTransition().getProduceEvents().isEmpty()) {
                this.produceEvents(state.getTransition().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, source, target);
                continue;
            }
            factory.connect(source, target, "connection_" + source + "_" + target, (NodeContainer)process, false);
        }
        for (State state : workflow.getStates()) {
            long source;
            if (!mappedNodes.containsKey(state.getName()) || !(process.getNode(source = ((Long)mappedNodes.get(state.getName())).longValue()) instanceof CompositeContextNode)) continue;
            this.addErrorHandlingToState(workflow, state, factory, ids, (WorkflowProcess)process, (CompositeContextNode)process.getNode(source));
        }
        factory.validate(process);
        if (workflow.getTimeouts() != null && workflow.getTimeouts().getWorkflowExecTimeout() != null) {
            factory.addExecutionTimeout(ids.getAndIncrement(), workflow.getTimeouts().getWorkflowExecTimeout(), process);
        }
        process.setMetaData("SW-Workflow", (Object)workflow);
        return process;
    }

    public String toString(Reader reader) {
        try {
            int numCharsRead;
            char[] arr = new char[8192];
            StringBuilder buffer = new StringBuilder();
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            reader.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildActionsForState(Workflow workflow, List<Action> actions, NodeContainer embeddedSubProcess, ServerlessWorkflowFactory factory, AtomicLong ids, BiConsumer<io.automatiko.engine.workflow.process.core.Node, io.automatiko.engine.workflow.process.core.Node> firstLastNodeConsumer, BiConsumer<io.automatiko.engine.workflow.process.core.Node, io.automatiko.engine.workflow.process.core.Node> actionConsumer, boolean isParallel) {
        ActionNode firstNode = null;
        ActionNode lastNode = null;
        ActionNode prevNode = null;
        for (Action action : actions) {
            TimerNode sleep;
            if (action.getFunctionRef() != null) {
                Optional<FunctionDefinition> functionDefinition = workflow.getFunctions().getFunctionDefs().stream().filter(functionDef -> functionDef.getName().equals(action.getFunctionRef().getRefName())).distinct().findFirst();
                if (functionDefinition.get().getType() == FunctionDefinition.Type.EXPRESSION) {
                    ActionNode actionNode = factory.expressionActionStateNode(ids.getAndIncrement(), action.getName(), embeddedSubProcess, functionDefinition.get().getOperation(), action);
                    if (firstNode == null) {
                        firstNode = actionNode;
                    }
                    lastNode = actionNode;
                } else {
                    if (functionDefinition.get().getType() != null && functionDefinition.get().getType() != FunctionDefinition.Type.REST) throw new UnsupportedOperationException(functionDefinition.get().getType() + " is not yet supported");
                    WorkItemNode serviceNode = factory.serviceNode(ids.getAndIncrement(), action, functionDefinition.get(), embeddedSubProcess);
                    if (firstNode == null) {
                        firstNode = serviceNode;
                    }
                    lastNode = serviceNode;
                    if (workflow.getTimeouts() != null && workflow.getTimeouts().getActionExecTimeout() != null) {
                        serviceNode.setMetaData("timeout", (Object)String.valueOf(DateTimeUtils.parseDuration((String)workflow.getTimeouts().getActionExecTimeout())));
                    }
                    if (action.getRetryableErrors() != null && !action.getRetryableErrors().isEmpty()) {
                        ArrayList<ErrorDefinition> defs = new ArrayList<ErrorDefinition>();
                        for (String errorRef : action.getRetryableErrors()) {
                            ErrorDefinition errorDef = workflow.getErrors().getErrorDefs().stream().filter(error -> error.getName().equals(errorRef)).findFirst().orElseThrow(() -> new IllegalStateException("Missing error definition for " + errorRef));
                            defs.add(errorDef);
                        }
                        RetryDefinition retry = null;
                        BoundaryEventNode errorNode = factory.errorBoundaryEventNode(ids.getAndIncrement(), defs, retry, embeddedSubProcess, (Node)serviceNode, workflow);
                        EndNode onErrorEnd = factory.endNode(ids.getAndIncrement(), action.getName() + "onErrorEnd", false, embeddedSubProcess);
                        factory.connect(errorNode.getId(), onErrorEnd.getId(), "connect_" + errorNode.getId() + "_" + onErrorEnd.getId(), embeddedSubProcess, false);
                    }
                }
            } else if (action.getSubFlowRef() != null) {
                String workflowId = Objects.requireNonNull(action.getSubFlowRef().getWorkflowId(), "Workflow id for subworkflow is mandatory");
                boolean independent = false;
                if (action.getSubFlowRef().getOnParentComplete() != null && action.getSubFlowRef().getOnParentComplete().equals((Object)SubFlowRef.OnParentComplete.CONTINUE)) {
                    independent = true;
                }
                boolean waitForCompletion = true;
                if (action.getSubFlowRef().getInvoke().equals((Object)SubFlowRef.Invoke.ASYNC)) {
                    waitForCompletion = false;
                }
                SubProcessNode callactivity = factory.callActivity(ids.getAndIncrement(), action.getName(), workflowId, waitForCompletion, embeddedSubProcess);
                callactivity.setIndependent(independent);
                callactivity.setProcessVersion(action.getSubFlowRef().getVersion());
                if (firstNode == null) {
                    firstNode = callactivity;
                }
                lastNode = callactivity;
            }
            if (action.getSleep() != null && action.getSleep().getBefore() != null) {
                sleep = factory.timerNode(ids.getAndIncrement(), "sleep-before-" + action.getName(), action.getSleep().getBefore(), embeddedSubProcess);
                factory.connect(sleep.getId(), firstNode.getId(), "connection_" + sleep.getId() + "_" + firstNode.getId(), embeddedSubProcess, false);
                firstNode = sleep;
            }
            if (action.getSleep() != null && action.getSleep().getAfter() != null) {
                sleep = factory.timerNode(ids.getAndIncrement(), "sleep-after-" + action.getName(), action.getSleep().getAfter(), embeddedSubProcess);
                factory.connect(lastNode.getId(), sleep.getId(), "connection_" + lastNode.getId() + "_" + sleep.getId(), embeddedSubProcess, false);
                lastNode = sleep;
            }
            actionConsumer.accept((io.automatiko.engine.workflow.process.core.Node)firstNode, (io.automatiko.engine.workflow.process.core.Node)lastNode);
            if (isParallel && actions.size() > 1) {
                firstNode = null;
            } else if (prevNode != null) {
                factory.connect(prevNode.getId(), lastNode.getId(), "connect_" + prevNode.getId() + "_" + lastNode.getId(), embeddedSubProcess, false);
            }
            prevNode = lastNode;
        }
        firstLastNodeConsumer.accept((io.automatiko.engine.workflow.process.core.Node)firstNode, (io.automatiko.engine.workflow.process.core.Node)lastNode);
    }

    protected void addErrorHandlingToState(Workflow workflow, State state, ServerlessWorkflowFactory factory, AtomicLong ids, WorkflowProcess process, CompositeContextNode subprocess) {
        if (state.getOnErrors() != null) {
            block0: for (Error error : state.getOnErrors()) {
                ArrayList<ErrorDefinition> defs = new ArrayList<ErrorDefinition>();
                if (error.getErrorRef() != null) {
                    workflow.getErrors().getErrorDefs().stream().filter(err -> err.getName().equals(error.getErrorRef())).forEach(err -> defs.add((ErrorDefinition)err));
                } else {
                    workflow.getErrors().getErrorDefs().stream().filter(err -> error.getErrorRefs().contains(err.getName())).forEach(err -> defs.add((ErrorDefinition)err));
                }
                BoundaryEventNode errorNode = factory.errorBoundaryEventNode(ids.getAndIncrement(), defs, null, (NodeContainer)process, (Node)subprocess, workflow);
                if (error.getEnd() != null) {
                    EndNode onErrorEnd = factory.endNode(ids.getAndIncrement(), state.getName() + "onErrorEnd", error.getEnd().isTerminate(), (NodeContainer)process);
                    if (error.getEnd().getProduceEvents() != null && !error.getEnd().getProduceEvents().isEmpty()) {
                        this.produceEvents(error.getEnd().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, errorNode.getId(), onErrorEnd.getId());
                        continue;
                    }
                    factory.connect(errorNode.getId(), onErrorEnd.getId(), "connect_" + errorNode.getId() + "_" + onErrorEnd.getId(), (NodeContainer)process, false);
                    continue;
                }
                if (error.getTransition().getNextState() == null) continue;
                for (Node node : process.getNodes()) {
                    if (!node.getName().equals(error.getTransition().getNextState())) continue;
                    if (error.getTransition().getProduceEvents() != null && !error.getTransition().getProduceEvents().isEmpty()) {
                        this.produceEvents(error.getTransition().getProduceEvents(), factory, workflow, ids, (NodeContainer)process, errorNode.getId(), node.getId());
                        continue block0;
                    }
                    factory.connect(errorNode.getId(), node.getId(), "connect_" + errorNode.getId() + "_" + node.getId(), (NodeContainer)process, false);
                    continue block0;
                }
            }
        }
    }

    protected void produceEvents(List<ProduceEvent> events, ServerlessWorkflowFactory factory, Workflow workflow, AtomicLong ids, NodeContainer container, long startNodeId, long endNodeId) {
        ActionNode prevNode = null;
        ActionNode currentNode = null;
        for (ProduceEvent event : events) {
            currentNode = factory.produceMessageNode(ids.getAndIncrement(), "produceEvent_" + startNodeId, workflow, event, container);
            if (prevNode != null) {
                factory.connect(prevNode.getId(), currentNode.getId(), "connect_" + prevNode.getId() + "_" + currentNode.getId(), container, false);
            } else {
                factory.connect(startNodeId, currentNode.getId(), "connect_" + startNodeId + "_" + currentNode.getId(), container, false);
            }
            prevNode = currentNode;
        }
        factory.connect(prevNode.getId(), endNodeId, "connect_" + prevNode.getId() + "_" + endNodeId, container, false);
    }

    private static /* synthetic */ void lambda$parse$19(ServerlessWorkflowFactory factory, Split parallelSplit, CompositeContextNode embeddedSubProcess, Join parallelJoin, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(parallelSplit.getId(), first.getId(), parallelSplit.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess, false);
        factory.connect(last.getId(), parallelJoin.getId(), last.getId() + "_" + parallelJoin.getId(), (NodeContainer)embeddedSubProcess, false);
    }

    private static /* synthetic */ void lambda$parse$17(ServerlessWorkflowFactory factory, StartNode embeddedStartNode, CompositeContextNode embeddedSubProcess, EventNode eventNode, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(embeddedStartNode.getId(), first.getId(), embeddedStartNode.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess, false);
        factory.connect(last.getId(), eventNode.getId(), last.getId() + "_" + eventNode.getId(), (NodeContainer)embeddedSubProcess, false);
    }

    private static /* synthetic */ void lambda$parse$9(ServerlessWorkflowFactory factory, Split split, CompositeContextNode embeddedSubProcess, Join join, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(split.getId(), first.getId(), split.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess, false);
        factory.connect(last.getId(), join.getId(), last.getId() + "_" + join.getId(), (NodeContainer)embeddedSubProcess, false);
    }

    private static /* synthetic */ void lambda$parse$6(ServerlessWorkflowFactory factory, StartNode embeddedStartNode, CompositeContextNode embeddedSubProcess, EndNode embeddedEndNode, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(embeddedStartNode.getId(), first.getId(), embeddedStartNode.getId() + "_" + first.getId(), (NodeContainer)embeddedSubProcess, false);
        factory.connect(last.getId(), embeddedEndNode.getId(), last.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess, false);
    }

    private static /* synthetic */ void lambda$parse$4(ServerlessWorkflowFactory factory, Join parallelJoin, WorkflowProcess process, List nodes, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(parallelJoin.getId(), first.getId(), parallelJoin.getId() + "_" + first.getId(), (NodeContainer)process, false);
        nodes.add(last);
    }

    private static /* synthetic */ void lambda$parse$1(ServerlessWorkflowFactory factory, Join join, WorkflowProcess process, List nodes, io.automatiko.engine.workflow.process.core.Node first, io.automatiko.engine.workflow.process.core.Node last) {
        factory.connect(join.getId(), first.getId(), join.getId() + "_" + first.getId(), (NodeContainer)process, false);
        nodes.add(last);
    }
}

