/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.ModificationEvent;
import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

@NonNullApi
public class Config {
    private static final Configuration data = CoreConfiguration.initialise();

    private Config() {
    }

    public static Properties asProperties() {
        return data.asProperties();
    }

    public static Configuration forPath(String pathPrefix) {
        return data.forPath(pathPrefix);
    }

    public static Configuration asConfiguration() {
        return data;
    }

    public static void loadIntoSystemProperties() {
        data.loadIntoSystemProperties();
    }

    public static String get(String key) {
        return data.get(key);
    }

    public static String get(String key, String defaultValue) {
        return data.get(key, defaultValue);
    }

    public static Optional<String> getOptional(String key) {
        return data.getOptional(key);
    }

    public static Optional<String> getOptional(String key, @Nullable String defaultValue) {
        return data.getOptional(key, defaultValue);
    }

    @Nullable
    public static String getNullable(String key) {
        return data.getNullable(key);
    }

    @Nullable
    public static String getNullable(String key, @Nullable String defaultValue) {
        return data.getNullable(key, defaultValue);
    }

    public static boolean enabled(String key) {
        return data.enabled(key);
    }

    public static boolean enabled(String key, boolean enabledDefault) {
        return data.enabled(key, enabledDefault);
    }

    public static boolean getBool(String key) {
        return data.getBool(key);
    }

    public static boolean getBool(String key, boolean defaultValue) {
        return data.getBool(key, defaultValue);
    }

    public static int getInt(String key) {
        return data.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return data.getInt(key, defaultValue);
    }

    public static long getLong(String key) {
        return data.getLong(key);
    }

    public static long getLong(String key, long defaultValue) {
        return data.getLong(key, defaultValue);
    }

    public static BigDecimal getDecimal(String key) {
        return data.getDecimal(key);
    }

    public static BigDecimal getDecimal(String key, String defaultValue) {
        return data.getDecimal(key, defaultValue);
    }

    public static URI getURI(String key) {
        return data.getURI(key);
    }

    public static URI getURI(String key, String defaultValue) {
        return data.getURI(key, defaultValue);
    }

    public static Duration getDuration(String key) {
        return data.getDuration(key);
    }

    public static Duration getDuration(String key, String defaultValue) {
        return data.getDuration(key, defaultValue);
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, String key) {
        return data.getEnum(type, key);
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, String key, T defaultValue) {
        return data.getEnum(type, key, defaultValue);
    }

    public static <T> T getAs(String key, Function<String, T> mappingFunction) {
        return data.getAs(key, mappingFunction);
    }

    public static <T> Optional<T> getAsOptional(String key, Function<String, T> mappingFunction) {
        return data.getAsOptional(key, mappingFunction);
    }

    public static Configuration.ListValue list() {
        return data.list();
    }

    public static Configuration.SetValue set() {
        return data.set();
    }

    public static ModificationEvent.Builder eventBuilder(String name) {
        return data.eventBuilder(name);
    }

    public static void setProperty(String key, String value) {
        data.setProperty(key, value);
    }

    public static void putAll(Map<String, ?> map) {
        data.putAll(map);
    }

    public static void clearProperty(String key) {
        data.clearProperty(key);
    }

    public static void onChange(Consumer<ModificationEvent> bulkChangeEventListener, String ... keys) {
        data.onChange(bulkChangeEventListener, keys);
    }

    public static void onChange(String key, Consumer<String> singlePropertyChangeListener) {
        data.onChange(key, singlePropertyChangeListener);
    }

    public static void onChangeInt(String key, IntConsumer singlePropertyChangeListener) {
        data.onChangeInt(key, singlePropertyChangeListener);
    }

    public static void onChangeLong(String key, LongConsumer singlePropertyChangeListener) {
        data.onChangeLong(key, singlePropertyChangeListener);
    }

    public static void onChangeBool(String key, Consumer<Boolean> singlePropertyChangeListener) {
        data.onChangeBool(key, singlePropertyChangeListener);
    }
}

