/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.ConfigurationSource;
import io.avaje.config.CoreConfigurationBuilder;
import io.avaje.config.CoreEntry;
import io.avaje.config.CoreEventBuilder;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.CoreListValue;
import io.avaje.config.CoreListener;
import io.avaje.config.CoreModificationEvent;
import io.avaje.config.CoreSetValue;
import io.avaje.config.DefaultConfigurationLog;
import io.avaje.config.FileWatch;
import io.avaje.config.InitialLoader;
import io.avaje.config.ModificationEvent;
import io.avaje.config.ModificationEventRunner;
import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

@NonNullApi
final class CoreConfiguration
implements Configuration {
    private final ConfigurationLog log;
    private final ModifyAwareProperties properties;
    private final ReentrantLock lock = new ReentrantLock();
    private final List<CoreListener> listeners = new CopyOnWriteArrayList<CoreListener>();
    private final Map<String, OnChangeListener> callbacks = new ConcurrentHashMap<String, OnChangeListener>();
    private final CoreListValue listValue;
    private final CoreSetValue setValue;
    private final ModificationEventRunner eventRunner;
    private boolean loadedSystemProperties;
    private FileWatch watcher;
    private Timer timer;
    private final String pathPrefix;

    CoreConfiguration(ModificationEventRunner eventRunner, ConfigurationLog log, CoreEntry.CoreMap entries) {
        this(eventRunner, log, entries, "");
    }

    CoreConfiguration(ModificationEventRunner eventRunner, ConfigurationLog log, CoreEntry.CoreMap entries, String prefix) {
        this.eventRunner = eventRunner;
        this.log = log;
        this.properties = new ModifyAwareProperties(entries);
        this.listValue = new CoreListValue(this);
        this.setValue = new CoreSetValue(this);
        this.pathPrefix = prefix;
    }

    CoreConfiguration(CoreEntry.CoreMap entries) {
        this(new ForegroundEventRunner(), new DefaultConfigurationLog(), entries, "");
    }

    static Configuration initialise() {
        return new CoreConfigurationBuilder().includeResourceLoading().build();
    }

    CoreConfiguration postLoad(@Nullable InitialLoader loader) {
        if (loader != null) {
            this.loadSources(loader.loadedFrom());
            loader.initWatcher(this);
        }
        this.initSystemProperties();
        if (loader != null) {
            this.logMessage(loader);
        }
        this.log.postInitialisation();
        return this;
    }

    ConfigurationLog log() {
        return this.log;
    }

    private void logMessage(InitialLoader loader) {
        String watchMsg = this.watcher == null ? "" : this.watcher.toString();
        String intoMsg = this.loadedSystemProperties ? " into System properties" : "";
        this.log.log(System.Logger.Level.INFO, "Loaded properties from {0}{1} {2}", loader.loadedFrom(), intoMsg, watchMsg);
    }

    void initSystemProperties() {
        if (this.getBool("config.load.systemProperties", false)) {
            this.loadIntoSystemProperties();
        }
    }

    private void loadSources(Set<String> names) {
        for (ConfigurationSource source : ServiceLoader.load(ConfigurationSource.class)) {
            source.load(this);
            names.add("ConfigurationSource:" + source.getClass().getCanonicalName());
        }
    }

    void setWatcher(FileWatch watcher) {
        this.watcher = watcher;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(long delayMillis, long periodMillis, Runnable runnable) {
        CoreConfiguration coreConfiguration = this;
        synchronized (coreConfiguration) {
            if (this.timer == null) {
                this.timer = new Timer("ConfigTimer", true);
            }
            this.timer.schedule((TimerTask)new Task(this.log, runnable), delayMillis, periodMillis);
        }
    }

    String eval(String value) {
        return this.properties.eval(value);
    }

    @Override
    public Properties eval(Properties source) {
        Configuration.ExpressionEval exprEval = InitialLoader.evalFor(source);
        Properties dest = new Properties();
        Enumeration<?> names = source.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            dest.setProperty(name, exprEval.eval(source.getProperty(name)));
        }
        return dest;
    }

    @Override
    public void evalModify(Properties properties) {
        Configuration.ExpressionEval exprEval = InitialLoader.evalFor(properties);
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String origValue = properties.getProperty(name);
            String newValue = exprEval.eval(origValue);
            if (Objects.equals(newValue, origValue)) continue;
            properties.setProperty(name, newValue);
        }
    }

    @Override
    public void loadIntoSystemProperties() {
        this.properties.loadIntoSystemProperties(this.set().of("system.excluded.properties"));
        this.loadedSystemProperties = true;
    }

    @Override
    public Properties asProperties() {
        return this.properties.asProperties();
    }

    @Override
    public Configuration forPath(String pathPrefix) {
        String dotPrefix = pathPrefix + ".";
        int dotLength = dotPrefix.length();
        CoreEntry.CoreMap newEntryMap = CoreEntry.newMap();
        this.properties.entries.forEach((key, entry) -> {
            if (key.startsWith(dotPrefix)) {
                newEntryMap.put(key.substring(dotLength), (CoreEntry)entry);
            } else if (key.equals(pathPrefix)) {
                newEntryMap.put("", (CoreEntry)entry);
            }
        });
        return new CoreConfiguration(this.eventRunner, this.log, newEntryMap, dotPrefix);
    }

    @Override
    public Configuration.ListValue list() {
        return this.listValue;
    }

    @Override
    public Configuration.SetValue set() {
        return this.setValue;
    }

    @Nullable
    String value(String key) {
        return this.properties.entry(key).value();
    }

    private String required(String key) {
        String value = this.value(key);
        if (value == null) {
            throw new IllegalStateException("Missing required configuration parameter [" + this.pathPrefix + key + "]");
        }
        return value;
    }

    @Override
    public String get(String key) {
        return this.required(key);
    }

    @Override
    @Nullable
    public String getNullable(String key) {
        return this.value(key);
    }

    @Override
    public String getNullable(String key, String defaultValue) {
        Objects.requireNonNull(key, "key is required");
        return this.properties.entry(key, defaultValue).value();
    }

    @Override
    public String get(String key, String defaultValue) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(defaultValue, "defaultValue is required, use getOptional() instead");
        return this.properties.entry(key, defaultValue).value();
    }

    @Override
    public Optional<String> getOptional(String key) {
        return Optional.ofNullable(this.value(key));
    }

    @Override
    public Optional<String> getOptional(String key, String defaultValue) {
        return Optional.ofNullable(this.getNullable(key, defaultValue));
    }

    @Override
    public boolean getBool(String key) {
        return Boolean.parseBoolean(this.required(key));
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        return this.properties.getBool(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return Integer.parseInt(this.required(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String val = this.value(key);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    @Override
    public long getLong(String key) {
        return Long.parseLong(this.required(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String val = this.value(key);
        return val == null ? defaultValue : Long.parseLong(val);
    }

    @Override
    public BigDecimal getDecimal(String key) {
        return new BigDecimal(this.get(key));
    }

    @Override
    public BigDecimal getDecimal(String key, String defaultValue) {
        return new BigDecimal(this.get(key, defaultValue));
    }

    @Override
    public URI getURI(String key) {
        return URI.create(this.get(key));
    }

    @Override
    public URI getURI(String key, String defaultValue) {
        return URI.create(this.get(key, defaultValue));
    }

    @Override
    public Duration getDuration(String key) {
        return Duration.parse(this.get(key));
    }

    @Override
    public Duration getDuration(String key, String defaultValue) {
        return Duration.parse(this.get(key, defaultValue));
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> cls, String key) {
        Objects.requireNonNull(cls, "Enum class is required");
        return Enum.valueOf(cls, this.get(key));
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> cls, String key, T defaultValue) {
        Objects.requireNonNull(cls, "Enum class is required");
        return Enum.valueOf(cls, this.get(key, defaultValue.name()));
    }

    @Override
    public <T> T getAs(String key, Function<String, T> mappingFunction) {
        Objects.requireNonNull("key is required");
        Objects.requireNonNull("mappingFunction is required");
        String entry = this.required(key);
        try {
            return mappingFunction.apply(entry);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert key: " + key + " sourced from: " + this.properties.entry(key).source() + " with the provided function", e);
        }
    }

    @Override
    public <T> Optional<T> getAsOptional(String key, Function<String, T> mappingFunction) {
        Objects.requireNonNull("key is required");
        Objects.requireNonNull("mappingFunction is required");
        try {
            return Optional.ofNullable(this.value(key)).map(mappingFunction);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert key: " + key + " sourced from: " + this.properties.entry(key).source() + " with the provided function", e);
        }
    }

    @Override
    public ModificationEvent.Builder eventBuilder(String name) {
        Objects.requireNonNull(name);
        return new CoreEventBuilder(name, this, this.properties.entryMap());
    }

    void publishEvent(CoreEventBuilder eventBuilder) {
        if (eventBuilder.hasChanges()) {
            this.lock.lock();
            try {
                this.eventRunner.run(() -> this.applyChangesAndPublish(eventBuilder));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void applyChangesAndPublish(CoreEventBuilder eventBuilder) {
        Set<String> modifiedKeys = this.properties.applyChanges(eventBuilder);
        if (!modifiedKeys.isEmpty()) {
            CoreModificationEvent event = new CoreModificationEvent(eventBuilder.name(), modifiedKeys, this);
            for (CoreListener coreListener : this.listeners) {
                coreListener.accept(event);
            }
        }
        for (String modifiedKey : modifiedKeys) {
            OnChangeListener onChangeListener = this.callbacks.get(modifiedKey);
            if (onChangeListener == null) continue;
            String value = this.properties.valueOrNull(modifiedKey);
            onChangeListener.fireOnChange(value);
        }
    }

    @Override
    public void onChange(Consumer<ModificationEvent> eventListener, String ... keys) {
        this.listeners.add(new CoreListener(eventListener, keys));
    }

    private OnChangeListener onChange(String key) {
        Objects.requireNonNull(key, "key is required");
        return this.callbacks.computeIfAbsent(key, s -> new OnChangeListener());
    }

    @Override
    public void onChange(String key, Consumer<String> callback) {
        this.onChange(key).register(callback);
    }

    @Override
    public void onChangeInt(String key, IntConsumer callback) {
        this.onChange(key).register(newValue -> callback.accept(Integer.parseInt(newValue)));
    }

    @Override
    public void onChangeLong(String key, LongConsumer callback) {
        this.onChange(key).register(newValue -> callback.accept(Long.parseLong(newValue)));
    }

    @Override
    public void onChangeBool(String key, Consumer<Boolean> callback) {
        this.onChange(key).register(newValue -> callback.accept(Boolean.parseBoolean(newValue)));
    }

    @Override
    public void setProperty(String key, String newValue) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(newValue, "newValue is required, use clearProperty()");
        this.eventBuilder("SetProperty").put(key, newValue).publish();
    }

    @Override
    public void putAll(Map<String, ?> map) {
        Objects.requireNonNull(map, "map cannot be null");
        this.eventBuilder("PutAll").putAll(map).publish();
    }

    @Override
    public void clearProperty(String key) {
        Objects.requireNonNull(key, "key is required");
        this.eventBuilder("ClearProperty").remove(key).publish();
    }

    static String toEnvKey(String key) {
        return key.replace('.', '_').toUpperCase();
    }

    private static class ModifyAwareProperties {
        private final CoreEntry.CoreMap entries;
        private final Configuration.ExpressionEval eval;

        ModifyAwareProperties(CoreEntry.CoreMap entries) {
            this.entries = entries;
            this.eval = new CoreExpressionEval(entries);
        }

        int size() {
            return this.entries.size();
        }

        String eval(String value) {
            return this.eval.eval(value);
        }

        @Nullable
        String valueOrNull(String key) {
            CoreEntry entry = this.entries.get(key);
            return entry == null ? null : entry.value();
        }

        boolean getBool(String key, boolean defaultValue) {
            return this.entry(key, String.valueOf(defaultValue)).boolValue();
        }

        CoreEntry entry(String key) {
            return this._entry(key, null);
        }

        CoreEntry entry(String key, String defaultValue) {
            return this._entry(key, defaultValue);
        }

        private CoreEntry _entry(String key, @Nullable String defaultValue) {
            CoreEntry value = this.entries.get(key);
            if (value == null) {
                value = ModifyAwareProperties.defaultEntry(defaultValue, ModifyAwareProperties.systemValue(key));
                this.entries.put(key, value);
            } else if (value.isNull() && defaultValue != null) {
                value = CoreEntry.of(defaultValue, "DefaultValue");
                this.entries.put(key, value);
            }
            return value;
        }

        private static CoreEntry defaultEntry(@Nullable String defaultValue, @Nullable String systemValue) {
            if (systemValue != null) {
                return CoreEntry.of(systemValue, "SystemProperty");
            }
            if (defaultValue != null) {
                return CoreEntry.of(defaultValue, "DefaultValue");
            }
            return CoreEntry.NULL_ENTRY;
        }

        @Nullable
        private static String systemValue(String key) {
            String val = System.getProperty(key, System.getenv(key));
            return val != null ? val : System.getenv(CoreConfiguration.toEnvKey(key));
        }

        void loadIntoSystemProperties(Set<String> excludedSet) {
            this.entries.forEach((key, entry) -> {
                if (!excludedSet.contains(key) && !entry.isNull()) {
                    System.setProperty(key, entry.value());
                }
            });
        }

        Properties asProperties() {
            Properties props = new Properties();
            this.entries.forEach((key, entry) -> {
                if (!entry.isNull()) {
                    props.setProperty((String)key, entry.value());
                }
            });
            return props;
        }

        CoreEntry.CoreMap entryMap() {
            return this.entries;
        }

        Set<String> applyChanges(CoreEventBuilder eventBuilder) {
            return this.entries.applyChanges(eventBuilder);
        }
    }

    static final class ForegroundEventRunner
    implements ModificationEventRunner {
        ForegroundEventRunner() {
        }

        @Override
        public void run(Runnable eventListenersNotifyTask) {
            eventListenersNotifyTask.run();
        }
    }

    private static class Task
    extends TimerTask {
        private final ConfigurationLog log;
        private final Runnable runnable;

        private Task(ConfigurationLog log, Runnable runnable) {
            this.log = log;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                this.log.log(System.Logger.Level.ERROR, "Error executing timer task", e);
            }
        }
    }

    private static class OnChangeListener {
        private final List<Consumer<String>> callbacks = new ArrayList<Consumer<String>>();

        private OnChangeListener() {
        }

        void register(Consumer<String> callback) {
            this.callbacks.add(callback);
        }

        void fireOnChange(String value) {
            for (Consumer<String> callback : this.callbacks) {
                callback.accept(value);
            }
        }
    }
}

