/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigParser;
import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.ConfigurationPlugin;
import io.avaje.config.ConfigurationSource;
import io.avaje.config.CoreComponents;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.CoreEntry;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.DefaultConfigurationLog;
import io.avaje.config.DefaultResourceLoader;
import io.avaje.config.InitialLoader;
import io.avaje.config.ModificationEventRunner;
import io.avaje.config.Parsers;
import io.avaje.config.ResourceLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

final class CoreConfigurationBuilder
implements Configuration.Builder {
    private final Parsers parsers = new Parsers();
    private final Map<String, String> sourceMap = new LinkedHashMap<String, String>();
    private ResourceLoader resourceLoader = CoreConfigurationBuilder.initialiseResourceLoader();
    private ModificationEventRunner eventRunner;
    private ConfigurationLog configurationLog;
    private boolean includeResourceLoading;
    private InitialLoader initialLoader;

    CoreConfigurationBuilder() {
    }

    @Override
    public Configuration.Builder eventRunner(ModificationEventRunner eventRunner) {
        this.eventRunner = eventRunner;
        return this;
    }

    @Override
    public Configuration.Builder log(ConfigurationLog configurationLog) {
        this.configurationLog = configurationLog;
        return this;
    }

    @Override
    public Configuration.Builder resourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    @Override
    public Configuration.Builder put(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.sourceMap.put(key, value);
        return this;
    }

    @Override
    public Configuration.Builder putAll(Map<String, ?> source) {
        Objects.requireNonNull(source);
        source.forEach((key, value) -> {
            if (key != null && value != null) {
                this.put((String)key, value.toString());
            }
        });
        return this;
    }

    @Override
    public Configuration.Builder putAll(Properties source) {
        Objects.requireNonNull(source);
        source.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && value != null) {
                this.put(key.toString(), value.toString());
            }
        }));
        return this;
    }

    @Override
    public Configuration.Builder load(String resource) {
        CoreConfigurationBuilder coreConfigurationBuilder;
        block8: {
            ConfigParser configParser = this.parser(resource);
            InputStream inputStream = this.resourceLoader.getResourceAsStream(resource);
            try {
                this.putAll(configParser.load(inputStream));
                coreConfigurationBuilder = this;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return coreConfigurationBuilder;
    }

    @Override
    public Configuration.Builder load(File file) {
        CoreConfigurationBuilder coreConfigurationBuilder;
        ConfigParser configParser = this.parser(file.getName());
        FileReader reader = new FileReader(file);
        try {
            this.putAll(configParser.load(reader));
            coreConfigurationBuilder = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return coreConfigurationBuilder;
    }

    private ConfigParser parser(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalArgumentException("Unable to determine the extension for " + name);
        }
        String extension = name.substring(pos + 1);
        ConfigParser configParser = this.parsers.get(extension);
        if (configParser == null) {
            throw new IllegalArgumentException("No parser registered for extension " + extension);
        }
        return configParser;
    }

    @Override
    public Configuration.Builder includeResourceLoading() {
        this.includeResourceLoading = true;
        return this;
    }

    @Override
    public Configuration build() {
        ModificationEventRunner runner = this.initRunner();
        ConfigurationLog log = this.initLog();
        List<ConfigurationSource> sources = ServiceLoader.load(ConfigurationSource.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        List<ConfigurationPlugin> plugins = ServiceLoader.load(ConfigurationPlugin.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        CoreComponents components = new CoreComponents(runner, log, this.parsers, sources, plugins);
        if (this.includeResourceLoading) {
            log.preInitialisation();
            this.initialLoader = new InitialLoader(components, this.resourceLoader);
        }
        return new CoreConfiguration(components, this.initEntries()).postLoad(this.initialLoader);
    }

    private CoreEntry.CoreMap initEntries() {
        CoreEntry.CoreMap entries = this.initEntryMap();
        this.sourceMap.forEach((key, value) -> entries.put((String)key, (String)value, "initial"));
        return CoreExpressionEval.evalFor(entries);
    }

    private CoreEntry.CoreMap initEntryMap() {
        return this.initialLoader == null ? CoreEntry.newMap() : this.initialLoader.load();
    }

    private static ResourceLoader initialiseResourceLoader() {
        return ServiceLoader.load(ResourceLoader.class).findFirst().orElseGet(DefaultResourceLoader::new);
    }

    private ConfigurationLog initLog() {
        if (this.configurationLog == null) {
            this.configurationLog = ServiceLoader.load(ConfigurationLog.class).findFirst().orElseGet(DefaultConfigurationLog::new);
        }
        return this.configurationLog;
    }

    private ModificationEventRunner initRunner() {
        if (this.eventRunner == null) {
            this.eventRunner = ServiceLoader.load(ModificationEventRunner.class).findFirst().orElseGet(CoreConfiguration.ForegroundEventRunner::new);
        }
        return this.eventRunner;
    }
}

