/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigParser;
import io.avaje.config.PropertiesParser;
import io.avaje.config.YamlLoader;
import io.avaje.config.YamlLoaderSimple;
import io.avaje.config.YamlLoaderSnake;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

final class Parsers {
    private final Map<String, ConfigParser> parserMap = new HashMap<String, ConfigParser>();

    Parsers() {
        this.parserMap.put("properties", new PropertiesParser());
        if (!"true".equals(System.getProperty("skipYaml"))) {
            this.initYamlParser();
        }
        if (!"true".equals(System.getProperty("skipCustomParsing"))) {
            this.initParsers();
        }
    }

    private void initYamlParser() {
        YamlLoader yamlLoader;
        try {
            Class.forName("org.yaml.snakeyaml.Yaml");
            yamlLoader = new YamlLoaderSnake();
        }
        catch (ClassNotFoundException e) {
            yamlLoader = new YamlLoaderSimple();
        }
        this.parserMap.put("yml", yamlLoader);
        this.parserMap.put("yaml", yamlLoader);
    }

    private void initParsers() {
        ServiceLoader.load(ConfigParser.class).forEach(p -> {
            for (String ext : p.supportedExtensions()) {
                this.parserMap.put(ext, (ConfigParser)p);
            }
        });
    }

    Set<Map.Entry<String, ConfigParser>> entrySet() {
        return this.parserMap.entrySet();
    }

    ConfigParser get(String extension) {
        return this.parserMap.get(extension.toLowerCase());
    }

    boolean supportsExtension(String extension) {
        return this.parserMap.containsKey(extension.toLowerCase());
    }

    Set<String> supportedExtensions() {
        return this.parserMap.keySet();
    }
}

