/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigExtension;
import io.avaje.config.ConfigParser;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.ConfigurationPlugin;
import io.avaje.config.ConfigurationSource;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.DefaultConfigurationLog;
import io.avaje.config.DefaultResourceLoader;
import io.avaje.config.ModificationEventRunner;
import io.avaje.config.Parsers;
import io.avaje.config.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

final class ConfigServiceLoader {
    private static final ConfigServiceLoader INSTANCE = new ConfigServiceLoader();
    private final ConfigurationLog log;
    private final ResourceLoader resourceLoader;
    private final ModificationEventRunner eventRunner;
    private final List<ConfigurationSource> sources = new ArrayList<ConfigurationSource>();
    private final List<ConfigurationPlugin> plugins = new ArrayList<ConfigurationPlugin>();
    private final Parsers parsers;

    static ConfigServiceLoader get() {
        return INSTANCE;
    }

    ConfigServiceLoader() {
        ModificationEventRunner _eventRunner = null;
        ConfigurationLog _log = null;
        ResourceLoader _resourceLoader = null;
        ArrayList<ConfigParser> otherParsers = new ArrayList<ConfigParser>();
        for (ConfigExtension spi : ServiceLoader.load(ConfigExtension.class)) {
            if (spi instanceof ConfigurationSource) {
                this.sources.add((ConfigurationSource)spi);
                continue;
            }
            if (spi instanceof ConfigurationPlugin) {
                this.plugins.add((ConfigurationPlugin)spi);
                continue;
            }
            if (spi instanceof ConfigParser) {
                otherParsers.add((ConfigParser)spi);
                continue;
            }
            if (spi instanceof ConfigurationLog) {
                _log = (ConfigurationLog)spi;
                continue;
            }
            if (spi instanceof ResourceLoader) {
                _resourceLoader = (ResourceLoader)spi;
                continue;
            }
            if (!(spi instanceof ModificationEventRunner)) continue;
            _eventRunner = (ModificationEventRunner)spi;
        }
        this.log = _log == null ? new DefaultConfigurationLog() : _log;
        this.resourceLoader = _resourceLoader == null ? new DefaultResourceLoader() : _resourceLoader;
        this.eventRunner = _eventRunner == null ? new CoreConfiguration.ForegroundEventRunner() : _eventRunner;
        this.parsers = new Parsers(otherParsers);
    }

    Parsers parsers() {
        return this.parsers;
    }

    ConfigurationLog log() {
        return this.log;
    }

    ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    ModificationEventRunner eventRunner() {
        return this.eventRunner;
    }

    List<ConfigurationSource> sources() {
        return this.sources;
    }

    List<ConfigurationPlugin> plugins() {
        return this.plugins;
    }
}

