/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreEntry;
import io.avaje.config.DockerHost;
import java.util.Properties;

final class CoreExpressionEval
implements Configuration.ExpressionEval {
    private static final String START = "${";
    private static final String END = "}";
    private static final String DOCKER_HOST = "docker.host";
    private CoreEntry.CoreMap sourceMap;
    private Properties sourceProperties;

    CoreExpressionEval(CoreEntry.CoreMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    CoreExpressionEval(Properties sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    static CoreEntry.CoreMap evalFor(CoreEntry.CoreMap map) {
        CoreEntry.CoreMap copy = CoreEntry.newMap(map);
        return new CoreExpressionEval(copy).evalAll();
    }

    private CoreEntry.CoreMap evalAll() {
        this.sourceMap.forEach((key, entry) -> {
            if (entry.needsEvaluation()) {
                this.sourceMap.put((String)key, this.eval(entry.value()), entry.source());
            }
        });
        return this.sourceMap;
    }

    @Override
    public String eval(String val) {
        return val == null ? null : this.evalRecurse(val);
    }

    private String evalRecurse(String input) {
        String resolved = this.evalInput(input);
        if (resolved.contains(START) && !resolved.equals(input)) {
            return this.evalRecurse(resolved);
        }
        return resolved;
    }

    private String evalInput(String input) {
        int start = input.indexOf(START);
        if (start == -1) {
            return input;
        }
        int end = input.indexOf(END, start + 1);
        return end == -1 ? input : this.eval(input, start, end);
    }

    private String evaluateExpression(String exp) {
        String val = System.getProperty(exp);
        if (val == null && (val = System.getenv(exp)) == null) {
            val = this.localLookup(exp);
        }
        return val;
    }

    private String localLookup(String exp) {
        if (this.sourceMap != null) {
            return this.sourceMap.raw(exp);
        }
        if (this.sourceProperties != null) {
            return this.sourceProperties.getProperty(exp);
        }
        return null;
    }

    private String eval(String val, int start, int end) {
        return new EvalBuffer(val, start, end).process();
    }

    private final class EvalBuffer {
        private final StringBuilder buf = new StringBuilder();
        private final String original;
        private int position;
        private int start;
        private int end;
        private String expression;
        private String defaultValue;

        EvalBuffer(String val, int start, int end) {
            this.original = val;
            this.start = start;
            this.end = end;
            this.position = 0;
            this.moveToStart();
        }

        void moveToStart() {
            if (this.start > this.position) {
                this.buf.append(this.original, this.position, this.start);
                this.position = this.start;
            }
        }

        void parseForDefault() {
            int colonPos = this.original.indexOf(58, this.start);
            if (colonPos > this.start && colonPos < this.end) {
                this.expression = this.original.substring(this.start + CoreExpressionEval.START.length(), colonPos);
                this.defaultValue = this.original.substring(colonPos + 1, this.end);
            } else {
                this.expression = this.original.substring(this.start + CoreExpressionEval.START.length(), this.end);
            }
        }

        void evaluate() {
            String eval = CoreExpressionEval.this.evaluateExpression(this.expression);
            if (eval != null) {
                this.buf.append(eval);
            } else if (this.defaultValue != null) {
                this.buf.append(this.defaultValue);
            } else if (CoreExpressionEval.DOCKER_HOST.equals(this.expression)) {
                String dockerHost = DockerHost.host();
                this.buf.append(dockerHost);
                System.setProperty(CoreExpressionEval.DOCKER_HOST, dockerHost);
            } else {
                this.buf.append(CoreExpressionEval.START).append(this.expression).append(CoreExpressionEval.END);
            }
        }

        String end() {
            if (this.end < this.original.length() - 1) {
                this.buf.append(this.original.substring(this.end + 1));
            }
            return this.buf.toString();
        }

        boolean next() {
            int endPos;
            int startPos;
            if (this.end < this.original.length() && (startPos = this.original.indexOf(CoreExpressionEval.START, this.end + 1)) > -1 && (endPos = this.original.indexOf(CoreExpressionEval.END, startPos + 1)) > -1) {
                if (startPos > this.end + 1) {
                    this.buf.append(this.original, this.end + 1, startPos);
                }
                this.start = startPos;
                this.end = endPos;
                return true;
            }
            return false;
        }

        private void evalNext() {
            this.parseForDefault();
            this.evaluate();
        }

        String process() {
            this.evalNext();
            while (this.next()) {
                this.evalNext();
            }
            return this.end();
        }
    }
}

