/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

final class CoreListValue
implements Configuration.ListValue {
    private final CoreConfiguration config;

    public CoreListValue(CoreConfiguration config) {
        this.config = config;
    }

    @Override
    public List<String> of(String key) {
        String val = this.config.value(key);
        return val == null ? Collections.emptyList() : this.split(val);
    }

    @Override
    public List<String> of(String key, String ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? Arrays.asList(defaultValues) : this.split(val);
    }

    @Override
    public List<Integer> ofInt(String key) {
        return this.splitInt(this.config.value(key));
    }

    @Override
    public List<Integer> ofInt(String key, int ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? CoreListValue.intDefaults(defaultValues) : this.splitInt(val);
    }

    private static List<Integer> intDefaults(int[] defaultValues) {
        ArrayList<Integer> ints = new ArrayList<Integer>(defaultValues.length);
        for (int defaultVal : defaultValues) {
            ints.add(defaultVal);
        }
        return ints;
    }

    @Override
    public List<Long> ofLong(String key) {
        return this.splitLong(this.config.value(key));
    }

    @Override
    public List<Long> ofLong(String key, long ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? CoreListValue.longDefaults(defaultValues) : this.splitLong(val);
    }

    private static List<Long> longDefaults(long[] defaultValues) {
        ArrayList<Long> ints = new ArrayList<Long>(defaultValues.length);
        for (long defaultVal : defaultValues) {
            ints.add(defaultVal);
        }
        return ints;
    }

    @Override
    public <T> List<T> ofType(String key, Function<String, T> function) {
        String val = this.config.value(key);
        try {
            return this.splitAs(val, function);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert key: " + key + " with the provided function", e);
        }
    }

    List<String> split(String allValues) {
        return Arrays.asList(allValues.split(","));
    }

    List<Integer> splitInt(String allValues) {
        return this.splitAs(allValues, Integer::parseInt);
    }

    List<Long> splitLong(String allValues) {
        return this.splitAs(allValues, Long::parseLong);
    }

    <T> List<T> splitAs(String allValues, Function<String, T> function) {
        if (allValues == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String value : allValues.split(",")) {
            list.add(function.apply(value));
        }
        return list;
    }
}

