/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigParser;
import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.ModificationEvent;
import io.avaje.config.Parsers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class FileWatch {
    private final ConfigurationLog log;
    private final Configuration configuration;
    private final Parsers parsers;
    private final List<Entry> files;
    private final long delay;
    private final long period;

    FileWatch(CoreConfiguration configuration, List<File> loadedFiles, Parsers parsers) {
        this.log = configuration.log();
        this.configuration = configuration;
        this.delay = configuration.getLong("config.watch.delay", 60L);
        this.period = configuration.getLong("config.watch.period", 10L);
        this.parsers = parsers;
        this.files = this.initFiles(loadedFiles);
        if (this.files.isEmpty()) {
            this.log.log(System.Logger.Level.ERROR, "No files to watch?", new Object[0]);
        } else {
            configuration.schedule(this.delay * 1000L, this.period * 1000L, this::check);
        }
    }

    public String toString() {
        return "Watch[period:" + this.period + " delay:" + this.delay + " files:" + String.valueOf(this.files) + "]";
    }

    private List<Entry> initFiles(List<File> loadedFiles) {
        ArrayList<Entry> entries = new ArrayList<Entry>(loadedFiles.size());
        for (File loadedFile : loadedFiles) {
            entries.add(new Entry(loadedFile));
        }
        return entries;
    }

    boolean changed() {
        for (Entry file : this.files) {
            if (!file.changed()) continue;
            return true;
        }
        return false;
    }

    void check() {
        LinkedHashMap<String, String> keyValues = new LinkedHashMap<String, String>();
        for (Entry file : this.files) {
            if (!file.reload()) continue;
            this.log.log(System.Logger.Level.DEBUG, "reloading configuration from {0}", file);
            if (file.isCustom()) {
                this.reloadYaml(file, keyValues);
                continue;
            }
            this.reloadProps(file, keyValues);
        }
        ModificationEvent.Builder builder = this.configuration.eventBuilder("reload");
        keyValues.forEach(builder::put);
        builder.publish();
    }

    private void reloadProps(Entry file, Map<String, String> keyValues) {
        try (InputStream is = file.inputStream();){
            Properties properties = new Properties();
            properties.load(is);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                keyValues.put(key, properties.getProperty(key));
            }
        }
        catch (Exception e) {
            this.log.log(System.Logger.Level.ERROR, "Unexpected error reloading config file " + String.valueOf(file), e);
        }
    }

    private void reloadYaml(Entry file, Map<String, String> keyValues) {
        ConfigParser parser = this.parsers.get(file.extension);
        if (parser == null) {
            this.log.log(System.Logger.Level.ERROR, "Unexpected - no parser to reload config file " + String.valueOf(file), new Object[0]);
        } else {
            try (InputStream is = file.inputStream();){
                keyValues.putAll(parser.load(is));
            }
            catch (Exception e) {
                this.log.log(System.Logger.Level.ERROR, "Unexpected error reloading config file " + String.valueOf(file), e);
            }
        }
    }

    private static class Entry {
        private final File file;
        private final boolean customExtension;
        private final String extension;
        private long lastMod;
        private long lastLength;

        Entry(File file) {
            this.file = file;
            this.lastMod = file.lastModified();
            this.lastLength = file.length();
            String name = file.getName();
            this.extension = name.substring(name.lastIndexOf(".") + 1);
            this.customExtension = !"properties".equals(this.extension);
        }

        public String toString() {
            return this.file.toString();
        }

        boolean isCustom() {
            return this.customExtension;
        }

        boolean reload() {
            if (!this.changed()) {
                return false;
            }
            this.lastMod = this.file.lastModified();
            this.lastLength = this.file.length();
            return true;
        }

        boolean changed() {
            return this.file.lastModified() > this.lastMod || this.file.length() != this.lastLength;
        }

        InputStream inputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

