/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.YamlLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringJoiner;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class YamlLoaderSimple
implements YamlLoader {
    YamlLoaderSimple() {
    }

    @Override
    public Map<String, String> load(Reader reader) {
        return new Load().load(reader);
    }

    @Override
    public Map<String, String> load(InputStream is) {
        return new Load().load(is);
    }

    private static class Load {
        private final Map<String, String> keyValues = new LinkedHashMap<String, String>();
        private final Stack<Key> keyStack = new Stack();
        private final List<String> multiLines = new ArrayList<String>();
        private State state = State.RequireKey;
        private MultiLineTrim multiLineTrim = MultiLineTrim.Clip;
        private int currentLine;
        private int currentIndent;
        private int multiLineIndent;

        private Load() {
        }

        private Map<String, String> load(InputStream is) {
            return this.load(new InputStreamReader(is));
        }

        private Map<String, String> load(Reader reader) {
            Map<String, String> map;
            LineNumberReader lineReader = new LineNumberReader(reader);
            try {
                String line;
                do {
                    line = lineReader.readLine();
                    this.processLine(line);
                } while (line != null);
                map = this.keyValues;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        lineReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            lineReader.close();
            return map;
        }

        private void processLine(String line) {
            if (line == null) {
                this.checkFinalMultiLine();
            } else {
                ++this.currentLine;
                this.readIndent(line);
                if (this.state == State.MultiLine) {
                    this.processMultiLine(line);
                } else {
                    this.processNext(line);
                }
            }
        }

        private void checkFinalMultiLine() {
            if (this.state == State.MultiLine) {
                this.addKeyVal(this.multiLineValue());
            }
        }

        private void processMultiLine(String line) {
            if (this.multiLineIndent == 0) {
                if (this.currentIndent == 0 && !line.trim().isEmpty()) {
                    this.multiLineEnd(line);
                    return;
                }
                this.multiLineIndent = this.currentIndent;
                this.multiLines.add(line);
            } else if (this.currentIndent >= this.multiLineIndent || line.trim().isEmpty()) {
                this.multiLines.add(line);
            } else {
                this.multiLineEnd(line);
            }
        }

        private void multiLineEnd(String line) {
            this.addKeyVal(this.multiLineValue());
            this.processNext(line);
        }

        private String multiLineValue() {
            if (this.multiLines.isEmpty()) {
                return "";
            }
            if (this.multiLineTrim != MultiLineTrim.Keep) {
                this.multiLineTrimTrailing();
            }
            String join = this.multiLineTrim == MultiLineTrim.Implicit ? " " : "\n";
            StringBuilder sb = new StringBuilder();
            int lastIndex = this.multiLines.size() - 1;
            for (int i = 0; i <= lastIndex; ++i) {
                String line = this.multiLines.get(i);
                if (line.length() < this.multiLineIndent) {
                    sb.append("\n");
                    continue;
                }
                line = line.substring(this.multiLineIndent);
                if (i == lastIndex && (this.multiLineTrim == MultiLineTrim.Strip || this.multiLineTrim == MultiLineTrim.Implicit)) {
                    sb.append(line);
                    continue;
                }
                sb.append(line).append(join);
            }
            this.multiLineEnd();
            return sb.toString();
        }

        private void multiLineTrimTrailing() {
            int i = this.multiLines.size();
            while (i-- > 0 && this.multiLines.get(i).trim().isEmpty()) {
                this.multiLines.remove(i);
            }
        }

        void readIndent(String line) {
            this.currentIndent = this.indent(line);
        }

        private void processNext(String line) {
            if (this.newDocument(line) || this.ignoreLine(line)) {
                return;
            }
            int pos = line.indexOf(58);
            if (pos == -1) {
                this.processNonKey(line);
                return;
            }
            if (this.state == State.RequireTopKey && this.currentIndent > 0) {
                throw new IllegalStateException("Require top level key at line:" + this.currentLine + " [" + line + "]");
            }
            Key key = new Key(this.currentIndent, this.trimKey(line.substring(0, pos)));
            this.popKeys(this.currentIndent);
            this.keyStack.push(key);
            String remaining = line.substring(pos + 1);
            String trimmedValue = remaining.trim();
            if (trimmedValue.startsWith("|")) {
                this.multilineStart(this.multiLineTrimMode(trimmedValue));
            } else if (trimmedValue.isEmpty() || trimmedValue.startsWith("#")) {
                this.state = State.KeyOrValue;
            } else {
                this.addKeyVal(this.trimValue(remaining.trim()));
            }
        }

        private MultiLineTrim multiLineTrimMode(String trimmedValue) {
            if (trimmedValue.length() == 1) {
                return MultiLineTrim.Clip;
            }
            char ch = trimmedValue.charAt(1);
            switch (ch) {
                case '-': {
                    return MultiLineTrim.Strip;
                }
                case '+': {
                    return MultiLineTrim.Keep;
                }
            }
            return MultiLineTrim.Clip;
        }

        private void addKeyVal(String value) {
            this.keyValues.put(this.fullKey(), value);
            this.keyStack.pop();
            this.state = State.RequireKey;
        }

        private void processNonKey(String line) {
            if (this.state == State.RequireKey) {
                this.state = State.RequireTopKey;
                return;
            }
            if (this.keyStack.isEmpty()) {
                throw new IllegalStateException("Reading a value but no key at line: " + this.currentLine + " line[" + line + "]");
            }
            int keyIndent = this.keyStack.peek().indent;
            if (this.currentIndent <= keyIndent) {
                throw new IllegalStateException("Value not indented enough for key " + this.fullKey() + " at line: " + this.currentLine + " line[" + line + "]");
            }
            this.multilineStart(MultiLineTrim.Implicit);
            this.multiLineIndent = this.currentIndent;
            this.multiLines.add(line);
        }

        private void multilineStart(MultiLineTrim trim) {
            this.state = State.MultiLine;
            this.multiLineIndent = 0;
            this.multiLineTrim = trim;
        }

        private void multiLineEnd() {
            this.state = State.RequireKey;
            this.multiLineIndent = 0;
            this.multiLines.clear();
        }

        private boolean newDocument(String line) {
            if (line.startsWith("---")) {
                this.keyStack.clear();
                return true;
            }
            return false;
        }

        private boolean ignoreLine(String line) {
            String trimmed = line.trim();
            return trimmed.isEmpty() || trimmed.startsWith("#");
        }

        private String trimValue(String value) {
            if (value.startsWith("'")) {
                return this.unquoteValue('\'', value);
            }
            if (value.startsWith("\"")) {
                return this.unquoteValue('\"', value);
            }
            int commentPos = value.indexOf(35);
            if (commentPos > -1) {
                return value.substring(0, commentPos).trim();
            }
            return value;
        }

        private String unquoteValue(char quoteChar, String value) {
            int pos = value.lastIndexOf(quoteChar);
            return value.substring(1, pos);
        }

        private String fullKey() {
            StringJoiner fullKey = new StringJoiner(".");
            for (Key next : this.keyStack) {
                fullKey.add(next.key());
            }
            return fullKey.toString();
        }

        private void popKeys(int indent) {
            while (!this.keyStack.isEmpty() && this.keyStack.peek().indent() >= indent) {
                this.keyStack.pop();
            }
        }

        private String trimKey(String indentKey) {
            return this.unquoteKey(indentKey.trim());
        }

        private String unquoteKey(String value) {
            if (value.startsWith("'") && value.endsWith("'")) {
                return value.substring(1, value.length() - 1);
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }

        private int indent(String line) {
            char[] chars = line.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isWhitespace(chars[i])) continue;
                return i;
            }
            return 0;
        }

        static enum State {
            RequireKey,
            MultiLine,
            KeyOrValue,
            RequireTopKey;

        }

        static enum MultiLineTrim {
            Clip,
            Strip,
            Keep,
            Implicit;

        }

        private static class Key {
            private final int indent;
            private final String key;

            Key(int indent, String key) {
                this.indent = indent;
                this.key = key;
            }

            int indent() {
                return this.indent;
            }

            String key() {
                return this.key;
            }
        }
    }
}

