/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.api;

import io.avaje.http.api.InvalidPathArgumentException;
import io.avaje.http.api.InvalidTypeArgumentException;
import io.avaje.http.api.RequiredArgumentException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PathTypeConversion {
    private PathTypeConversion() {
    }

    public static String withDefault(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static List<String> withDefault(List<String> value, List<String> defaultValue) {
        return value != null && !value.isEmpty() ? value : defaultValue;
    }

    public static String checkNull(String value, String property) {
        if (value == null) {
            throw new RequiredArgumentException("Required property " + property + " was not supplied.", property);
        }
        return value;
    }

    private static void checkNull(String value) {
        if (value == null) {
            throw new InvalidPathArgumentException("path element is null");
        }
    }

    public static <T> List<T> list(Function<String, T> func, List<String> params) {
        return params.stream().map(func).collect(Collectors.toList());
    }

    public static <T> Set<T> set(Function<String, T> func, List<String> params) {
        return params.stream().map(func).collect(Collectors.toSet());
    }

    public static int asInt(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static <T> Enum asEnum(Class<T> clazz, String value) {
        PathTypeConversion.checkNull(value);
        try {
            return PathTypeConversion.convertEnum(clazz, value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static <T> Enum convertEnum(Class<T> clazz, String value) {
        try {
            return Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e) {
            String asUpper;
            if (value != null && !(asUpper = value.toUpperCase()).equals(value)) {
                return Enum.valueOf(clazz, asUpper);
            }
            throw e;
        }
    }

    public static long asLong(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static double asDouble(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Double.parseDouble(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static float asFloat(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Float.parseFloat(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static boolean asBoolean(String value) {
        PathTypeConversion.checkNull(value);
        return Boolean.parseBoolean(value);
    }

    public static boolean asBool(String value) {
        return PathTypeConversion.asBoolean(value);
    }

    public static BigInteger asBigInteger(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return new BigInteger(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static BigDecimal asBigDecimal(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return new BigDecimal(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDate asLocalDate(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalDate.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalTime asLocalTime(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Instant asInstant(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Instant.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static OffsetDateTime asOffsetDateTime(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return OffsetDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDateTime asLocalDateTime(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static UUID asUUID(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return UUID.fromString(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Integer asInteger(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static <T> Enum toEnum(Class<T> clazz, String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return PathTypeConversion.convertEnum(clazz, value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Integer toInteger(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Long toLong(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Double toDouble(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Float toFloat(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static BigDecimal toBigDecimal(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static BigInteger toBigInteger(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Boolean toBoolean(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static UUID toUUID(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static LocalDate toLocalDate(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalDate.parse(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static LocalTime toLocalTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalTime.parse(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static Instant toInstant(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static OffsetDateTime toOffsetDateTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return OffsetDateTime.parse(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    public static LocalDateTime toLocalDateTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalDateTime.parse(value);
        }
        catch (Exception e) {
            throw new InvalidTypeArgumentException(e);
        }
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

