/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ValidationException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private final int status;
    private final List<Violation> errors;

    public ValidationException(String message) {
        super(message);
        this.errors = new ArrayList<Violation>();
        this.status = 422;
    }

    public ValidationException(int status, String message) {
        super(message);
        this.status = status;
        this.errors = new ArrayList<Violation>();
    }

    public ValidationException(int status, String message, List<Violation> errors) {
        super(message);
        this.status = status;
        this.errors = errors;
    }

    public ValidationException(int status, String message, Throwable cause, List<Violation> errors) {
        super(message, cause);
        this.status = status;
        this.errors = errors;
    }

    public int getStatus() {
        return this.status;
    }

    public List<Violation> getErrors() {
        return this.errors;
    }

    public static class Violation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String path;
        protected String field;
        protected String message;

        public Violation(String path, String field, String message) {
            this.path = path;
            this.field = field;
            this.message = message;
        }

        public Violation() {
        }

        public String getPath() {
            return this.path;
        }

        public String getField() {
            return this.field;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

