/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.api.context;

import io.avaje.http.api.context.RequestContextResolver;
import io.avaje.http.api.context.ServerContext;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class ThreadLocalRequestContextResolver
implements RequestContextResolver {
    private static final ThreadLocal<ServerContext> REQUEST = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T callWith(ServerContext request, Callable<T> callable) throws Exception {
        this.throwIfSet();
        try {
            REQUEST.set(request);
            T t = callable.call();
            return t;
        }
        finally {
            REQUEST.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T supplyWith(ServerContext request, Supplier<T> supplier) {
        this.throwIfSet();
        try {
            REQUEST.set(request);
            T t = supplier.get();
            return t;
        }
        finally {
            REQUEST.remove();
        }
    }

    @Override
    public void runWith(ServerContext request, Runnable runnable) {
        this.throwIfSet();
        try {
            REQUEST.set(request);
            runnable.run();
        }
        finally {
            REQUEST.remove();
        }
    }

    @Override
    public Optional<ServerContext> currentRequest() {
        return Optional.ofNullable(REQUEST.get());
    }

    private void throwIfSet() {
        if (REQUEST.get() != null) {
            throw new IllegalStateException("Rebinding the ServerContext is not permitted");
        }
    }
}

