/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.hibernate.validator;

import io.avaje.http.api.ValidationException;
import io.avaje.http.api.Validator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Set;

public class BeanValidator
implements Validator {
    private static final ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public void validate(Object bean, String acceptLanguage, Class<?> ... groups) throws ValidationException {
        Set violations = factory.getValidator().validate(bean, (Class[])groups);
        if (!violations.isEmpty()) {
            this.throwExceptionWith(violations);
        }
    }

    private void throwExceptionWith(Set<ConstraintViolation<Object>> violations) {
        ArrayList<ValidationException.Violation> errors = new ArrayList<ValidationException.Violation>();
        for (ConstraintViolation<Object> violation : violations) {
            String path = violation.getPropertyPath().toString();
            String field = this.pathToField(path);
            String message = violation.getMessage();
            errors.add(new ValidationException.Violation(path, field, message));
        }
        ConstraintViolationException cause = new ConstraintViolationException(violations);
        throw new ValidationException(422, "Request failed validation", (Throwable)cause, errors);
    }

    private String pathToField(String path) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return path;
        }
        return path.substring(pos + 1);
    }
}

