/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class APContext {
    private static int jdkVersion;
    private static boolean previewEnabled;
    private static final ThreadLocal<Ctx> CTX;

    private APContext() {
    }

    public static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
        jdkVersion = processingEnv.getSourceVersion().ordinal();
        previewEnabled = jdkVersion >= 13 && APContext.initPreviewEnabled(processingEnv);
    }

    private static boolean initPreviewEnabled(ProcessingEnvironment processingEnv) {
        try {
            return (Boolean)ProcessingEnvironment.class.getDeclaredMethod("isPreviewEnabled", new Class[0]).invoke((Object)processingEnv, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void init(Ctx context, int jdkVersion, boolean preview) {
        CTX.set(context);
        previewEnabled = preview;
    }

    public static void clear() {
        CTX.remove();
    }

    public static int jdkVersion() {
        return jdkVersion;
    }

    public static boolean previewEnabled() {
        return previewEnabled;
    }

    public static void logError(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static void logError(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    public static void logWarn(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    public static void logWarn(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void logNote(Element e, String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    public static void logNote(String msg, Object ... args) {
        APContext.messager().printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    public static Set<? extends Element> elementsAnnotatedWith(RoundEnvironment round, String annotationFQN) {
        return Optional.ofNullable(APContext.typeElement(annotationFQN)).map(round::getElementsAnnotatedWith).orElse(Set.of());
    }

    public static JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return APContext.filer().createSourceFile(name, originatingElements);
    }

    public static TypeElement typeElement(String name) {
        return APContext.elements().getTypeElement(name);
    }

    public static TypeElement asTypeElement(TypeMirror t) {
        return (TypeElement)APContext.types().asElement(t);
    }

    public static ProcessingEnvironment processingEnv() {
        return APContext.CTX.get().processingEnv;
    }

    public static Filer filer() {
        return APContext.CTX.get().filer;
    }

    public static Elements elements() {
        return APContext.CTX.get().elementUtils;
    }

    public static Messager messager() {
        return APContext.CTX.get().messager;
    }

    public static Types types() {
        return APContext.CTX.get().typeUtils;
    }

    public static boolean isAssignable(String type, String superType) {
        return type.equals(superType) || APContext.isAssignable(APContext.typeElement(type), superType);
    }

    public static boolean isAssignable(TypeElement type, String superType) {
        return Optional.ofNullable(type).stream().flatMap(APContext::superTypes).anyMatch(superType::equals);
    }

    private static Stream<String> superTypes(TypeElement element) {
        Types types = APContext.types();
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(APContext.superTypes(e), Stream.of(e))).map(Object::toString);
    }

    public static void setProjectModuleElement(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (APContext.CTX.get().module == null) {
            APContext.CTX.get().module = annotations.stream().map(roundEnv::getElementsAnnotatedWith).filter(Predicate.not(Collection::isEmpty)).findAny().map(s -> (Element)s.iterator().next()).map(APContext.elements()::getModuleOf).orElse(null);
        }
    }

    public static ModuleElement getProjectModuleElement() {
        return APContext.CTX.get().module;
    }

    public static BufferedReader getModuleInfoReader() throws IOException {
        InputStream inputStream = APContext.filer().getResource(StandardLocation.SOURCE_PATH, "", "module-info.java").toUri().toURL().openStream();
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    public static Path getBuildResource(String path) throws IOException {
        String id = UUID.randomUUID().toString();
        String uri = APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", path + id, new Element[0]).toUri().toString().replaceFirst(id, "").replaceFirst("/classes", "").replaceFirst("/classes/java/main", "");
        Path updatedPath = Path.of(URI.create(uri));
        if (path.contains("/")) {
            updatedPath.getParent().toFile().mkdirs();
        }
        return updatedPath;
    }

    static {
        CTX = new ThreadLocal();
    }

    public static final class Ctx {
        private final ProcessingEnvironment processingEnv;
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;
        private ModuleElement module;

        public Ctx(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
            this.messager = processingEnv.getMessager();
            this.filer = processingEnv.getFiler();
            this.elementUtils = processingEnv.getElementUtils();
            this.typeUtils = processingEnv.getTypeUtils();
        }

        public Ctx(Messager messager, Filer filer, Elements elementUtils, Types typeUtils) {
            this.processingEnv = null;
            this.messager = messager;
            this.filer = filer;
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
        }
    }
}

