/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public abstract class BaseControllerWriter {
    protected final ControllerReader reader;
    protected final String originName;
    protected final String shortName;
    protected final String fullName;
    protected final String packageName;
    protected final boolean router;
    protected Append writer;
    protected boolean instrumentContext;

    protected BaseControllerWriter(ControllerReader reader) throws IOException {
        this(reader, "$Route");
    }

    protected BaseControllerWriter(ControllerReader reader, String suffix) throws IOException {
        this.reader = reader;
        this.router = "$Route".equals(suffix);
        TypeElement origin = reader.beanType();
        this.originName = origin.getQualifiedName().toString();
        this.shortName = origin.getSimpleName().toString();
        this.packageName = this.initPackageName(this.originName);
        this.fullName = this.packageName + "." + this.shortName + suffix;
        this.initWriter();
        this.instrumentContext = reader.methods().stream().anyMatch(MethodReader::instrumentContext);
        if (this.instrumentContext) {
            reader.addImportType("io.avaje.http.api.context.RequestContextResolver");
            reader.addImportType("io.avaje.http.api.context.ServerContext");
        }
    }

    protected boolean isRequestScoped() {
        return this.reader.isRequestScoped();
    }

    protected String initPackageName(String originName) {
        int dp = originName.lastIndexOf(46);
        return dp > -1 ? originName.substring(0, dp) : null;
    }

    protected void initWriter() throws IOException {
        this.writer = new Append(this.createFileWriter());
    }

    protected Writer createFileWriter() throws IOException {
        JavaFileObject jfo = ProcessingContext.createWriter(this.fullName, this.reader.beanType());
        return jfo.openWriter();
    }

    protected void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }

    protected void writeImports() {
        if (this.router) {
            this.writer.append("import static io.avaje.http.api.PathTypeConversion.*;").eol();
        }
        for (String type : this.reader.staticImportTypes()) {
            this.writer.append("import static %s;", type).eol();
        }
        this.writer.eol();
        for (String type : this.reader.importTypes()) {
            this.writer.append("import %s;", type).eol();
        }
        this.writer.eol();
    }

    protected void writeClassEnd() {
        this.writer.append("}").eol();
        this.writer.close();
    }
}

