/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.BeanParamPrism;
import io.avaje.http.generator.core.BeanParamReader;
import io.avaje.http.generator.core.BodyStringPrism;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.CookiePrism;
import io.avaje.http.generator.core.DefaultPrism;
import io.avaje.http.generator.core.FormParamPrism;
import io.avaje.http.generator.core.FormPrism;
import io.avaje.http.generator.core.HeaderPrism;
import io.avaje.http.generator.core.HttpValidPrism;
import io.avaje.http.generator.core.IgnorePrism;
import io.avaje.http.generator.core.MatrixParamPrism;
import io.avaje.http.generator.core.NotNullPrism;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.QueryParamPrism;
import io.avaje.http.generator.core.TypeHandler;
import io.avaje.http.generator.core.TypeMap;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.ValidPrism;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import io.avaje.http.generator.core.openapi.MethodParamDocBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class ElementReader {
    private final Element element;
    private final UType type;
    private final String rawType;
    private final String shortType;
    private final TypeHandler typeHandler;
    private final String snakeName;
    private final boolean formMarker;
    private final boolean contextType;
    private final boolean useValidation;
    private final boolean specialParam;
    private boolean overrideVarNameError;
    private String varName;
    private String paramName;
    private ParamType paramType;
    private String matrixParamName;
    private boolean impliedParamType;
    private List<String> paramDefault;
    private boolean notNullKotlin;
    private boolean isParamCollection;
    private boolean isParamMap;
    private final Set<String> imports = new HashSet<String>();
    private final List<String> validationGroups = new ArrayList<String>();

    ElementReader(Element element, ParamType defaultType, boolean formMarker) {
        this(element, null, Util.typeDef(element.asType()), defaultType, formMarker);
    }

    ElementReader(Element element, UType type, String rawType, ParamType defaultType, boolean formMarker) {
        this.element = element;
        this.type = type;
        this.rawType = rawType;
        this.shortType = Util.shortName(rawType);
        this.contextType = ProcessingContext.platform().isContextType(rawType);
        this.specialParam = defaultType == ParamType.FORMPARAM || defaultType == ParamType.QUERYPARAM || defaultType == ParamType.HEADER || defaultType == ParamType.COOKIE;
        this.typeHandler = this.initTypeHandler();
        this.imports.add(rawType);
        if (this.typeHandler != null) {
            this.imports.addAll(this.typeHandler.importTypes());
        }
        this.formMarker = formMarker;
        this.varName = element.getSimpleName().toString();
        this.snakeName = Util.snakeCase(this.varName);
        this.paramName = this.varName;
        if (!this.contextType) {
            this.readAnnotations(element, defaultType);
            this.useValidation = this.useValidation();
            HttpValidPrism.getOptionalOn(element.getEnclosingElement()).map(HttpValidPrism::groups).stream().flatMap(Collection::stream).map(TypeMirror::toString).forEach(this.validationGroups::add);
            this.imports.addAll(this.validationGroups);
        } else {
            this.paramType = ParamType.CONTEXT;
            this.useValidation = false;
        }
        if (ParamType.FORM == this.paramType || ParamType.BEANPARAM == this.paramType) {
            this.beanParamImports(rawType);
        }
    }

    private void beanParamImports(String rawType) {
        ProcessingContext.typeElement(rawType).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(f -> !IgnorePrism.isPresent(f)).map(Element::asType).map(UType::parse).flatMap(u -> u.importTypes().stream()).forEach(this.imports::add);
    }

    TypeHandler initTypeHandler() {
        if (this.specialParam) {
            boolean isMap;
            Optional<UType> typeOp = Optional.ofNullable(this.type).or(() -> Optional.of(UType.parse(this.element.asType())));
            boolean mainTypeEnum = typeOp.flatMap(t -> Optional.ofNullable(ProcessingContext.typeElement(t.mainType()))).map(Element::getKind).filter(ElementKind.ENUM::equals).isPresent();
            boolean isCollection = typeOp.filter(t -> t.isGeneric() && !t.mainType().startsWith("java.util.Map")).isPresent();
            boolean bl = isMap = !isCollection && typeOp.filter(t -> t.mainType().startsWith("java.util.Map")).isPresent();
            if (mainTypeEnum) {
                return TypeMap.enumParamHandler(typeOp.orElseThrow());
            }
            if (isCollection) {
                this.isParamCollection = true;
                boolean isEnumCollection = typeOp.flatMap(t -> Optional.ofNullable(ProcessingContext.typeElement(t.param0()))).map(Element::getKind).filter(ElementKind.ENUM::equals).isPresent();
                return TypeMap.collectionHandler(typeOp.orElseThrow(), isEnumCollection);
            }
            if (isMap) {
                this.isParamMap = true;
                return new TypeMap.StringHandler();
            }
        }
        return TypeMap.get(this.rawType);
    }

    private boolean useValidation() {
        if (this.typeHandler != null) {
            return false;
        }
        TypeElement elementType = ProcessingContext.typeElement(this.rawType);
        return elementType != null && ValidPrism.isPresent(elementType);
    }

    private void readAnnotations(Element element, ParamType defaultType) {
        this.notNullKotlin = NotNullPrism.getInstanceOn(element) != null;
        DefaultPrism defaultVal = DefaultPrism.getInstanceOn(element);
        if (defaultVal != null) {
            this.paramDefault = defaultVal.value();
        }
        if (FormPrism.isPresent(element)) {
            this.paramType = ParamType.FORM;
            return;
        }
        if (BeanParamPrism.isPresent(element)) {
            this.paramType = ParamType.BEANPARAM;
            return;
        }
        QueryParamPrism queryParam = QueryParamPrism.getInstanceOn(element);
        if (queryParam != null) {
            this.paramName = this.nameFrom(queryParam.value(), this.varName);
            this.paramType = ParamType.QUERYPARAM;
            return;
        }
        FormParamPrism formParam = FormParamPrism.getInstanceOn(element);
        if (formParam != null) {
            this.paramName = this.nameFrom(formParam.value(), this.varName);
            this.paramType = ParamType.FORMPARAM;
            return;
        }
        CookiePrism cookieParam = CookiePrism.getInstanceOn(element);
        if (cookieParam != null) {
            this.paramName = this.nameFrom(cookieParam.value(), this.varName);
            this.paramType = ParamType.COOKIE;
            this.paramDefault = null;
            return;
        }
        HeaderPrism headerParam = HeaderPrism.getInstanceOn(element);
        if (headerParam != null) {
            this.paramName = this.nameFrom(headerParam.value(), Util.initcapSnake(this.snakeName));
            this.paramType = ParamType.HEADER;
            this.paramDefault = null;
            return;
        }
        MatrixParamPrism matrixParam = MatrixParamPrism.getInstanceOn(element);
        if (matrixParam != null) {
            this.matrixParamName = this.nameFrom(matrixParam.value(), this.varName);
            this.paramType = defaultType;
            this.impliedParamType = true;
            return;
        }
        if ("java.lang.String".equals(element.asType().toString()) && BodyStringPrism.isPresent(element)) {
            this.paramType = ParamType.BODY;
            return;
        }
        if (this.paramType == null) {
            this.impliedParamType = true;
            this.paramType = this.typeHandler != null ? defaultType : (this.formMarker ? ParamType.FORM : ParamType.BODY);
        }
    }

    public String toString() {
        return this.varName + " type:" + this.rawType + " paramType:" + String.valueOf((Object)this.paramType) + " dft:" + String.valueOf(this.paramDefault);
    }

    private String nameFrom(String name, String defaultName) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return defaultName;
    }

    public String varName() {
        return this.varName;
    }

    public boolean overrideVarNameError() {
        return this.overrideVarNameError;
    }

    public void overrideVarName(String name, ParamType paramType) {
        this.varName = name;
        this.paramType = paramType;
    }

    public void overrideVarName(int position) {
        if (("arg" + position).equals(this.paramName)) {
            this.overrideVarNameError = true;
        } else {
            this.varName = this.paramName;
        }
    }

    private boolean hasParamDefault() {
        return this.paramDefault != null && !this.paramDefault.isEmpty();
    }

    private boolean isPlatformContext() {
        return this.contextType;
    }

    private String platformVariable() {
        return ProcessingContext.platform().platformVariable(this.rawType);
    }

    private String handlerShortType() {
        if (this.typeHandler != null) {
            return this.typeHandler.shortName();
        }
        return this.shortType;
    }

    void addImports(ControllerReader bean) {
        bean.addImportTypes(this.imports);
    }

    void writeParamName(Append writer) {
        if (this.isPlatformContext()) {
            writer.append(this.platformVariable());
        } else {
            writer.append(this.varName);
        }
    }

    void buildApiDocumentation(MethodDocBuilder methodDoc) {
        if (!(this.isPlatformContext() || this.isParamMap || this.paramType == ParamType.BEANPARAM || IgnorePrism.isPresent(this.element))) {
            new MethodParamDocBuilder(methodDoc, this).build();
        }
    }

    void writeValidate(Append writer) {
        if (!this.contextType && this.typeHandler == null) {
            String indent = ProcessingContext.platform().indent();
            if (this.useValidation) {
                writer.append("%s  validator.validate(%s, ", indent, this.varName);
                ProcessingContext.platform().writeAcceptLanguage(writer);
                this.validationGroups.forEach(g -> writer.append(", %s.class", Util.shortName(g)));
                writer.append(");").eol();
            } else {
                writer.append("%s  // no validation required on %s", indent, this.varName).eol();
            }
        }
    }

    void writeCtxGet(Append writer, PathSegments segments) {
        if (this.isPlatformContext() || this.paramType == ParamType.BODY && ProcessingContext.platform().isBodyMethodParam()) {
            return;
        }
        String shortType = this.handlerShortType();
        writer.append("%s  var %s = ", ProcessingContext.platform().indent(), this.varName);
        if (this.setValue(writer, segments, shortType)) {
            writer.append(";").eol();
        }
    }

    void setValue(Append writer) {
        try {
            this.setValue(writer, PathSegments.EMPTY, this.handlerShortType());
        }
        catch (UnsupportedOperationException e) {
            ProcessingContext.logError(this.element, e.getMessage(), new Object[0]);
        }
    }

    private boolean setValue(Append writer, PathSegments segments, String shortType) {
        String asMethod;
        String name;
        PathSegments.Segment segment;
        if (ParamType.FORM == this.paramType) {
            this.writeForm(writer, shortType, this.varName, ParamType.FORMPARAM);
            return false;
        }
        if (ParamType.BEANPARAM == this.paramType) {
            this.writeForm(writer, shortType, this.varName, ParamType.QUERYPARAM);
            return false;
        }
        if (this.impliedParamType && (segment = segments.segment(name = this.matrixParamName != null ? this.matrixParamName : this.varName)) != null) {
            String asMethod2;
            boolean requiredParam = segment.isRequired(this.varName);
            String string = this.typeHandler == null ? null : (asMethod2 = requiredParam ? this.typeHandler.asMethod() : this.typeHandler.toMethod());
            if (asMethod2 != null) {
                writer.append(asMethod2);
            }
            segment.writeGetVal(writer, name, ProcessingContext.platform());
            if (asMethod2 != null) {
                writer.append(")");
            }
            this.paramType = ParamType.PATHPARAM;
            return true;
        }
        String string = asMethod = this.typeHandler == null ? null : this.typeHandler.toMethod();
        if (asMethod != null) {
            writer.append(asMethod);
        }
        if (this.typeHandler == null || this.paramType == ParamType.BODY) {
            writer.append(ProcessingContext.platform().bodyAsClass(this.type));
        } else if (this.isParamCollection && this.specialParam) {
            if (this.hasParamDefault()) {
                ProcessingContext.platform().writeReadCollectionParameter(writer, this.paramType, this.paramName, this.paramDefault);
            } else {
                ProcessingContext.platform().writeReadCollectionParameter(writer, this.paramType, this.paramName);
            }
        } else if (this.isParamMap) {
            ProcessingContext.platform().writeReadMapParameter(writer, this.paramType);
        } else if (this.hasParamDefault()) {
            ProcessingContext.platform().writeReadParameter(writer, this.paramType, this.paramName, this.paramDefault.get(0));
        } else {
            boolean checkNull;
            boolean bl = checkNull = this.notNullKotlin || this.paramType == ParamType.FORMPARAM && this.typeHandler.isPrimitive();
            if (checkNull) {
                writer.append("checkNull(");
            }
            ProcessingContext.platform().writeReadParameter(writer, this.paramType, this.paramName);
            if (checkNull) {
                writer.append(", \"%s\")", this.paramName);
            }
        }
        if (asMethod != null) {
            writer.append(")");
        }
        return true;
    }

    private void writeForm(Append writer, String shortType, String varName, ParamType defaultParamType) {
        TypeElement formBeanType = ProcessingContext.typeElement(this.rawType);
        BeanParamReader form = new BeanParamReader(formBeanType, varName, shortType, defaultParamType);
        form.write(writer);
    }

    public ParamType paramType() {
        return this.paramType;
    }

    public String paramName() {
        return this.paramName;
    }

    public String shortType() {
        return this.shortType;
    }

    public String rawType() {
        return this.rawType;
    }

    public UType type() {
        return this.type;
    }

    public Element element() {
        return this.element;
    }

    public void setResponseHandler() {
        this.paramType = ParamType.RESPONSE_HANDLER;
    }
}

