/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class TagPrism {
    private final String _name;
    private final String _description;
    private final ExternalDocumentationPrism _externalDocs;
    private final List<ExtensionPrism> _extensions;
    public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.tags.Tag";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static boolean isInstance(AnnotationMirror mirror) {
        return TagPrism.getInstance(mirror) != null;
    }

    public static boolean isPresent(Element element) {
        return TagPrism.getInstanceOn(element) != null;
    }

    public static TagPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = TagPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return TagPrism.getInstance(mirror);
    }

    public static Optional<TagPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = TagPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return TagPrism.getOptional(mirror);
    }

    public static List<TagPrism> getAllInstancesOn(Element element) {
        return TagPrism.getMirrors(element).map(TagPrism::getInstance).collect(Collectors.toList());
    }

    public static List<TagPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return TagPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<TagPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new TagPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(TagPrism.getAllOnMetaAnnotations(e, seen), TagPrism.getMirrors(element).map(TagPrism::getInstance)));
    }

    public static TagPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new TagPrism(mirror);
    }

    public static Optional<TagPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new TagPrism(mirror));
    }

    private TagPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._name = this.getValue("name", String.class);
        this._description = this.getValue("description", String.class);
        AnnotationMirror externalDocsMirror = this.getValue("externalDocs", AnnotationMirror.class);
        this.valid = this.valid && externalDocsMirror != null;
        this._externalDocs = externalDocsMirror == null ? null : ExternalDocumentationPrism.getInstance(externalDocsMirror);
        List<AnnotationMirror> list = this.getArrayValues("extensions", AnnotationMirror.class);
        this._extensions = new ArrayList<ExtensionPrism>(list.size());
        for (AnnotationMirror extensionsMirror : list) {
            this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String name() {
        return this._name;
    }

    public String description() {
        return this._description;
    }

    public ExternalDocumentationPrism externalDocs() {
        return this._externalDocs;
    }

    public List<ExtensionPrism> extensions() {
        return this._extensions;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = TagPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = TagPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : TagPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class ExternalDocumentationPrism {
        private final String _description;
        private final String _url;
        private final List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.ExternalDocumentation";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExternalDocumentationPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExternalDocumentationPrism(mirror);
        }

        private static Optional<ExternalDocumentationPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExternalDocumentationPrism(mirror));
        }

        private ExternalDocumentationPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._description = this.getValue("description", String.class);
            this._url = this.getValue("url", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String description() {
            return this._description;
        }

        public String url() {
            return this._url;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = TagPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = TagPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }

            public AnnotationValue url() {
                return this.values.get("url");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }

    public static class ExtensionPrism {
        private final String _name;
        private final List<ExtensionPropertyPrism> _properties;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.Extension";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPrism(mirror);
        }

        private static Optional<ExtensionPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPrism(mirror));
        }

        private ExtensionPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            List<AnnotationMirror> propertiesMirrors = this.getArrayValues("properties", AnnotationMirror.class);
            this._properties = new ArrayList<ExtensionPropertyPrism>(propertiesMirrors.size());
            for (AnnotationMirror propertiesMirror : propertiesMirrors) {
                this._properties.add(ExtensionPropertyPrism.getInstance(propertiesMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public List<ExtensionPropertyPrism> properties() {
            return this._properties;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = TagPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = TagPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue properties() {
                return this.values.get("properties");
            }
        }
    }

    public static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue name() {
            return this.values.get("name");
        }

        public AnnotationValue description() {
            return this.values.get("description");
        }

        public AnnotationValue externalDocs() {
            return this.values.get("externalDocs");
        }

        public AnnotationValue extensions() {
            return this.values.get("extensions");
        }
    }

    public static class ExtensionPropertyPrism {
        private final String _name;
        private final String _value;
        private final Boolean _parseValue;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.ExtensionProperty";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPropertyPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPropertyPrism(mirror);
        }

        private static Optional<ExtensionPropertyPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPropertyPrism(mirror));
        }

        private ExtensionPropertyPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._value = this.getValue("value", String.class);
            this._parseValue = this.getValue("parseValue", Boolean.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String value() {
            return this._value;
        }

        public Boolean parseValue() {
            return this._parseValue;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = TagPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue value() {
                return this.values.get("value");
            }

            public AnnotationValue parseValue() {
                return this.values.get("parseValue");
            }
        }
    }
}

