/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.javadoc;

import io.avaje.http.generator.core.javadoc.JavadocParser;
import java.util.Collections;
import java.util.Map;

public class Javadoc {
    static final Javadoc EMPTY = new Javadoc();
    private final String summary;
    private final String description;
    private final Map<String, String> params;
    private final String returnDescription;
    private final boolean deprecated;

    public static Javadoc parse(String content) {
        return new JavadocParser().parse(content);
    }

    Javadoc(String summary, String description, Map<String, String> params, String returnDescription, boolean deprecated) {
        this.summary = summary;
        this.description = description;
        this.params = params;
        this.returnDescription = returnDescription;
        this.deprecated = deprecated;
    }

    private Javadoc() {
        this.summary = "";
        this.description = "";
        this.returnDescription = "";
        this.params = Collections.emptyMap();
        this.deprecated = false;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isEmpty() {
        return this.summary.isBlank() && this.description.isBlank() && this.params.isEmpty() && this.returnDescription.isBlank() && !this.deprecated;
    }
}

