/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import java.io.IOException;
import java.io.Writer;

final class JsonFormatter {
    private JsonFormatter() {
    }

    public static String prettyPrintJson(Writer writer, String json) throws IOException {
        char[] jsonChars = json.toCharArray();
        int indentLevel = 0;
        boolean inString = false;
        block5: for (int i = 0; i < jsonChars.length; ++i) {
            char current = jsonChars[i];
            if (current == '\"' && jsonChars[i - 1] != '\\') {
                inString = !inString;
                writer.append(current);
                continue;
            }
            if (inString) {
                writer.append(current);
                continue;
            }
            switch (current) {
                case '[': 
                case '{': {
                    writer.append(current).append("\n");
                    JsonFormatter.addIndents(writer, ++indentLevel);
                    continue block5;
                }
                case ']': 
                case '}': {
                    writer.append("\n");
                    JsonFormatter.addIndents(writer, --indentLevel);
                    writer.append(current);
                    continue block5;
                }
                case ',': {
                    writer.append(current).append("\n");
                    JsonFormatter.addIndents(writer, indentLevel);
                    continue block5;
                }
                default: {
                    writer.append(current);
                }
            }
        }
        return writer.toString();
    }

    private static void addIndents(Writer writer, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.append("\t");
        }
    }
}

