/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.ConsumesPrism;
import io.avaje.http.generator.core.CoreWebMethod;
import io.avaje.http.generator.core.HiddenPrism;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.OpenAPIResponsePrism;
import io.avaje.http.generator.core.SecurityRequirementPrism;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.DeprecatedPrism;
import io.avaje.http.generator.core.openapi.DocContext;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public class MethodDocBuilder {
    private final Javadoc javadoc;
    private final MethodReader methodReader;
    private final DocContext ctx;
    private final Operation operation = new Operation();
    private final Optional<ConsumesPrism> consumeOp;

    public MethodDocBuilder(MethodReader methodReader, DocContext ctx) {
        this.methodReader = methodReader;
        this.ctx = ctx;
        this.javadoc = methodReader.javadoc();
        this.consumeOp = methodReader.consumesAnnotation();
    }

    public void build() {
        String contentMediaType;
        if (this.ctx.isOpenApiAvailable() && this.methodReader.findAnnotation(HiddenPrism::getOptionalOn).isPresent()) {
            return;
        }
        this.operation.setSummary(this.javadoc.getSummary());
        this.operation.setDescription(this.javadoc.getDescription());
        this.operation.setTags(this.methodReader.tags());
        if (this.javadoc.isDeprecated() || this.methodReader.findAnnotation(DeprecatedPrism::getOptionalOn).isPresent()) {
            this.operation.setDeprecated(true);
        }
        PathItem pathItem = this.ctx.pathItem(this.methodReader.fullPath());
        switch ((CoreWebMethod)this.methodReader.webMethod()) {
            case GET: {
                pathItem.setGet(this.operation);
                break;
            }
            case PUT: {
                pathItem.setPut(this.operation);
                break;
            }
            case POST: {
                pathItem.setPost(this.operation);
                break;
            }
            case DELETE: {
                pathItem.setDelete(this.operation);
                break;
            }
            case PATCH: {
                pathItem.setPatch(this.operation);
            }
        }
        List<SecurityRequirementPrism> securityRequirements = this.methodReader.securityRequirements();
        for (SecurityRequirementPrism p : securityRequirements) {
            SecurityRequirement o = new SecurityRequirement().addList(p.name(), p.scopes());
            this.operation.addSecurityItem(o);
        }
        for (MethodParam param : this.methodReader.params()) {
            param.buildApiDocumentation(this);
        }
        ApiResponses responses = new ApiResponses();
        this.operation.setResponses(responses);
        ApiResponse response = new ApiResponse();
        response.setDescription(this.javadoc.getReturnDescription());
        String produces = this.methodReader.produces();
        boolean hasProducesStatus = this.methodReader.hasProducesStatus();
        String string = contentMediaType = produces == null ? "application/json" : produces;
        if (this.methodReader.isVoid()) {
            if (this.isEmpty(response.getDescription())) {
                response.setDescription("No content");
            }
        } else {
            response.setContent(this.ctx.createContent(this.methodReader.returnType(), contentMediaType));
        }
        boolean override2xx = false;
        for (OpenAPIResponsePrism responseAnnotation : this.methodReader.apiResponses()) {
            TypeMirror returnType;
            ApiResponse newResponse = new ApiResponse();
            if (responseAnnotation.description().isEmpty()) {
                newResponse.setDescription(response.getDescription());
            } else {
                newResponse.setDescription(responseAnnotation.description());
            }
            if (responseAnnotation.responseCode().toString().startsWith("2")) {
                newResponse.setContent(response.getContent());
                boolean bl = override2xx = !hasProducesStatus;
            }
            if (!"java.lang.Void".equals((returnType = responseAnnotation.type()).toString())) {
                newResponse.setContent(this.ctx.createContent(returnType, contentMediaType));
            }
            responses.addApiResponse(responseAnnotation.responseCode().toString(), newResponse);
        }
        if (!override2xx) {
            responses.addApiResponse(String.valueOf(this.methodReader.statusCode()), response);
        }
    }

    DocContext getContext() {
        return this.ctx;
    }

    Javadoc getJavadoc() {
        return this.javadoc;
    }

    Operation getOperation() {
        return this.operation;
    }

    public Optional<ConsumesPrism> consumeOp() {
        return this.consumeOp;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

