/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.javalin;

import io.avaje.http.generator.core.BaseControllerWriter;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.JsonBUtil;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.PrimitiveUtil;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.javalin.ControllerMethodWriter;
import java.io.IOException;
import java.util.Map;

class ControllerWriter
extends BaseControllerWriter {
    private static final String AT_GENERATED = "@Generated(\"avaje-javalin-generator\")";
    private final boolean useJsonB;
    private final Map<String, UType> jsonTypes;
    private final boolean javalin6 = ProcessingContext.javalin6();

    ControllerWriter(ControllerReader reader, boolean jsonb) throws IOException {
        super(reader);
        this.useJsonB = jsonb;
        if (this.useJsonB) {
            reader.addImportType("io.avaje.jsonb.Jsonb");
            reader.addImportType("io.avaje.jsonb.JsonType");
            reader.addImportType("io.avaje.jsonb.Types");
            this.jsonTypes = JsonBUtil.jsonTypes(reader);
            this.jsonTypes.values().stream().map(UType::importTypes).forEach(reader::addImportTypes);
        } else {
            this.jsonTypes = Map.of();
        }
        reader.addImportType("io.javalin.plugin.Plugin");
        if (this.javalin6) {
            reader.addImportType("io.javalin.config.JavalinConfig");
            reader.addImportType("io.javalin.router.JavalinDefaultRouting");
            reader.addImportType("io.avaje.http.api.AvajeJavalinPlugin");
        } else {
            reader.addImportType("io.javalin.Javalin");
        }
    }

    void write() {
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeAddRoutes();
        this.writeClassEnd();
    }

    private void writeAddRoutes() {
        this.writer.append("  @Override").eol();
        if (this.javalin6) {
            this.writer.append("  public void onStart(JavalinConfig cfg) {").eol();
            this.writer.append("    cfg.router.mount(this::routes);").eol();
            this.writer.append("  }").eol().eol();
            this.writer.append("  private void routes(JavalinDefaultRouting app) {").eol().eol();
        } else {
            this.writer.append("  public void apply(Javalin app) {").eol().eol();
        }
        for (MethodReader method : this.reader.methods()) {
            if (!method.isWebMethod()) continue;
            this.writeForMethod(method);
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeForMethod(MethodReader method) {
        new ControllerMethodWriter(method, this.writer, this.useJsonB).write(this.isRequestScoped());
        if (!this.reader.isDocHidden()) {
            method.buildApiDocumentation();
        }
    }

    private void writeClassStart() {
        this.writer.append(AT_GENERATED).eol();
        this.writer.append(ProcessingContext.diAnnotation()).eol();
        this.writer.append("public class ").append(this.shortName).append(this.javalin6 ? "$Route extends AvajeJavalinPlugin {" : "$Route implements Plugin {").eol().eol();
        String controllerName = "controller";
        Object controllerType = this.shortName;
        if (this.isRequestScoped()) {
            controllerName = "factory";
            controllerType = (String)controllerType + "$Factory";
        }
        this.writer.append("  private final %s %s;", controllerType, controllerName).eol();
        if (this.reader.isIncludeValidator()) {
            this.writer.append("  private final Validator validator;").eol();
        }
        if (this.instrumentContext) {
            this.writer.append("  private final RequestContextResolver resolver;").eol();
        }
        for (UType type : this.jsonTypes.values()) {
            String typeString = PrimitiveUtil.wrap(type.shortType()).replace(",", ", ");
            this.writer.append("  private final JsonType<%s> %sJsonType;", typeString, type.shortName()).eol();
        }
        this.writer.eol();
        this.writer.append("  public %s$Route(%s %s", this.shortName, controllerType, controllerName);
        if (this.reader.isIncludeValidator()) {
            this.writer.append(", Validator validator");
        }
        if (this.useJsonB) {
            this.writer.append(", Jsonb jsonb");
        }
        if (this.instrumentContext) {
            this.writer.append(", RequestContextResolver resolver");
        }
        this.writer.append(") {").eol();
        this.writer.append("    this.%s = %s;", controllerName, controllerName).eol();
        if (this.reader.isIncludeValidator()) {
            this.writer.append("    this.validator = validator;").eol();
        }
        if (this.instrumentContext) {
            this.writer.append("    this.resolver = resolver;").eol();
        }
        if (this.useJsonB) {
            for (UType type : this.jsonTypes.values()) {
                JsonBUtil.writeJsonbType(type, this.writer);
            }
        }
        this.writer.append("  }").eol().eol();
    }
}

