/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.javalin;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.CustomWebMethod;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.javalin.AfterMatchedPrism;
import io.avaje.http.generator.javalin.AfterPrism;
import io.avaje.http.generator.javalin.BeforeMatchedPrism;
import io.avaje.http.generator.javalin.BeforePrism;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Element;

class JavalinAdapter
implements PlatformAdapter {
    static final String JAVALIN3_CONTEXT = "io.javalin.http.Context";

    JavalinAdapter() {
    }

    @Override
    public boolean isContextType(String rawType) {
        return JAVALIN3_CONTEXT.equals(rawType);
    }

    @Override
    public String platformVariable(String rawType) {
        return "ctx";
    }

    @Override
    public boolean isBodyMethodParam() {
        return false;
    }

    @Override
    public String bodyAsClass(UType type) {
        if ("java.io.InputStream".equals(type.full())) {
            return "ctx.bodyInputStream()";
        }
        if ("java.lang.String".equals(type.full())) {
            return "ctx.body()";
        }
        if ("byte[]".equals(type.full())) {
            return "ctx.bodyAsBytes()";
        }
        if (ProcessingContext.useJsonb()) {
            return type.shortName() + "JsonType.fromJson(ctx.bodyInputStream())";
        }
        return "ctx.<" + type.mainType() + ">bodyStreamAsClass(" + type.mainType() + ".class)";
    }

    @Override
    public String indent() {
        return "    ";
    }

    @Override
    public void controllerRoles(List<String> roles, ControllerReader controller) {
        this.addRoleImports(roles, controller);
    }

    @Override
    public void methodRoles(List<String> roles, ControllerReader controller) {
        this.addRoleImports(roles, controller);
    }

    private void addRoleImports(List<String> roles, ControllerReader controller) {
        for (String role : roles) {
            controller.addStaticImportType(role);
        }
    }

    @Override
    public void writeReadParameter(Append writer, ParamType paramType, String paramName) {
        writer.append("ctx.%s(\"%s\")", new Object[]{paramType, paramName});
    }

    @Override
    public void writeReadParameter(Append writer, ParamType paramType, String paramName, String paramDefault) {
        writer.append("withDefault(ctx.%s(\"%s\"), \"%s\")", new Object[]{paramType, paramName, paramDefault});
    }

    @Override
    public void writeReadMapParameter(Append writer, ParamType paramType) {
        switch (paramType) {
            case QUERYPARAM: {
                writer.append("ctx.queryParamMap()");
                break;
            }
            case FORM: 
            case FORMPARAM: {
                writer.append("ctx.formParamMap()");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only Query/Form Params have Map<String, List<String>> supported in Javalin");
            }
        }
    }

    @Override
    public void writeReadCollectionParameter(Append writer, ParamType paramType, String paramName) {
        switch (paramType) {
            case QUERYPARAM: {
                writer.append("ctx.queryParams(\"%s\")", paramName);
                break;
            }
            case FORMPARAM: {
                writer.append("ctx.formParams(\"%s\")", paramName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only MultiValue Form/Query Params are supported in Javalin");
            }
        }
    }

    @Override
    public void writeReadCollectionParameter(Append writer, ParamType paramType, String paramName, List<String> paramDefault) {
        switch (paramType) {
            case QUERYPARAM: {
                writer.append("withDefault(ctx.queryParams(\"%s\"), java.util.List.of(\"%s\"))", paramName, String.join((CharSequence)",", paramDefault));
                break;
            }
            case FORMPARAM: {
                writer.append("withDefault(ctx.formParams(\"%s\"), java.util.List.of(\"%s\"))", paramName, String.join((CharSequence)",", paramDefault));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only MultiValue Form/Query Params are supported in Javalin");
            }
        }
    }

    @Override
    public void writeAcceptLanguage(Append writer) {
        writer.append("ctx.header(\"%s\")", "Accept-Language");
    }

    @Override
    public List<Function<Element, Optional<CustomWebMethod>>> customHandlers() {
        Function<Element, AfterPrism> after = AfterPrism::getInstanceOn;
        Function<Element, BeforePrism> before = BeforePrism::getInstanceOn;
        Function<Element, AfterMatchedPrism> afterMatched = AfterMatchedPrism::getInstanceOn;
        Function<Element, BeforeMatchedPrism> beforeMatched = BeforeMatchedPrism::getInstanceOn;
        return List.of(after.andThen(Optional::ofNullable), before.andThen(Optional::ofNullable), afterMatched.andThen(Optional::ofNullable), beforeMatched.andThen(Optional::ofNullable));
    }
}

