/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.io.IOException;
import java.io.Writer;

public class Append {
    private static final boolean DEBUG = Boolean.getBoolean("append.debug");
    private final Writer writer;
    private final StringBuilder stringBuilder = new StringBuilder();

    public Append(Writer writer) {
        this.writer = writer;
    }

    public Append append(String content) {
        try {
            this.writer.append(content);
            if (DEBUG) {
                this.stringBuilder.append(content);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Append eol() {
        try {
            this.writer.append("\n");
            if (DEBUG) {
                this.stringBuilder.append("\n");
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Append append(String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

