/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.APContext;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.PathPrism;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

@SupportedOptions(value={"useJavax", "useSingleton", "instrumentRequests", "disableDirectWrites"})
public abstract class BaseProcessor
extends AbstractProcessor {
    protected String contextPathString;
    protected Map<String, String> packagePaths = new HashMap<String, String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("io.avaje.http.api.Path", "io.avaje.http.api.Controller", "io.swagger.v3.oas.annotations.OpenAPIDefinition");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        APContext.init(processingEnv);
        ProcessingContext.init(processingEnv, this.providePlatformAdapter());
    }

    protected abstract PlatformAdapter providePlatformAdapter();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        Set<? extends Element> pathElements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Path"));
        APContext.setProjectModuleElement(annotations, round);
        if (this.contextPathString == null) {
            this.contextPathString = ElementFilter.modulesIn(pathElements).stream().map(PathPrism::getInstanceOn).map(PathPrism::value).findFirst().orElse("");
        }
        this.packagePaths.putAll(ElementFilter.packagesIn(pathElements).stream().collect(Collectors.toMap(p -> p.getQualifiedName().toString(), p -> PathPrism.getInstanceOn(p).value())));
        if (ProcessingContext.isOpenApiAvailable()) {
            this.readOpenApiDefinition(round);
            this.readTagDefinitions(round);
            this.readSecuritySchemes(round);
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Controller"))) {
            this.writeAdapter(element);
        }
        if (round.processingOver()) {
            this.writeOpenAPI();
            ProcessingContext.validateModule();
        }
        return false;
    }

    private void readOpenApiDefinition(RoundEnvironment round) {
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.OpenAPIDefinition"))) {
            ProcessingContext.doc().readApiDefinition(element);
        }
    }

    private void readTagDefinitions(RoundEnvironment round) {
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.tags.Tag"))) {
            ProcessingContext.doc().addTagDefinition(element);
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.tags.Tags"))) {
            ProcessingContext.doc().addTagsDefinition(element);
        }
    }

    private void readSecuritySchemes(RoundEnvironment round) {
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.security.SecurityScheme"))) {
            ProcessingContext.doc().addSecurityScheme(element);
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.security.SecuritySchemes"))) {
            ProcessingContext.doc().addSecuritySchemes(element);
        }
    }

    private void writeOpenAPI() {
        ProcessingContext.doc().writeApi();
    }

    private void writeAdapter(Element controller) {
        if (controller instanceof TypeElement) {
            String packageFQN = ProcessingContext.elements().getPackageOf(controller).getQualifiedName().toString();
            String contextPath = Util.combinePath(this.contextPathString, this.packagePath(packageFQN));
            ControllerReader reader = new ControllerReader((TypeElement)controller, contextPath);
            reader.read(true);
            try {
                this.writeControllerAdapter(reader);
            }
            catch (Throwable e) {
                ProcessingContext.logError(reader.beanType(), "Failed to write $Route class " + String.valueOf(e), new Object[0]);
            }
        }
    }

    private String packagePath(String packageFQN) {
        return this.packagePaths.entrySet().stream().filter(k -> packageFQN.startsWith((String)k.getKey())).map(Map.Entry::getValue).reduce(Util::combinePath).orElse(null);
    }

    public abstract void writeControllerAdapter(ControllerReader var1) throws IOException;
}

