/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public final class CookiePrism {
    private final String _value;
    public static final String PRISM_TYPE = "io.avaje.http.api.Cookie";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static boolean isInstance(AnnotationMirror mirror) {
        return CookiePrism.getInstance(mirror) != null;
    }

    public static boolean isPresent(Element element) {
        return CookiePrism.getInstanceOn(element) != null;
    }

    public static CookiePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = CookiePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return CookiePrism.getInstance(mirror);
    }

    public static Optional<CookiePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = CookiePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return CookiePrism.getOptional(mirror);
    }

    public static CookiePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new CookiePrism(mirror);
    }

    public static Optional<CookiePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new CookiePrism(mirror));
    }

    private CookiePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getValue("value", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String value() {
        return this._value;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = CookiePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    public static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

