/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.SecurityRequirementPrism;
import io.avaje.http.generator.core.TagPrism;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class OpenAPIDefinitionPrism {
    private final InfoPrism _info;
    private final List<TagPrism> _tags;
    private final List<ServerPrism> _servers;
    private final List<SecurityRequirementPrism> _security;
    private final ExternalDocumentationPrism _externalDocs;
    private final List<ExtensionPrism> _extensions;
    public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.OpenAPIDefinition";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static boolean isInstance(AnnotationMirror mirror) {
        return OpenAPIDefinitionPrism.getInstance(mirror) != null;
    }

    public static boolean isPresent(Element element) {
        return OpenAPIDefinitionPrism.getInstanceOn(element) != null;
    }

    public static OpenAPIDefinitionPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = OpenAPIDefinitionPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return OpenAPIDefinitionPrism.getInstance(mirror);
    }

    public static Optional<OpenAPIDefinitionPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = OpenAPIDefinitionPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return OpenAPIDefinitionPrism.getOptional(mirror);
    }

    public static List<OpenAPIDefinitionPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return OpenAPIDefinitionPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<OpenAPIDefinitionPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new OpenAPIDefinitionPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(OpenAPIDefinitionPrism.getAllOnMetaAnnotations(e, seen), OpenAPIDefinitionPrism.getMirrors(element).map(OpenAPIDefinitionPrism::getInstance)));
    }

    public static OpenAPIDefinitionPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new OpenAPIDefinitionPrism(mirror);
    }

    public static Optional<OpenAPIDefinitionPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new OpenAPIDefinitionPrism(mirror));
    }

    private OpenAPIDefinitionPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        AnnotationMirror infoMirror = this.getValue("info", AnnotationMirror.class);
        this.valid = this.valid && infoMirror != null;
        this._info = infoMirror == null ? null : InfoPrism.getInstance(infoMirror);
        List<AnnotationMirror> list = this.getArrayValues("tags", AnnotationMirror.class);
        this._tags = new ArrayList<TagPrism>(list.size());
        for (AnnotationMirror annotationMirror : list) {
            this._tags.add(TagPrism.getInstance(annotationMirror));
        }
        List<AnnotationMirror> serversMirrors = this.getArrayValues("servers", AnnotationMirror.class);
        this._servers = new ArrayList<ServerPrism>(serversMirrors.size());
        for (AnnotationMirror annotationMirror : serversMirrors) {
            this._servers.add(ServerPrism.getInstance(annotationMirror));
        }
        List<AnnotationMirror> list2 = this.getArrayValues("security", AnnotationMirror.class);
        this._security = new ArrayList<SecurityRequirementPrism>(list2.size());
        for (AnnotationMirror securityMirror : list2) {
            this._security.add(SecurityRequirementPrism.getInstance(securityMirror));
        }
        AnnotationMirror annotationMirror = this.getValue("externalDocs", AnnotationMirror.class);
        this.valid = this.valid && annotationMirror != null;
        this._externalDocs = annotationMirror == null ? null : ExternalDocumentationPrism.getInstance(annotationMirror);
        List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
        this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
        for (AnnotationMirror extensionsMirror : extensionsMirrors) {
            this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public InfoPrism info() {
        return this._info;
    }

    public List<TagPrism> tags() {
        return this._tags;
    }

    public List<ServerPrism> servers() {
        return this._servers;
    }

    public List<SecurityRequirementPrism> security() {
        return this._security;
    }

    public ExternalDocumentationPrism externalDocs() {
        return this._externalDocs;
    }

    public List<ExtensionPrism> extensions() {
        return this._extensions;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : OpenAPIDefinitionPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class InfoPrism {
        private final String _title;
        private final String _description;
        private final String _termsOfService;
        private final ContactPrism _contact;
        private final LicensePrism _license;
        private final String _version;
        private final List<ExtensionPrism> _extensions;
        private final String _summary;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.info.Info";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static InfoPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new InfoPrism(mirror);
        }

        private static Optional<InfoPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new InfoPrism(mirror));
        }

        private InfoPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._title = this.getValue("title", String.class);
            this._description = this.getValue("description", String.class);
            this._termsOfService = this.getValue("termsOfService", String.class);
            AnnotationMirror contactMirror = this.getValue("contact", AnnotationMirror.class);
            this.valid = this.valid && contactMirror != null;
            this._contact = contactMirror == null ? null : ContactPrism.getInstance(contactMirror);
            AnnotationMirror annotationMirror = this.getValue("license", AnnotationMirror.class);
            this.valid = this.valid && annotationMirror != null;
            this._license = annotationMirror == null ? null : LicensePrism.getInstance(annotationMirror);
            this._version = this.getValue("version", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this._summary = this.getValue("summary", String.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String title() {
            return this._title;
        }

        public String description() {
            return this._description;
        }

        public String termsOfService() {
            return this._termsOfService;
        }

        public ContactPrism contact() {
            return this._contact;
        }

        public LicensePrism license() {
            return this._license;
        }

        public String version() {
            return this._version;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        public String summary() {
            return this._summary;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue title() {
                return this.values.get("title");
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }

            public AnnotationValue termsOfService() {
                return this.values.get("termsOfService");
            }

            public AnnotationValue contact() {
                return this.values.get("contact");
            }

            public AnnotationValue license() {
                return this.values.get("license");
            }

            public AnnotationValue version() {
                return this.values.get("version");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }

            public AnnotationValue summary() {
                return this.values.get("summary");
            }
        }
    }

    public static class ServerPrism {
        private final String _url;
        private final String _description;
        private final List<ServerVariablePrism> _variables;
        private final List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.servers.Server";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ServerPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ServerPrism(mirror);
        }

        private static Optional<ServerPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ServerPrism(mirror));
        }

        private ServerPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._url = this.getValue("url", String.class);
            this._description = this.getValue("description", String.class);
            List<AnnotationMirror> variablesMirrors = this.getArrayValues("variables", AnnotationMirror.class);
            this._variables = new ArrayList<ServerVariablePrism>(variablesMirrors.size());
            for (AnnotationMirror variablesMirror : variablesMirrors) {
                this._variables.add(ServerVariablePrism.getInstance(variablesMirror));
            }
            List<AnnotationMirror> list = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(list.size());
            for (AnnotationMirror extensionsMirror : list) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String url() {
            return this._url;
        }

        public String description() {
            return this._description;
        }

        public List<ServerVariablePrism> variables() {
            return this._variables;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue url() {
                return this.values.get("url");
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }

            public AnnotationValue variables() {
                return this.values.get("variables");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }

    public static class ExternalDocumentationPrism {
        private final String _description;
        private final String _url;
        private final List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.ExternalDocumentation";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExternalDocumentationPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExternalDocumentationPrism(mirror);
        }

        private static Optional<ExternalDocumentationPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExternalDocumentationPrism(mirror));
        }

        private ExternalDocumentationPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._description = this.getValue("description", String.class);
            this._url = this.getValue("url", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String description() {
            return this._description;
        }

        public String url() {
            return this._url;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }

            public AnnotationValue url() {
                return this.values.get("url");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }

    public static class ExtensionPrism {
        private final String _name;
        private final List<ExtensionPropertyPrism> _properties;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.Extension";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPrism(mirror);
        }

        private static Optional<ExtensionPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPrism(mirror));
        }

        private ExtensionPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            List<AnnotationMirror> propertiesMirrors = this.getArrayValues("properties", AnnotationMirror.class);
            this._properties = new ArrayList<ExtensionPropertyPrism>(propertiesMirrors.size());
            for (AnnotationMirror propertiesMirror : propertiesMirrors) {
                this._properties.add(ExtensionPropertyPrism.getInstance(propertiesMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public List<ExtensionPropertyPrism> properties() {
            return this._properties;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue properties() {
                return this.values.get("properties");
            }
        }
    }

    public static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue info() {
            return this.values.get("info");
        }

        public AnnotationValue tags() {
            return this.values.get("tags");
        }

        public AnnotationValue servers() {
            return this.values.get("servers");
        }

        public AnnotationValue security() {
            return this.values.get("security");
        }

        public AnnotationValue externalDocs() {
            return this.values.get("externalDocs");
        }

        public AnnotationValue extensions() {
            return this.values.get("extensions");
        }
    }

    public static class ExtensionPropertyPrism {
        private final String _name;
        private final String _value;
        private final Boolean _parseValue;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.ExtensionProperty";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPropertyPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPropertyPrism(mirror);
        }

        private static Optional<ExtensionPropertyPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPropertyPrism(mirror));
        }

        private ExtensionPropertyPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._value = this.getValue("value", String.class);
            this._parseValue = this.getValue("parseValue", Boolean.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String value() {
            return this._value;
        }

        public Boolean parseValue() {
            return this._parseValue;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue value() {
                return this.values.get("value");
            }

            public AnnotationValue parseValue() {
                return this.values.get("parseValue");
            }
        }
    }

    public static class ServerVariablePrism {
        private final String _name;
        private final List<String> _allowableValues;
        private final String _defaultValue;
        private final String _description;
        private final List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.servers.ServerVariable";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ServerVariablePrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ServerVariablePrism(mirror);
        }

        private static Optional<ServerVariablePrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ServerVariablePrism(mirror));
        }

        private ServerVariablePrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._allowableValues = this.getArrayValues("allowableValues", String.class);
            this._defaultValue = this.getValue("defaultValue", String.class);
            this._description = this.getValue("description", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public List<String> allowableValues() {
            return this._allowableValues;
        }

        public String defaultValue() {
            return this._defaultValue;
        }

        public String description() {
            return this._description;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue allowableValues() {
                return this.values.get("allowableValues");
            }

            public AnnotationValue defaultValue() {
                return this.values.get("defaultValue");
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }

    public static class LicensePrism {
        private final String _name;
        private final String _url;
        private final List<ExtensionPrism> _extensions;
        private final String _identifier;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.info.License";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static LicensePrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new LicensePrism(mirror);
        }

        private static Optional<LicensePrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new LicensePrism(mirror));
        }

        private LicensePrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._url = this.getValue("url", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this._identifier = this.getValue("identifier", String.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        public String identifier() {
            return this._identifier;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue url() {
                return this.values.get("url");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }

            public AnnotationValue identifier() {
                return this.values.get("identifier");
            }
        }
    }

    public static class ContactPrism {
        private final String _name;
        private final String _url;
        private final String _email;
        private final List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.info.Contact";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ContactPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ContactPrism(mirror);
        }

        private static Optional<ContactPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ContactPrism(mirror));
        }

        private ContactPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._url = this.getValue("url", String.class);
            this._email = this.getValue("email", String.class);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public String email() {
            return this._email;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = OpenAPIDefinitionPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = OpenAPIDefinitionPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static final class Values {
            private final Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue url() {
                return this.values.get("url");
            }

            public AnnotationValue email() {
                return this.values.get("email");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }
}

