/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PathSegments {
    static final PathSegments EMPTY = new PathSegments(new Chunks(), Collections.emptySet());
    private final Chunks chunks;
    private final Set<Segment> segments;
    private final List<Segment> withMatrixs = new ArrayList<Segment>();
    private final Set<String> allNames = new HashSet<String>();

    static PathSegments parse(String fullPath) {
        LinkedHashSet<Segment> segments = new LinkedHashSet<Segment>();
        Chunks chunks = new Chunks();
        if ("/".equals(fullPath)) {
            chunks.literal("/");
        } else {
            for (String section : fullPath.split("/")) {
                Segment segment;
                String name;
                if (section.isEmpty()) continue;
                chunks.literal("/");
                if (section.startsWith(":")) {
                    name = section.substring(1);
                    segment = PathSegments.createSegment(name);
                    segments.add(segment);
                    chunks.named(segment.path(name), ':');
                    continue;
                }
                if (PathSegments.isPathParameter(section)) {
                    name = section.substring(1, section.length() - 1);
                    segment = PathSegments.createSegment(name);
                    segments.add(segment);
                    chunks.named(segment.path(name), section.charAt(0));
                    continue;
                }
                if (PathSegments.isProperty(section)) {
                    name = section.substring(2, section.length() - 1);
                    segment = PathSegments.createPropertySegment(name);
                    segments.add(segment);
                    chunks.named(segment.path(name), section.charAt(0));
                    continue;
                }
                Segment segment2 = PathSegments.createLiteralSegment(section);
                segments.add(segment2);
                chunks.literal(section);
            }
        }
        return new PathSegments(chunks, segments);
    }

    private static boolean isPathParameter(String section) {
        return section.startsWith("{") && section.endsWith("}") || section.startsWith("<") && section.endsWith(">");
    }

    private static boolean isProperty(String section) {
        return section.startsWith("${") && section.endsWith("}");
    }

    private static Segment createLiteralSegment(String section) {
        return new Segment(section, "literal");
    }

    private static Segment createSegment(String val) {
        String[] matrixSplit = val.split(";");
        if (matrixSplit.length == 1) {
            return new Segment(matrixSplit[0]);
        }
        HashSet<String> matrixKeys = new HashSet<String>(Arrays.asList(matrixSplit).subList(1, matrixSplit.length));
        return new Segment(matrixSplit[0], matrixKeys);
    }

    private static Segment createPropertySegment(String val) {
        return new Segment(val, true);
    }

    private PathSegments(Chunks chunks, Set<Segment> segments) {
        this.chunks = chunks;
        this.segments = segments;
        for (Segment segment : segments) {
            segment.addNames(this.allNames);
            if (!segment.hasMatrixParams()) continue;
            this.withMatrixs.add(segment);
        }
    }

    public boolean contains(String varName) {
        return this.allNames.contains(varName);
    }

    public List<Segment> matrixSegments() {
        return this.withMatrixs;
    }

    public Set<Segment> segments() {
        return this.segments;
    }

    public Segment segment(String varName) {
        for (Segment segment : this.segments) {
            if (!segment.isPathParameter(varName)) continue;
            return segment;
        }
        return null;
    }

    public String fullPath() {
        return this.fullPath("{", "}");
    }

    public String fullPathColon() {
        return this.fullPath(":", "");
    }

    private String fullPath(String prefix, String suffix) {
        return this.chunks.fullPath(prefix, suffix);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    private static class Chunks {
        private final List<Chunk> chunks = new ArrayList<Chunk>();

        private Chunks() {
        }

        void named(String name, char firstChar) {
            this.chunks.add(new Chunk(name, firstChar));
        }

        void literal(String val) {
            this.chunks.add(new LiteralChunk(val));
        }

        String fullPath(String prefix, String suffix) {
            StringBuilder sb = new StringBuilder();
            for (Chunk chunk : this.chunks) {
                chunk.append(sb, prefix, suffix);
            }
            return sb.toString();
        }
    }

    public static class Segment {
        private final String name;
        private final String sanitizedName;
        private final String literalSection;
        private final Set<String> matrixKeys;
        private final Set<String> matrixVarNames;
        private final boolean property;

        Segment(String name) {
            this.name = name.startsWith("+") ? name.substring(1) : name.split(":")[0];
            this.sanitizedName = Util.sanitizeName(name);
            this.literalSection = null;
            this.matrixKeys = null;
            this.matrixVarNames = null;
            this.property = false;
        }

        Segment(String name, boolean isProperty) {
            this.name = name;
            this.sanitizedName = null;
            this.literalSection = null;
            this.matrixKeys = null;
            this.matrixVarNames = null;
            this.property = isProperty;
        }

        Segment(String name, Set<String> matrixKeys) {
            this.name = name;
            this.sanitizedName = Util.sanitizeName(name);
            this.literalSection = null;
            this.matrixKeys = matrixKeys;
            this.matrixVarNames = new HashSet<String>();
            this.property = false;
            for (String key : matrixKeys) {
                this.matrixVarNames.add(this.combine(name, key));
            }
        }

        public Segment(String section, String literalDummy) {
            this.literalSection = section;
            this.name = null;
            this.sanitizedName = null;
            this.matrixKeys = null;
            this.matrixVarNames = null;
            this.property = false;
        }

        void addNames(Set<String> allNames) {
            if (this.name != null) {
                allNames.add(this.name);
            }
        }

        boolean hasMatrixParams() {
            return this.matrixKeys != null && !this.matrixKeys.isEmpty();
        }

        private String combine(String name, String key) {
            return name + Character.toUpperCase(key.charAt(0)) + key.substring(1);
        }

        public Set<String> matrixKeys() {
            return this.matrixKeys;
        }

        public String name() {
            return this.name;
        }

        public String literalSection() {
            return this.literalSection;
        }

        public boolean isLiteral() {
            return this.literalSection != null;
        }

        public boolean isProperty() {
            return this.property;
        }

        boolean isPathParameter(String varName) {
            return this.name != null && this.name.equals(varName) || this.matrixKeys != null && (this.matrixVarNames.contains(varName) || this.matrixKeys.contains(varName));
        }

        void writeGetVal(Append writer, String varName, PlatformAdapter platform) {
            if (!this.hasMatrixParams()) {
                platform.writeReadParameter(writer, ParamType.PATHPARAM, this.name);
            } else {
                writer.append("%s_segment.", this.sanitizedName);
                if (this.name.equals(varName)) {
                    writer.append("val()");
                } else {
                    writer.append("matrix(\"%s\")", this.matrixKey(varName));
                }
            }
        }

        private String matrixKey(String varName) {
            if (!varName.startsWith(this.name)) {
                return varName;
            }
            String key = varName.substring(this.name.length());
            return Character.toLowerCase(key.charAt(0)) + key.substring(1);
        }

        public void writeCreateSegment(Append writer, PlatformAdapter platform) {
            writer.append(platform.indent());
            writer.append("  PathSegment %s_segment = PathSegment.of(", this.sanitizedName);
            platform.writeReadParameter(writer, ParamType.PATHPARAM, this.name + "_segment");
            writer.append(");").eol();
        }

        boolean isRequired(String varName) {
            return this.name.equals(varName);
        }

        String path(String section) {
            if (!this.hasMatrixParams()) {
                return section;
            }
            return this.name + "_segment";
        }
    }

    private static class Chunk {
        final String value;
        final char firstChar;

        private Chunk(String value, char firstChar) {
            this.value = value;
            this.firstChar = firstChar;
        }

        void append(StringBuilder fullPath, String prefix, String suffix) {
            if ('<' == this.firstChar) {
                fullPath.append('<').append(this.value).append('>');
            } else {
                fullPath.append(prefix).append(this.value).append(suffix);
            }
        }
    }

    private static class LiteralChunk
    extends Chunk {
        private LiteralChunk(String value) {
            super(value, ' ');
        }

        @Override
        void append(StringBuilder fullPath, String prefix, String suffix) {
            fullPath.append(this.value);
        }
    }
}

