/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.APContext;
import io.avaje.http.generator.core.ModuleInfoReader;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.openapi.DocContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    public static void init(ProcessingEnvironment env, PlatformAdapter adapter, boolean generateOpenAPI) {
        Ctx oldCtx = CTX.get();
        Ctx newCTX = new Ctx(env, adapter, generateOpenAPI);
        if (oldCtx != null && newCTX.docContext == null) {
            newCTX.docContext = oldCtx.docContext;
        }
        CTX.set(newCTX);
    }

    public static void init(ProcessingEnvironment env, PlatformAdapter adapter) {
        ProcessingContext.init(env, adapter, true);
    }

    public static TypeElement typeElement(String canonicalName) {
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(canonicalName);
    }

    public static boolean isOpenApiAvailable() {
        return ProcessingContext.CTX.get().openApiAvailable;
    }

    public static boolean useJavax() {
        return ProcessingContext.CTX.get().useJavax;
    }

    public static boolean useComponent() {
        return ProcessingContext.CTX.get().useComponent;
    }

    public static void logError(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    public static void logError(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static void logWarn(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void logWarn(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    public static void logDebug(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    public static JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, origin);
    }

    public static FileObject createMetaInfWriter(String target) throws IOException {
        return ProcessingContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", target, new Element[0]);
    }

    public static JavaFileObject createWriter(String cls) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, new Element[0]);
    }

    public static String docComment(Element param) {
        return ProcessingContext.CTX.get().elementUtils.getDocComment(param);
    }

    public static DocContext doc() {
        return ProcessingContext.CTX.get().docContext;
    }

    public static TypeElement asElement(TypeMirror typeMirror) {
        return (TypeElement)ProcessingContext.CTX.get().typeUtils.asElement(typeMirror);
    }

    public static TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        return ProcessingContext.CTX.get().typeUtils.asMemberOf(declaredType, element);
    }

    public static List<ExecutableElement> superMethods(Element element, String methodName) {
        Types types = ProcessingContext.CTX.get().typeUtils;
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> {
            TypeElement superClass = (TypeElement)types.asElement((TypeMirror)superType);
            for (ExecutableElement method : ElementFilter.methodsIn(ProcessingContext.CTX.get().elementUtils.getAllMembers(superClass))) {
                if (!method.getSimpleName().contentEquals(methodName)) continue;
                return method;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static PlatformAdapter platform() {
        return ProcessingContext.CTX.get().readAdapter;
    }

    public static void setPlatform(PlatformAdapter platform) {
        ProcessingContext.CTX.get().readAdapter = platform;
    }

    public static String diAnnotation() {
        return ProcessingContext.CTX.get().diAnnotation;
    }

    public static boolean instrumentAllWebMethods() {
        return ProcessingContext.CTX.get().instrumentAllMethods;
    }

    public static boolean useJsonb() {
        try {
            return ProcessingContext.CTX.get().elementUtils.getTypeElement("io.avaje.jsonb.Jsonb") != null || Class.forName("io.avaje.jsonb.Jsonb") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean disabledDirectWrites() {
        return ProcessingContext.CTX.get().disableDirectWrites;
    }

    public static boolean javalin6() {
        return ProcessingContext.CTX.get().javalin6;
    }

    public static Filer filer() {
        return ProcessingContext.CTX.get().filer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAssignable2Interface(String type, String superType) {
        if (type.equals(superType)) return true;
        if (!Optional.ofNullable(ProcessingContext.typeElement(type)).stream().flatMap(ProcessingContext::superTypes).anyMatch(superType::equals)) return false;
        return true;
    }

    static Stream<String> superTypes(Element element) {
        Types types = ProcessingContext.CTX.get().typeUtils;
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(ProcessingContext.superTypes(e), Stream.of(e))).map(Object::toString);
    }

    public static void validateModule() {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !module.isUnnamed()) {
            try (BufferedReader bufferedReader = APContext.getModuleInfoReader();){
                ModuleInfoReader reader = new ModuleInfoReader(module, bufferedReader);
                reader.requires().forEach(r -> {
                    if (!r.isStatic() && r.getDependency().getQualifiedName().contentEquals("io.avaje.http.api.javalin")) {
                        ProcessingContext.logWarn(module, "io.avaje.http.api.javalin only contains SOURCE retention annotations. It should added as `requires static`", new Object[0]);
                    }
                });
                reader.validateServices("io.avaje.http.client.HttpClient.GeneratedComponent", ProcessingContext.CTX.get().clientFQN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static ModuleElement getModuleElement(Element e) {
        if (e == null || e instanceof ModuleElement) {
            return (ModuleElement)e;
        }
        return ProcessingContext.getModuleElement(e.getEnclosingElement());
    }

    static Elements elements() {
        return ProcessingContext.CTX.get().elementUtils;
    }

    private static boolean buildPluginAvailable() {
        return ProcessingContext.resourceExists("target/avaje-plugin-exists.txt") || ProcessingContext.resourceExists("build/avaje-plugin-exists.txt");
    }

    private static boolean resourceExists(String relativeName) {
        try {
            String resource = ProcessingContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", relativeName).toUri().toString().replaceFirst("/target/classes", "").replaceFirst("/build/classes/java/main", "");
            return Paths.get(new URI(resource)).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void addClientComponent(String clientFQN) {
        ProcessingContext.CTX.get().clientFQN.add(clientFQN);
    }

    private static final class Ctx {
        private PlatformAdapter readAdapter;
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;
        private boolean openApiAvailable;
        private DocContext docContext;
        private final boolean useComponent;
        private final boolean useJavax;
        private final String diAnnotation;
        private final boolean instrumentAllMethods;
        private final boolean disableDirectWrites;
        private final boolean javalin6;
        private final Set<String> clientFQN = new HashSet<String>();

        Ctx(ProcessingEnvironment env, PlatformAdapter adapter, boolean generateOpenAPI) {
            this.readAdapter = adapter;
            this.messager = env.getMessager();
            this.filer = env.getFiler();
            this.elementUtils = env.getElementUtils();
            this.typeUtils = env.getTypeUtils();
            if (generateOpenAPI) {
                this.openApiAvailable = this.elementUtils.getTypeElement("io.swagger.v3.oas.annotations.OpenAPIDefinition") != null;
                this.docContext = new DocContext(env, this.openApiAvailable);
            }
            Map<String, String> options = env.getOptions();
            String singletonOverride = options.get("useSingleton");
            this.instrumentAllMethods = Boolean.parseBoolean(options.get("instrumentRequests"));
            this.disableDirectWrites = Boolean.parseBoolean(options.get("disableDirectWrites"));
            this.useComponent = singletonOverride != null ? !Boolean.parseBoolean(singletonOverride) : this.elementUtils.getTypeElement("io.avaje.inject.Component") != null;
            this.diAnnotation = this.useComponent ? "@Component" : "@Singleton";
            boolean javax = this.elementUtils.getTypeElement("javax.inject.Singleton") != null;
            boolean jakarta = this.elementUtils.getTypeElement("jakarta.inject.Singleton") != null;
            String override = options.get("useJavax");
            this.useJavax = override != null || javax && jakarta ? Boolean.parseBoolean(override) : javax;
            this.javalin6 = this.elementUtils.getTypeElement("io.javalin.config.RouterConfig") != null;
        }
    }
}

