/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.TypeHandler;
import io.avaje.http.generator.core.UType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TypeMap {
    private static final Map<String, TypeHandler> types = new HashMap<String, TypeHandler>();

    TypeMap() {
    }

    private static void add(TypeHandler h) {
        types.put(h.importTypes().get(0), h);
    }

    static TypeHandler get(String type) {
        return types.get(type);
    }

    static TypeHandler collectionHandler(UType type, boolean isEnum) {
        TypeHandler handler = types.get(type.param0());
        if (!isEnum && handler == null) {
            return null;
        }
        return types.computeIfAbsent(type.full(), k -> CollectionHandler.of(type, isEnum, handler));
    }

    static TypeHandler optionalHandler(UType type, boolean isEnum) {
        TypeHandler handler = types.get(type.param0());
        if (!isEnum && handler == null) {
            return null;
        }
        return types.computeIfAbsent(type.full(), k -> OptionalHandler.of(type, isEnum, handler));
    }

    static TypeHandler enumParamHandler(UType type) {
        return new EnumHandler(type);
    }

    static {
        types.put("int", new IntHandler());
        types.put("long", new PLongHandler());
        types.put("double", new PDoubleHandler());
        types.put("float", new PFloatHandler());
        types.put("boolean", new BoolHandler());
        types.put("java.lang.String", new StringHandler());
        types.put("java.lang.Integer", new IntegerHandler());
        types.put("java.lang.Long", new LongHandler());
        types.put("java.lang.Double", new DoubleHandler());
        types.put("java.lang.Float", new FloatHandler());
        types.put("java.lang.Boolean", new BooleanHandler());
        TypeMap.add(new UuidHandler());
        TypeMap.add(new BigDecimalHandler());
        TypeMap.add(new BigIntegerHandler());
        TypeMap.add(new LocalDateHandler());
        TypeMap.add(new LocalTimeHandler());
        TypeMap.add(new LocalDateTimeHandler());
        TypeMap.add(new InstantHandler());
        TypeMap.add(new OffsetDateTimeHandler());
    }

    static final class EnumHandler
    extends ObjectHandler {
        private final UType type;

        EnumHandler(UType type) {
            super(type.mainType(), type.shortName());
            this.type = type;
        }

        @Override
        public String toMethod() {
            return "(" + this.type.shortTypeNested() + ") toEnum(" + this.type.shortTypeNested() + ".class, ";
        }

        @Override
        public String asMethod() {
            return "(" + this.type.shortTypeNested() + ") asEnum(" + this.type.shortTypeNested() + ".class, ";
        }
    }

    static final class OptionalHandler
    implements TypeHandler {
        private final List<String> importTypes;
        private final String shortName;
        private final String toMethod;

        private static OptionalHandler of(UType type, boolean isEnum, TypeHandler sourceHandler) {
            TypeHandler handler = isEnum ? TypeMap.enumParamHandler(type.paramRaw()) : sourceHandler;
            return new OptionalHandler(handler, isEnum);
        }

        private OptionalHandler(TypeHandler handler, boolean isEnum) {
            this.importTypes = new ArrayList<String>(handler.importTypes());
            this.importTypes.add("io.avaje.http.api.PathTypeConversion");
            this.shortName = handler.shortName();
            this.toMethod = OptionalHandler.buildToMethod(handler, isEnum);
        }

        static String buildToMethod(TypeHandler handler, boolean isEnum) {
            if (isEnum) {
                return "optional(qp -> " + handler.toMethod() + " qp), ";
            }
            if ("String".equals(handler.shortName())) {
                return "optional(";
            }
            return "optional(PathTypeConversion::as" + handler.shortName() + ", ";
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public List<String> importTypes() {
            return this.importTypes;
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public String asMethod() {
            return null;
        }

        @Override
        public String toMethod() {
            return this.toMethod;
        }
    }

    static final class CollectionHandler
    implements TypeHandler {
        private final List<String> importTypes;
        private final String shortName;
        private final String toMethod;

        private static CollectionHandler of(UType type, boolean isEnum, TypeHandler sourceHandler) {
            TypeHandler handler = isEnum ? TypeMap.enumParamHandler(type.paramRaw()) : sourceHandler;
            boolean isSet = type.mainType().startsWith("java.util.Set");
            return new CollectionHandler(handler, isSet, isEnum);
        }

        private CollectionHandler(TypeHandler handler, boolean set, boolean isEnum) {
            this.importTypes = new ArrayList<String>(handler.importTypes());
            this.importTypes.add("io.avaje.http.api.PathTypeConversion");
            this.shortName = handler.shortName();
            String _toMethod = (set ? "set" : "list") + "(" + (isEnum ? "qp -> " + handler.toMethod() + " qp)" : "PathTypeConversion::as" + this.shortName) + ", ";
            this.toMethod = _toMethod.replace("PathTypeConversion::asString", "Object::toString");
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public List<String> importTypes() {
            return this.importTypes;
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public String asMethod() {
            return null;
        }

        @Override
        public String toMethod() {
            return this.toMethod;
        }
    }

    static final class IntHandler
    extends Primitive {
        IntHandler() {
            super("Int");
        }
    }

    static final class PLongHandler
    extends Primitive {
        PLongHandler() {
            super("Long");
        }
    }

    static final class PDoubleHandler
    extends Primitive {
        PDoubleHandler() {
            super("Double");
        }
    }

    static final class PFloatHandler
    extends Primitive {
        PFloatHandler() {
            super("Float");
        }
    }

    static final class BoolHandler
    extends Primitive {
        BoolHandler() {
            super("asBool(", "boolean");
        }
    }

    static final class StringHandler
    extends JavaLangType {
        StringHandler() {
            super("String");
        }

        @Override
        public String asMethod() {
            return null;
        }

        @Override
        public String toMethod() {
            return null;
        }
    }

    static final class IntegerHandler
    extends JavaLangType {
        IntegerHandler() {
            super("Integer");
        }

        @Override
        public String asMethod() {
            return "asInteger(";
        }

        @Override
        public String toMethod() {
            return "toInteger(";
        }
    }

    static final class LongHandler
    extends JavaLangType {
        LongHandler() {
            super("Long");
        }

        @Override
        public String asMethod() {
            return "asLong(";
        }

        @Override
        public String toMethod() {
            return "toLong(";
        }
    }

    static final class DoubleHandler
    extends JavaLangType {
        DoubleHandler() {
            super("Double");
        }

        @Override
        public String asMethod() {
            return "asDouble(";
        }

        @Override
        public String toMethod() {
            return "toDouble(";
        }
    }

    static final class FloatHandler
    extends JavaLangType {
        FloatHandler() {
            super("Float");
        }

        @Override
        public String asMethod() {
            return "asFloat(";
        }

        @Override
        public String toMethod() {
            return "toFloat(";
        }
    }

    static final class BooleanHandler
    extends JavaLangType {
        BooleanHandler() {
            super("Boolean");
        }

        @Override
        public String asMethod() {
            return "asBool(";
        }

        @Override
        public String toMethod() {
            return "toBoolean(";
        }
    }

    static final class UuidHandler
    extends ObjectHandler {
        UuidHandler() {
            super("java.util.UUID", "UUID");
        }
    }

    static final class BigDecimalHandler
    extends ObjectHandler {
        BigDecimalHandler() {
            super("java.math.BigDecimal", "BigDecimal");
        }
    }

    static final class BigIntegerHandler
    extends ObjectHandler {
        BigIntegerHandler() {
            super("java.math.BigInteger", "BigInteger");
        }
    }

    static final class LocalDateHandler
    extends ObjectHandler {
        LocalDateHandler() {
            super("java.time.LocalDate", "LocalDate");
        }
    }

    static final class LocalTimeHandler
    extends ObjectHandler {
        LocalTimeHandler() {
            super("java.time.LocalTime", "LocalTime");
        }
    }

    static final class LocalDateTimeHandler
    extends ObjectHandler {
        LocalDateTimeHandler() {
            super("java.time.LocalDateTime", "LocalDateTime");
        }
    }

    static final class InstantHandler
    extends ObjectHandler {
        InstantHandler() {
            super("java.time.Instant", "Instant");
        }
    }

    static final class OffsetDateTimeHandler
    extends ObjectHandler {
        OffsetDateTimeHandler() {
            super("java.time.OffsetDateTime", "OffsetDateTime");
        }
    }

    static abstract class ObjectHandler
    implements TypeHandler {
        private final String importType;
        private final String shortName;
        private final String asMethod;
        private final String toMethod;

        ObjectHandler(String importType, String shortName) {
            this.importType = importType;
            this.shortName = shortName;
            this.asMethod = "as" + shortName + "(";
            this.toMethod = "to" + shortName + "(";
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public List<String> importTypes() {
            return List.of(this.importType);
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public String asMethod() {
            return this.asMethod;
        }

        @Override
        public String toMethod() {
            return this.toMethod;
        }
    }

    static abstract class Primitive
    implements TypeHandler {
        private final String type;
        private final String asMethod;

        Primitive(String asType) {
            this.asMethod = "as" + asType + "(";
            this.type = asType.toLowerCase();
        }

        Primitive(String asMethod, String type) {
            this.asMethod = asMethod;
            this.type = type;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public String shortName() {
            return this.type;
        }

        @Override
        public String asMethod() {
            return this.asMethod;
        }

        @Override
        public String toMethod() {
            return this.asMethod;
        }

        @Override
        public List<String> importTypes() {
            return List.of();
        }
    }

    static abstract class JavaLangType
    implements TypeHandler {
        final String shortName;

        JavaLangType(String shortName) {
            this.shortName = shortName;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public List<String> importTypes() {
            return List.of();
        }
    }
}

